/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph;

import com.ez.workspace.icons.LoadSVGImages;
import com.tomsawyer.graphicaldrawing.awt.TSEAbstractImage;
import com.tomsawyer.graphicaldrawing.awt.TSEImage;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTSESVGImage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LoadTSESVGImage.class);
    private static Map images = Collections.synchronizedMap(new HashMap());

    public static synchronized TSESVGImage loadImage(Class classForLoader, String imageResource) {
        boolean loaded = false;
        TSESVGImage image = null;
        int maxtries = 5;
        int currentTry = 0;
        while (!loaded) {
            L.debug("trying to load image: {}", (Object)imageResource);
            try {
                if (images.containsKey(imageResource)) {
                    image = (TSESVGImage)images.get(imageResource);
                    L.debug("image already loaded: {}", (Object)image.getResource());
                    loaded = true;
                } else {
                    image = TSESVGImage.loadImage((Class)classForLoader, (String)imageResource);
                    L.debug("image loaded: {}", (Object)image.getResource());
                    if (image != null && image.getResource() != null && image.getResource() != "") {
                        images.put(imageResource, image);
                        loaded = true;
                    }
                }
            }
            catch (Exception e) {
                L.error("image failed to load: {}", (Object)imageResource, (Object)e);
            }
            if (loaded) continue;
            if (++currentTry == maxtries) {
                L.debug("could not load. give up retrying. too many failures");
                break;
            }
            L.debug("could not load. yielding and retrying");
            Thread.yield();
        }
        return image;
    }

    public static synchronized TSEImage getImage(Class classForLoader, String imageResource) {
        TSEImage image;
        block8: {
            image = null;
            boolean loaded = false;
            try {
                try {
                    if (images.containsKey(imageResource)) {
                        image = (TSEImage)images.get(imageResource);
                        loaded = true;
                    } else {
                        image = new TSEImage(classForLoader, imageResource);
                        L.trace("image loaded: {}", (Object)image.getResource());
                        if (image != null && image.getResource() != null && image.getResource() != "") {
                            images.put(imageResource, image);
                            loaded = true;
                        }
                    }
                }
                catch (Exception e) {
                    L.error("error getting image {}", (Object)imageResource, (Object)e);
                    L.debug("tried to load: {}; result: {}, loaded={}", new Object[]{imageResource, image, loaded});
                    break block8;
                }
            }
            catch (Throwable throwable) {
                L.debug("tried to load: {}; result: {}, loaded={}", new Object[]{imageResource, image, loaded});
                throw throwable;
            }
            L.debug("tried to load: {}; result: {}, loaded={}", new Object[]{imageResource, image, loaded});
        }
        return image;
    }

    public static TSEAbstractImage getAnnotsDecorationImage() {
        return LoadTSESVGImage.getImage(LoadSVGImages.class, "pencil.png");
    }
}

