/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph;

import com.ez.workspace.analysis.graph.EZHidingListener;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.complexity.TSEHidingManager;
import java.util.ArrayList;
import java.util.List;

public class EZNodeHidingManager
extends TSEHidingManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<EZHidingListener> listeners = new ArrayList<EZHidingListener>();
    private boolean group = false;
    private List<TSDEdge> hiddenEdges = new ArrayList<TSDEdge>();
    private List<TSDEdge> unHiddenEdges = new ArrayList<TSDEdge>();
    private List<TSDNode> hiddenNodes = new ArrayList<TSDNode>();
    private List<TSDNode> unHiddenNodes = new ArrayList<TSDNode>();
    private String groupSource;

    public EZNodeHidingManager(TSEGraphManager arg0) {
        super(arg0);
    }

    public void startEventGroup() {
        this.group = true;
    }

    public void endEventGroup() {
        this.notifyGroup();
        this.groupSource = null;
        this.group = false;
    }

    private void notifyGroup() {
        for (EZHidingListener listener : this.listeners) {
            listener.edgesHidden(new ArrayList<TSDEdge>(this.hiddenEdges));
        }
        this.hiddenEdges.clear();
        for (EZHidingListener listener : this.listeners) {
            listener.edgesUnHidden(new ArrayList<TSDEdge>(this.unHiddenEdges));
        }
        this.unHiddenEdges.clear();
        for (EZHidingListener listener : this.listeners) {
            listener.nodesHidden(new ArrayList<TSDNode>(this.hiddenNodes));
        }
        this.hiddenNodes.clear();
        for (EZHidingListener listener : this.listeners) {
            listener.nodesUnHidden(new ArrayList<TSDNode>(this.unHiddenNodes));
        }
        this.unHiddenNodes.clear();
    }

    public void add(EZHidingListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void remove(EZHidingListener listener) {
        this.listeners.remove(listener);
    }

    public void onEdgeHidden(TSDEdge edge) {
        super.onEdgeHidden(edge);
        if (this.group) {
            this.hiddenEdges.add(edge);
        } else {
            for (EZHidingListener listener : this.listeners) {
                listener.edgeHidden(edge);
            }
        }
    }

    public void onEdgeUnhidden(TSDEdge edge) {
        super.onEdgeUnhidden(edge);
        if (this.group) {
            this.unHiddenEdges.add(edge);
        } else {
            for (EZHidingListener listener : this.listeners) {
                listener.edgeUnhidden(edge);
            }
        }
    }

    public void onNodeHidden(TSDNode node) {
        super.onNodeHidden(node);
        if (this.group) {
            this.hiddenNodes.add(node);
        } else {
            for (EZHidingListener listener : this.listeners) {
                listener.nodeHidden(node);
            }
        }
    }

    public void onNodeUnhidden(TSDNode node) {
        super.onNodeUnhidden(node);
        if (this.group) {
            this.unHiddenNodes.add(node);
        } else {
            for (EZHidingListener listener : this.listeners) {
                listener.nodeUnidden(node);
            }
        }
    }

    public String getGroupSource() {
        return this.groupSource;
    }

    public void setGroupSource(String groupSource) {
        this.groupSource = groupSource;
    }
}

