/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis.graph;

import com.ez.workspace.analysis.graph.EZNodeBuilder;
import com.ez.workspace.analysis.graph.EZNodeHidingManager;
import com.ez.workspace.analysis.graph.model.AnalysisGraph;
import com.tomsawyer.drawing.complexity.TSHidingManager;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.builder.TSDefaultEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.composite.TSCompositeEdgeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSConditionalUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSGroupUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSPolygonUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSSourceArrowUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElementPoint;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSLayoutInputTailor;

public class AnalysisGraphManager
extends TSEGraphManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final long serialVersionUID = 533272885036629039L;
    public static final int EZGRAPH = 1000;
    public static final int EZEDGE = 1000;
    private EZNodeHidingManager hidingManager;
    public TSServiceInputData inputData = new TSServiceInputData();
    public TSLayoutInputTailor inputTailor = new TSLayoutInputTailor((TSServiceInputDataInterface)this.inputData);
    public static final String TEXT_FONT = "Text_Font";
    public static final String ANNOTATION = "annotation";
    public static final String MARKED = "marked";
    public static final String UI_IMAGE = "uiImage";
    public static final String IMAGE_UI_STYLE = "uiStyle";
    public static final String TEXT_COLOR = "Text_Color";
    public static final String FILL_COLOR = "Fill_Color";
    public static final String COLOR = "Color";
    public static final String COLOR_TEXT_UI_SVG = "color text for node with image";
    public static final String SELECTED_BORDER_COLOR = "Selected_Border_Color";
    public static final String MARKED_BORDER_COLOR = "Marked_Border_Color";
    public static final String EDGE_STYLE = "Edge_Style";
    public static final String EXPANDABLE = "expandable node";
    public static final String RESTRICTED = "restricted node in callgraph";
    public static final String SOURCE_ARROW = "sourceArrow";

    public AnalysisGraphManager() {
        this.setNodeBuilder((TSNodeBuilder)this.makeNodeBuilder());
        this.setEdgeBuilder(this.makeEdgeBuilder());
        this.hidingManager = new EZNodeHidingManager(this);
    }

    public TSGraph newGraph(int type) {
        AnalysisGraph graph = null;
        graph = type == 1000 ? new AnalysisGraph() : super.newGraph(type);
        return graph;
    }

    public TSEdgeBuilder makeEdgeBuilder() {
        TSDefaultEdgeBuilder deb = new TSDefaultEdgeBuilder();
        TSGroupUIElement root = (TSGroupUIElement)((TSCompositeEdgeUI)deb.getEdgeUI()).getRootElement();
        TSSourceArrowUIElement tssourcearrowuielement = new TSSourceArrowUIElement(SOURCE_ARROW);
        TSPolygonUIElement tspolygonuielement = new TSPolygonUIElement("filledTriangle");
        tspolygonuielement.getPoints().add(new TSUIElementPoint(-0.5, 0.0, 0.5, 0.0));
        tspolygonuielement.getPoints().add(new TSUIElementPoint(0.5, 0.0, 0.0, 0.0));
        tspolygonuielement.getPoints().add(new TSUIElementPoint(-0.5, 0.0, -0.5, 0.0));
        tssourcearrowuielement.setChild((TSUIElement)tspolygonuielement);
        TSConditionalUIElement condition = new TSConditionalUIElement("condition", "$stringEquals(true, <sourceArrow>)");
        condition.setIfElement((TSUIElement)tssourcearrowuielement);
        root.addElement((TSUIElement)condition);
        deb.setAttribute(EDGE_STYLE, (Object)"<Edge_Style>");
        return deb;
    }

    public EZNodeBuilder makeNodeBuilder() {
        EZNodeBuilder nodeBuilder = new EZNodeBuilder();
        return nodeBuilder;
    }

    public TSHidingManager getHidingManager() {
        return this.hidingManager;
    }
}

