/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace;

import com.ez.internal.graphmodel.EZSelection;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.SourceSelectionInfoSg;
import com.ez.workspace.ui.internal.Messages;
import com.ez.workspace.utils.WorkspaceLogUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenEditorListener
implements ISelectionListener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(OpenEditorListener.class);

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        L.debug("----------  in OpenEditorListener -------");
        if (selection instanceof EZSelection) {
            L.debug("EZSelection in OpenEditorListener -------");
            EZSelection ezsel = (EZSelection)selection;
            EZEntityID selectedID = ezsel.getSelectedEntity();
            SourceSelectionInfoSg sg = (SourceSelectionInfoSg)selectedID.getSegment(SourceSelectionInfoSg.class);
            if (sg != null) {
                this.openEditor(sg);
            }
        }
    }

    private void openEditor(final SourceSelectionInfoSg sapDebugSg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
                IResource resource = sapDebugSg.getResourceFile();
                try {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                        if (!"abap".equalsIgnoreCase(file.getFileExtension())) {
                            final int[] sgBounds = sapDebugSg.getSgBounds();
                            if (sgBounds != null) {
                                if (editor != null) {
                                    FileEditorInput input = new FileEditorInput(file);
                                    final AbstractDecoratedTextEditor edi = (AbstractDecoratedTextEditor)editor;
                                    final IDocument doc = edi.getDocumentProvider().getDocument((Object)input);
                                    edi.resetHighlightRange();
                                    try {
                                        Shell panel = edi.getEditorSite().getShell();
                                        panel.getDisplay().syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                int start = -1;
                                                int length = -1;
                                                int[] offsetAndLength = OpenEditorListener.this.getStartOffsetAndLength(sgBounds, doc);
                                                start = offsetAndLength[0];
                                                length = offsetAndLength[1];
                                                edi.selectAndReveal(start, length);
                                                if (!edi.getSite().getPage().isPartVisible((IWorkbenchPart)edi)) {
                                                    edi.getSite().getPage().activate((IWorkbenchPart)edi);
                                                }
                                            }
                                        });
                                    }
                                    catch (IllegalArgumentException x) {
                                        L.debug("selectionChanged.msg ----> {}", (Object)x.getMessage());
                                        edi.resetHighlightRange();
                                    }
                                } else {
                                    L.debug("editor is null. External editor was probably opened for {}", (Object)file.getFullPath());
                                }
                            } else {
                                L.debug("no line information was provided");
                            }
                        }
                    }
                }
                catch (PartInitException e) {
                    WorkspaceLogUtil.warn((String)Messages.getString(OpenEditorListener.class, "editorNotOpened.log", new Object[]{resource}), (Throwable)e);
                }
            }
        });
    }

    private int[] getStartOffsetAndLength(int[] sgBounds, IDocument document) {
        int startOffset = 0;
        int selLength = 0;
        if (document != null) {
            int startLine = sgBounds[0] - 1;
            int startColumn = sgBounds[1];
            int endLine = sgBounds[2] - 1;
            int endColumn = sgBounds[3];
            L.trace("sl = {} el = {} sc = {} ec = {}", new Object[]{sgBounds[0], sgBounds[2], sgBounds[1], sgBounds[3]});
            try {
                startOffset = document.getLineOffset(startLine);
                startOffset += startColumn - 1;
                if (endLine != startLine) {
                    selLength = document.getLineOffset(endLine) - startOffset;
                    selLength += endColumn - 1;
                } else {
                    selLength += endColumn - startColumn;
                }
            }
            catch (BadLocationException ble) {
                L.debug("fileChanged, {}", (Object)ble.getMessage(), (Object)ble);
            }
        }
        return new int[]{startOffset, selLength};
    }
}

