/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.model;

import com.ez.ann.model.AnnResource;
import com.ez.ann.model.EZKeyword;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class EZAnnotation {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Integer dbId;
    private String AID = UUID.randomUUID().toString();
    private String name;
    private Properties details;
    private Set<AnnResource> resources;
    private Set<String> rids;
    private Set<String> hyperlinks;
    private Set<EZKeyword> keywords;
    private Date date;

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public String getAID() {
        return this.AID;
    }

    public void setAID(String aID) {
        this.AID = aID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUser() {
        String usr = null;
        if (this.details != null) {
            usr = this.details.getProperty("user");
        }
        return usr;
    }

    public void setUser(String user) {
        if (user == null) {
            throw new RuntimeException("User cannot be null!");
        }
        if (this.details == null) {
            this.details = new Properties();
        }
        this.details.put("user", user);
    }

    public void addResource(AnnResource res) {
        if (this.resources == null) {
            this.resources = new HashSet<AnnResource>();
        }
        this.resources.add(res);
        this.addRID(res.getRID());
    }

    private void addRID(String RID) {
        if (this.rids == null) {
            this.rids = new HashSet<String>();
        }
        this.rids.add(RID);
    }

    public void setResources(Set<AnnResource> resrs) {
        this.resources = resrs;
    }

    public Set<AnnResource> getResources() {
        return this.resources;
    }

    public Set<String> getRIDs() {
        return this.rids;
    }

    public void setDescription(String desc) {
        if (desc == null) {
            throw new RuntimeException("Description cannot be null!");
        }
        if (this.details == null) {
            this.details = new Properties();
        }
        this.details.put("text", desc);
    }

    public String getDescription() {
        String d = null;
        if (this.details != null) {
            d = this.details.getProperty("text");
        }
        return d;
    }

    public void addHyperlink(String hyp) {
        if (hyp == null) {
            throw new RuntimeException("Hyperlink cannot be null!");
        }
        if (this.hyperlinks == null) {
            this.hyperlinks = new HashSet<String>();
        }
        this.hyperlinks.add(hyp);
    }

    public Set<String> getHyperlinks() {
        return this.hyperlinks;
    }

    public void addKeyword(EZKeyword key) {
        if (key == null) {
            throw new RuntimeException("Keyword cannot be null!");
        }
        if (this.keywords == null) {
            this.keywords = new HashSet<EZKeyword>();
        }
        this.keywords.add(key);
    }

    public Set<EZKeyword> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Collection<EZKeyword> keys) {
        this.keywords = new HashSet<EZKeyword>(keys);
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public Date getDate() {
        return this.date;
    }
}

