/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.model;

import com.ez.ann.db.EZSourceProgramIdentificator;
import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.internal.Messages;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnResource {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(AnnResource.class);
    private static final String ANCESTOR_NOT_SET_VALUE = "ancestorNotSet";
    public static final String PROP_RES_TYPE = "resType";
    public static final String PROP_RES_TYPE_NAME = "resTypeName";
    public static final String PROP_NAME = "name";
    public static final String PROP_QUALIFIER_NAME = "qualifier";
    public static final String PROP_RES_PATH = "resPath";
    public static final String PROP_ISPROGRAM = "isProgram";
    public static final String PROP_PROG_TYPE = "progType";
    public static final String PROP_ANCESTOR_NAME = "hasAncestor";
    private String RID;
    private String projectInfo;
    private int dbId = -1;
    private int version;
    private String prgAncestor = null;
    private Properties prop = new Properties();

    public AnnResource(String RID) {
        this.setRID(RID);
    }

    public AnnResource(String RID, int dbid) {
        this(RID);
        this.dbId = dbid;
    }

    public AnnResource(String RID, String prjInfo, int dbId) {
        this(RID, dbId);
        this.projectInfo = prjInfo;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getRID() {
        return this.RID;
    }

    public void setRID(String rID) {
        this.RID = rID;
        this.setName();
        this.setQName();
        this.setResType();
        this.setProgramDetails();
    }

    public String getProjectInfo() {
        return this.projectInfo;
    }

    public void setProjectInfo(String projectInfo) {
        this.projectInfo = projectInfo;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public String toString() {
        String s = "";
        s = this.getProjectInfo() != null ? Messages.getString(AnnResource.class, "resource.long.identificator", new String[]{this.getProjectInfo(), this.prop.getProperty(PROP_RES_TYPE_NAME), this.prop.getProperty(PROP_NAME)}) : Messages.getString(AnnResource.class, "resource.short.identificator", new String[]{this.prop.getProperty(PROP_RES_TYPE_NAME), this.prop.getProperty(PROP_NAME)});
        return s;
    }

    private void setName() {
        String name = this.prop.getProperty(PROP_NAME);
        if (name == null) {
            name = ResourceIdentificator.getResourceName(this.RID);
            this.prop.put(PROP_NAME, name);
        }
    }

    private void setQName() {
        String name = this.prop.getProperty(PROP_QUALIFIER_NAME);
        if (name == null && (name = ResourceIdentificator.getResourceQualifierName(this.RID)) != null) {
            this.prop.put(PROP_QUALIFIER_NAME, name);
        }
    }

    private void setResType() {
        String resType = this.prop.getProperty(PROP_RES_TYPE);
        if (resType == null) {
            resType = ResourceIdentificator.getResourceTypeInt(this.RID);
            this.prop.put(PROP_RES_TYPE, resType);
            String resTypeName = ResourceIdentificator.getResourceTypeName(resType, null);
            this.prop.put(PROP_RES_TYPE_NAME, resTypeName);
        }
    }

    private void setProgramDetails() {
        boolean isprg = false;
        String propValue = this.prop.getProperty(PROP_ISPROGRAM);
        if (propValue == null) {
            isprg = EZSourceProgramIdentificator.isProgram(this.RID);
            this.prop.put(PROP_ISPROGRAM, (Object)isprg);
        }
        if (isprg && (propValue = this.prop.getProperty(PROP_PROG_TYPE)) == null) {
            String resTypeName;
            propValue = "" + EZSourceProgramIdentificator.getPrgType(this.RID);
            this.prop.put(PROP_PROG_TYPE, propValue);
            if (propValue.equals("1") || propValue.equals("16") || propValue.equals("15")) {
                this.prop.put(PROP_ANCESTOR_NAME, ANCESTOR_NOT_SET_VALUE);
            }
            if ((resTypeName = Utils.getPrgType((String)propValue)) != null) {
                this.prop.put(PROP_RES_TYPE_NAME, resTypeName);
            }
            String path = EZSourceProgramIdentificator.getPrgPath(this.RID);
            this.prop.put(PROP_RES_PATH, path);
        }
    }

    public String getName() {
        return this.prop.getProperty(PROP_NAME);
    }

    public String getQualifierName() {
        return this.prop.getProperty(PROP_QUALIFIER_NAME);
    }

    public String getResourceTypeName() {
        return this.prop.getProperty(PROP_RES_TYPE_NAME);
    }

    public String getResourceType() {
        return this.prop.getProperty(PROP_RES_TYPE);
    }

    public boolean isProgram() {
        return (Boolean)this.prop.get(PROP_ISPROGRAM);
    }

    public String getPrgType() {
        return this.prop.getProperty(PROP_PROG_TYPE);
    }

    public String getPrgPath() {
        return this.prop.getProperty(PROP_RES_PATH);
    }

    public String getAncestorName() {
        String ancName = this.prop.getProperty(PROP_ANCESTOR_NAME);
        if (ANCESTOR_NOT_SET_VALUE.equals(ancName)) {
            this.prgAncestor = null;
            try {
                IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
                IMFProjectHandler ph = service.getProjectHandler(this.projectInfo, null);
                if (ph != null) {
                    try {
                        ph.executeWithLock(ph, new IMFRunnable(){

                            public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                                String q = "SELECT Ancestor from Programs where ProgramId = ?";
                                String[][] rez = conn.executeSQL(q, new Object[]{AnnResource.this.dbId});
                                AnnResource.this.prgAncestor = rez != null ? rez[0][0] : null;
                            }
                        }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception ex) {
                        L.error("", (Throwable)ex);
                    }
                } else {
                    L.trace("no connection available for {}", (Object)this.projectInfo);
                }
            }
            catch (Exception ex) {
                L.error("", (Throwable)ex);
            }
            if (this.prgAncestor == null) {
                this.prgAncestor = "";
            }
            this.prop.setProperty(PROP_ANCESTOR_NAME, this.prgAncestor);
        }
        return this.prop.getProperty(PROP_ANCESTOR_NAME);
    }
}

