/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.EZJclJobIdentificator;
import com.ez.ann.db.EZResourceIdentificator;
import com.ez.ann.db.EZSourceProgramIdentificator;
import com.ez.ann.db.ResourceFindRunnableService;
import com.ez.ann.internal.Messages;
import com.ez.ann.model.AnnResource;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.model.IMFProjectsServiceFacade;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceIdentificator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourceIdentificator.class);
    static final String RID_LINE_SEPARATOR = "\n";
    static final String RID_EQUALS_CHAR = "=";
    static final String RID_NAME_KEY = "name";
    static final String RID_RESOURCETYPE_KEY = "resType";
    static final String RID_QUALIFIER_NAME_KEY = "qualifiername";
    public static final String RID_RESOURCE_TYPE_PROGRAM = "5";
    public static final String RID_RESOURCE_TYPE_JOB = "22";
    public static final String RID_RESOURCE_TYPE_SQLTABLE = "1";
    public static final String RID_RESOURCE_TYPE_SQLFIELD = "187";
    public static final String RID_RESOURCE_TYPE_FILE = "9";
    public static final String RID_RESOURCE_TYPE_CICSBMS = "6";
    public static final String RID_RESOURCE_TYPE_IMSTRAN = "20";
    public static final String RID_RESOURCE_TYPE_IMSDBSEG = "209";
    public static final String RID_RESOURCE_TYPE_IMSMSG = "212";
    public static final String RESOURCETYPE_JCL_JOB = Messages.getString(ResourceIdentificator.class, "resourceType.jcljob");
    public static final String RESOURCETYPE_PROGRAM = Messages.getString(ResourceIdentificator.class, "resourceType.program");
    public static final String RESOURCETYPE_GROUP_OTHER = Messages.getString(ResourceIdentificator.class, "resourceType.group.other");
    public static final String RESOURCETYPE_SQLTABLE = Messages.getString(ResourceIdentificator.class, "resourceType.sqltable");
    public static final String RESOURCETYPE_SQLFIELDTABLE = Messages.getString(ResourceIdentificator.class, "resourceType.sqlfield");
    public static final String RESOURCETYPE_FILE = Messages.getString(ResourceIdentificator.class, "resourceType.file");
    public static final String RESOURCETYPE_CICSMAP = Messages.getString(ResourceIdentificator.class, "resourceType.cicsmap");
    public static final String RESOURCETYPE_IMSTRAN = Messages.getString(ResourceIdentificator.class, "resourceType.imstran");
    public static final String RESOURCETYPE_IMSMSG = Messages.getString(ResourceIdentificator.class, "resourceType.ims.msg");
    public static final String RESOURCETYPE_IMSDBSEG = Messages.getString(ResourceIdentificator.class, "resourceType.imsdbseg");

    public static String getRID(EZObjectType objType) {
        String ret = null;
        Properties RID = new Properties();
        if (objType instanceof EZSourceProgram) {
            ret = EZSourceProgramIdentificator.getRID((EZSourceProgram)objType, RID);
        } else if (objType instanceof EZJobInputType) {
            ret = EZJclJobIdentificator.getRID((EZJobInputType)objType, RID);
        }
        return ret;
    }

    public static String getRID(Object[] results) {
        String ret = null;
        if (results != null && results.length > 0) {
            Object resType = results[0];
            if (RID_RESOURCE_TYPE_PROGRAM.equals(resType)) {
                ret = EZSourceProgramIdentificator.getRID(results);
            } else if (RID_RESOURCE_TYPE_JOB.equals(resType)) {
                ret = EZJclJobIdentificator.getRID(results);
            } else if (RID_RESOURCE_TYPE_SQLTABLE.equals(resType) || RID_RESOURCE_TYPE_SQLFIELD.equals(resType) || RID_RESOURCE_TYPE_FILE.equals(resType) || RID_RESOURCE_TYPE_CICSBMS.equals(resType) || RID_RESOURCE_TYPE_IMSDBSEG.equals(resType) || RID_RESOURCE_TYPE_IMSTRAN.equals(resType) || RID_RESOURCE_TYPE_IMSMSG.equals(resType)) {
                ret = EZResourceIdentificator.getRID(results);
            } else {
                L.warn("unknown resourceType: {}", resType);
            }
        } else {
            L.info("empty data for RID! {}", results);
        }
        return ret;
    }

    protected static String preparePath(String path) {
        if (path != null) {
            path = Matcher.quoteReplacement(path);
        } else {
            L.warn("null path!");
        }
        return path;
    }

    public static Set<AnnResource> getAnnResources(Collection<EZObjectType> inpts) {
        HashSet<AnnResource> resources = new HashSet<AnnResource>();
        Set<AnnResource> tmp = EZSourceProgramIdentificator.getAnnResources(inpts);
        if (tmp != null && !tmp.isEmpty()) {
            resources.addAll(tmp);
        }
        if ((tmp = EZJclJobIdentificator.getAnnResources(inpts)) != null && !tmp.isEmpty()) {
            resources.addAll(tmp);
        }
        return resources;
    }

    public static void saveAnnResr(Integer annId, Map<String, Integer> RIDs, Connection annDbConn, SubMonitor monitor) throws SQLException {
        IMFProjectsServiceFacade projectsService = (IMFProjectsServiceFacade)ServiceUtils.getService(IMFProjectsServiceFacade.class);
        List ezsprjs = projectsService.availableMainframeProjects((IProgressMonitor)monitor);
        if (ezsprjs != null) {
            ResourceFindRunnableService service = (ResourceFindRunnableService)ServiceUtils.getService(ResourceFindRunnableService.class);
            if (service != null) {
                for (String currentPrj : ezsprjs) {
                    L.trace("start find resources on project: {}", (Object)currentPrj);
                    monitor.subTask(Messages.getString(ResourceIdentificator.class, "workingproject.monitor.subtask", new String[]{currentPrj}));
                    String[][] dbRes = service.find(RIDs.keySet(), currentPrj);
                    ResourceIdentificator.saveAnnotResource(annId, RIDs, annDbConn, currentPrj, dbRes);
                    monitor.subTask("");
                }
            } else {
                L.warn("cannot load the service searching resources in projects");
            }
        } else {
            L.warn("no available projects to search for resources in it");
        }
    }

    static void saveAnnotResource(Integer annId, Map<String, Integer> RIDs, Connection annDbConn, String currentPrj, String[][] dbRes) throws SQLException {
        if (dbRes != null && dbRes.length > 0) {
            String sql = "INSERT INTO Resource (annResID, ProjectInfo, dbID, version, resTypeID) VALUES (?,?,?,?,?)";
            PreparedStatement stmt = annDbConn.prepareStatement(sql);
            PreparedStatement projSt = annDbConn.prepareStatement("INSERT INTO AnnDetail (annID, k, project, resType, resName, progType, annResID) VALUES (?,?,?,?,?,?,?)");
            int i = 0;
            while (i < dbRes.length) {
                String RID = dbRes[i][0];
                String resId = dbRes[i][1];
                String version = dbRes[i][2];
                String resTypeId = dbRes[i][3];
                Integer annResId = RIDs.get(RID);
                stmt.setInt(1, annResId);
                stmt.setString(2, currentPrj);
                try {
                    stmt.setInt(3, Integer.valueOf(resId));
                    stmt.setInt(4, Integer.valueOf(version));
                    stmt.setInt(5, Integer.valueOf(resTypeId));
                    stmt.addBatch();
                }
                catch (NumberFormatException ex) {
                    L.warn("wrong results: {}", (Object)dbRes, (Object)ex);
                }
                projSt.setInt(1, annId);
                projSt.setString(2, "resource");
                projSt.setString(3, currentPrj);
                projSt.setString(4, resTypeId);
                projSt.setString(5, dbRes[i][4]);
                if (dbRes[i][5] != null) {
                    projSt.setString(6, dbRes[i][5]);
                } else {
                    projSt.setObject(6, null);
                }
                projSt.setInt(7, annResId);
                projSt.addBatch();
                ++i;
            }
            int[] res = stmt.executeBatch();
            L.trace("insert resource: {}", (Object)Arrays.toString(res));
            stmt.close();
            res = projSt.executeBatch();
            L.trace("insert annResourceDetails: {}", (Object)Arrays.toString(res));
            projSt.close();
        } else {
            L.debug("no resource find in project: {}", (Object)currentPrj);
        }
    }

    static String[][] getAnnResDetails(final Map<String, Integer> infos, IMFProjectHandler ph, SubMonitor monitor) {
        final String[][][] ret = new String[1][][];
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    ret[0] = ResourceIdentificator.getPrjResources(infos.keySet(), conn);
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            L.error("error getting resources of project: {}", (Object)ph, (Object)e);
        }
        catch (ExecutionException e) {
            L.error("error getting resources of project: {}", (Object)ph, (Object)e);
        }
        return ret[0];
    }

    public static String[][] getPrjResources(Set<String> RIDs, EZSourceConnection conn) {
        String[][][] ret;
        block10: {
            ret = new String[1][][];
            try {
                try {
                    int length;
                    conn.beginTransaction();
                    String[][] dbResPrg = EZSourceProgramIdentificator.getDetails(RIDs, conn);
                    String[][] dbResJcl = EZJclJobIdentificator.getDetails(RIDs, conn);
                    String[][] dbRes = EZResourceIdentificator.getDetails(RIDs, conn);
                    int n = length = dbResPrg != null ? dbResPrg.length : 0;
                    if (dbResJcl != null) {
                        length += dbResJcl.length;
                    }
                    if (dbRes != null) {
                        length += dbRes.length;
                    }
                    ret[0] = new String[length][];
                    int pos = 0;
                    if (dbResPrg != null && dbResPrg.length > 0) {
                        System.arraycopy(dbResPrg, 0, ret[0], pos, dbResPrg.length);
                        pos = dbResPrg.length;
                    }
                    if (dbResJcl != null && dbResJcl.length > 0) {
                        System.arraycopy(dbResJcl, 0, ret[0], pos, dbResJcl.length);
                        pos += dbResJcl.length;
                    }
                    if (dbRes != null && dbRes.length > 0) {
                        System.arraycopy(dbRes, 0, ret[0], pos, dbRes.length);
                    }
                }
                catch (Throwable th) {
                    L.error("error getting resource details for project: {}", (Object)conn.getOpenedProject(), (Object)th);
                    conn.voteRollbackTransaction();
                    conn.endTransaction();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                conn.voteRollbackTransaction();
                conn.endTransaction();
                throw throwable;
            }
            conn.voteRollbackTransaction();
            conn.endTransaction();
        }
        return ret[0];
    }

    static Properties loadRID(String RID) {
        Properties p = new Properties();
        try {
            p.load(new StringReader(RID));
        }
        catch (IOException e) {
            L.error("", (Throwable)e);
        }
        return p;
    }

    public static String getResourceTypeName(String RID) {
        String strType = ResourceIdentificator.getResourceTypeInt(RID);
        String type = ResourceIdentificator.getResourceTypeName(RID, strType);
        return type;
    }

    public static String getResourceTypeName(String intType, String RID) {
        String type = null;
        if (intType != null) {
            if (RID_RESOURCE_TYPE_JOB.equals(intType)) {
                type = RESOURCETYPE_JCL_JOB;
            } else if (RID_RESOURCE_TYPE_PROGRAM.equals(intType)) {
                if (RID == null) {
                    type = RESOURCETYPE_PROGRAM;
                } else {
                    Integer t = EZSourceProgramIdentificator.getPrgType(RID);
                    type = Utils.getPrgType((String)t.toString());
                }
            } else if (RID_RESOURCE_TYPE_SQLTABLE.equals(intType)) {
                type = RESOURCETYPE_SQLTABLE;
            } else if (RID_RESOURCE_TYPE_SQLFIELD.equals(intType)) {
                type = RESOURCETYPE_SQLFIELDTABLE;
            } else if (RID_RESOURCE_TYPE_FILE.equals(intType)) {
                type = RESOURCETYPE_FILE;
            } else if (RID_RESOURCE_TYPE_IMSDBSEG.equals(intType)) {
                type = RESOURCETYPE_IMSDBSEG;
            } else if (RID_RESOURCE_TYPE_IMSMSG.equals(intType)) {
                type = RESOURCETYPE_IMSDBSEG;
            } else if (RID_RESOURCE_TYPE_IMSTRAN.equals(intType)) {
                type = RESOURCETYPE_IMSTRAN;
            } else if (RID_RESOURCE_TYPE_CICSBMS.equals(intType)) {
                type = RESOURCETYPE_CICSMAP;
            }
        }
        return type;
    }

    public static String getResourceTypeInt(String RID) {
        Properties p = ResourceIdentificator.loadRID(RID);
        String strType = (String)p.get(RID_RESOURCETYPE_KEY);
        return strType;
    }

    public static String getResourceName(String RID) {
        String ret = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if (p != null) {
            ret = p.getProperty(RID_NAME_KEY);
        }
        return ret;
    }

    public static String getResourceQualifierName(String RID) {
        String ret = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if (p != null) {
            ret = p.getProperty(RID_QUALIFIER_NAME_KEY);
        }
        return ret;
    }
}

