/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.ResourceFindRunnableService;
import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.internal.Messages;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinderViewerImpl
implements ResourceFindRunnableService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ResourceFinderViewerImpl.class);
    private IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);

    public ResourceFinderViewerImpl() {
        if (this.connService == null) {
            throw new RuntimeException(Messages.getString(ResourceFinderViewerImpl.class, "projectService.exception"));
        }
    }

    @Override
    public String[][] find(final Set<String> RIDs, String prjName) {
        IMFProjectHandler ph = this.connService.getProjectHandler(prjName, null);
        final String[][][] ret = new String[1][][];
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    ret[0] = ResourceIdentificator.getPrjResources(RIDs, conn);
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException e) {
            L.error("error getting resources of project: {}", (Object)ph, (Object)e);
        }
        catch (ExecutionException e) {
            L.error("error getting resources of project: {}", (Object)ph, (Object)e);
        }
        return ret[0];
    }
}

