/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.internal.utils.Triplet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCriteria {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResourceCriteria.class);
    public static final String KEY_PROJECT = "project";
    public static final String KEY_RESTYPE = "resourceType";
    public static final String KEY_RESNAME = "resourceName";
    public static final String KEY_PROGRAMTYPE = "programType";
    Map<String, Object> criterion = new HashMap<String, Object>();

    public void addCriteria(String key, Object value) {
        Object oldValue = this.criterion.get(key);
        if (oldValue != null) {
            L.warn("existing value={}", oldValue);
        }
        this.criterion.put(key, value);
    }

    public Object getValue(String key) {
        return this.criterion.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Object[] projectObj = (String[])this.criterion.get(KEY_PROJECT);
        List resTypeObj = (List)this.criterion.get(KEY_RESTYPE);
        String resNameObj = (String)this.criterion.get(KEY_RESNAME);
        if (projectObj != null && projectObj.length > 0) {
            sb.append(KEY_PROJECT).append("=").append(Arrays.toString(projectObj));
        }
        if (resNameObj != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(KEY_RESNAME).append("=[").append(resNameObj).append("]");
        }
        if (resTypeObj != null && !resTypeObj.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("[");
            for (Triplet t : resTypeObj) {
                sb.append("(").append(KEY_RESTYPE).append("=").append((String)t.getSecond());
                if ("5".equals(t.getThird())) {
                    sb.append(", ").append(KEY_PROGRAMTYPE).append("=").append(t.getFirst());
                }
                sb.append("), ");
            }
            sb = sb.delete(sb.length() - 2, sb.length());
            sb.append("]");
        }
        return sb.length() == 0 ? this.criterion.toString() : sb.toString();
    }
}

