/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.model.AnnResource;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZSourceProgramIdentificator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZSourceProgramIdentificator.class);
    static final String RID_PROGRAMTYPE_ASINTEGER_KEY = "prgType";
    static final String RID_PROGRAMPATH_KEY = "prgPath";

    static void fillRID(EZSourceProgram prg, Properties RID) {
        EZEntityID entId = prg.getEntID();
        if (entId != null) {
            RID.setProperty("resType", "5");
            EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entId.getSegment(EZSourceProgramIDSg.class);
            if (prgSg != null) {
                String name = prgSg.getProgramName();
                if (name == null) {
                    name = prg.getName();
                }
                RID.setProperty("name", name.toUpperCase());
                RID.setProperty(RID_PROGRAMTYPE_ASINTEGER_KEY, "" + prgSg.getTypeId());
                String path = "" + prg.getProperty("program_path");
                path = ResourceIdentificator.preparePath(path);
                RID.setProperty(RID_PROGRAMPATH_KEY, path.toUpperCase());
            }
        }
    }

    public static String getPrgPath(String RID) {
        String prgPath = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if ("5".equals(p.get("resType"))) {
            prgPath = (String)p.get(RID_PROGRAMPATH_KEY);
        } else {
            L.warn("RID is not of a program!");
        }
        return prgPath;
    }

    static String getPrgName(String RID) {
        String prgName = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if ("5".equals(p.get("resType"))) {
            prgName = (String)p.get("name");
        } else {
            L.warn("RID is not of a program!");
        }
        return prgName;
    }

    public static Integer getPrgType(String RID) {
        Integer type = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if ("5".equals(p.get("resType"))) {
            type = Integer.valueOf((String)p.get(RID_PROGRAMTYPE_ASINTEGER_KEY));
        } else {
            L.warn("RID is not of a program!");
        }
        return type;
    }

    static Set<AnnResource> getAnnResources(Collection<EZObjectType> inpts) {
        final HashSet<AnnResource> resources = new HashSet<AnnResource>();
        HashMap<String, HashMap<Integer, EZObjectType>> toFill = new HashMap<String, HashMap<Integer, EZObjectType>>();
        for (EZObjectType inpt : inpts) {
            AnnResource ret = null;
            EZEntityID entId = inpt.getEntID();
            if (entId == null) continue;
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entId.getSegment(EZSourceProjectIDSg.class);
            if (prjSg != null) {
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entId.getSegment(EZSourceProgramIDSg.class);
                if (prgSg != null) {
                    Boolean hasOccur = (Boolean)inpt.getProperty("program occur");
                    if (hasOccur == null) {
                        hasOccur = prgSg.getOccur();
                    }
                    if (hasOccur != null) {
                        String path = (String)inpt.getProperty("program_path");
                        if (path != null) {
                            ret = EZSourceProgramIdentificator.buildAnnRes((EZSourceProgram)inpt, prjSg.getProjectName());
                        } else {
                            Integer dbId = prgSg.getProgramId();
                            HashMap<Integer, EZObjectType> tmp = (HashMap<Integer, EZObjectType>)toFill.get(prjSg.getProjectName());
                            if (tmp == null) {
                                tmp = new HashMap<Integer, EZObjectType>();
                                toFill.put(prjSg.getProjectName(), tmp);
                            }
                            tmp.put(dbId, inpt);
                        }
                    }
                } else {
                    L.debug("input without programSegment in EntityID");
                }
            }
            if (ret == null) continue;
            resources.add(ret);
        }
        if (!toFill.isEmpty()) {
            IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            for (final String prj : toFill.keySet()) {
                final Map tmp = (Map)toFill.get(prj);
                final ArrayList ids = new ArrayList(tmp.keySet());
                IMFProjectHandler ph = connService.getProjectHandler(prj, null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            try {
                                try {
                                    String tempTblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp");
                                    String sqlStr = "select distinct programs.ProgramID, paths.PathStr  from programs inner join occurrences on programs.OccurID=occurrences.OccurID inner join paths on paths.PathID=occurrences.PathID where programs.ProgramID in (select * from @@EZ@@)".replaceAll("@@EZ@@", tempTblName);
                                    conn.beginTransaction();
                                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                                    Collections.fill(types, EZSourceDataType.Integer);
                                    String[][] dbRes = conn.executeSQL(sqlStr, types, ids);
                                    if (dbRes != null && dbRes.length > 0) {
                                        String[][] stringArray = dbRes;
                                        int n = dbRes.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String[] res = stringArray[n2];
                                            Integer dbID = new Integer(res[0]);
                                            String path = res[1];
                                            EZObjectType obj = (EZObjectType)tmp.get(dbID);
                                            obj.addProperty("program_path", (Object)path);
                                            AnnResource ret = EZSourceProgramIdentificator.buildAnnRes((EZSourceProgram)obj, prj);
                                            if (ret != null) {
                                                resources.add(ret);
                                            }
                                            ++n2;
                                        }
                                    }
                                }
                                catch (Throwable th) {
                                    L.error("", th);
                                    conn.voteRollbackTransaction();
                                    conn.endTransaction();
                                }
                            }
                            finally {
                                conn.voteRollbackTransaction();
                                conn.endTransaction();
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException e) {
                    L.error("", (Throwable)e);
                }
                catch (ExecutionException e) {
                    L.error("", (Throwable)e);
                }
            }
            toFill.clear();
        }
        return resources;
    }

    private static AnnResource buildAnnRes(EZSourceProgram inpt, String prjName) {
        AnnResource ret = null;
        String RID = EZSourceProgramIdentificator.getRID(inpt, null);
        if (RID != null) {
            ret = new AnnResource(RID);
            ret.setProjectInfo(prjName);
        } else {
            L.warn("input without RID: {}", (Object)inpt);
        }
        return ret;
    }

    static String[][] getDetails(Collection<String> infos, EZSourceConnection conn) {
        String[][] ret = null;
        String tempTblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"tmp");
        String sqlCreateStmt = null;
        ServerType dbengine = conn.getProjectInfo().getDbEngine();
        switch (dbengine) {
            case SqlServer: {
                sqlCreateStmt = "create table " + tempTblName + " (name [nvarchar] (250) NOT NULL, " + "type [int] NOT NULL, RID [nvarchar] (800) NOT NULL, path [nvarchar] (300) NOT NULL)";
                break;
            }
            case Db2Z: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + "type INTEGER NOT NULL, RID VARGRAPHIC(800) NOT NULL, path VARGRAPHIC(300) NOT NULL)" + " CCSID UNICODE " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + "type INTEGER NOT NULL, RID VARGRAPHIC(800) NOT NULL, path VARGRAPHIC(300) NOT NULL)" + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        if (sqlCreateStmt != null) {
            conn.executeUpdate(sqlCreateStmt);
            for (String RID : infos) {
                if (!EZSourceProgramIdentificator.isProgram(RID)) continue;
                String prgName = EZSourceProgramIdentificator.getPrgName(RID);
                Integer prgType = EZSourceProgramIdentificator.getPrgType(RID);
                String prgPath = EZSourceProgramIdentificator.getPrgPath(RID);
                String q = String.format("insert into %s (RID, name, type, path) VALUES ('%s', '%s', %s, '%s')", tempTblName, RID, prgName.toUpperCase(), prgType, prgPath.toUpperCase());
                conn.executeInsert(q);
            }
            String q2 = "Select AD_TBLNAME.RID, Programs.ProgramID, VC_ContainerVsResources.Version, '5', ProgramAliases.AliasName AS ProgramName, Programs.ProgramTypeID, paths.PathStr  FROM  Programs \n INNER JOIN ProgramAliases ON Programs.ProgramID = ProgramAliases.ProgramId and ProgramAliases.AliasType = 0 \n\tinner join VC_ContainerVsResources ON VC_ContainerVsResources.IDResource=Programs.ProgramID and VC_ContainerVsResources.ResourceTypeID=5  inner join occurrences on programs.OccurID=occurrences.OccurID \tinner join paths on paths.PathID=occurrences.PathID \tinner join AD_TBLNAME ON AD_TBLNAME.name=UPPER(ProgramAliases.AliasName) AND AD_TBLNAME.type=Programs.ProgramTypeID AND AD_TBLNAME.path=UPPER(paths.PathStr) ";
            ret = conn.executeSQL(q2.replaceAll("AD_TBLNAME", tempTblName));
            conn.executeUpdate("drop table " + tempTblName);
        } else {
            L.warn("temporary table cannot be created at getDetails()!");
        }
        return ret;
    }

    public static boolean isProgram(String rid) {
        boolean ret = false;
        Properties p = ResourceIdentificator.loadRID(rid);
        ret = "5".equals(p.get("resType"));
        return ret;
    }

    public static String getRID(EZSourceProgram objType, Properties info) {
        if (info == null) {
            info = new Properties();
        }
        EZSourceProgramIdentificator.fillRID(objType, info);
        return EZSourceProgramIdentificator.getProgramRID(info);
    }

    public static String getProgramRID(Properties info) {
        String ret = null;
        if (!info.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append("resType").append("=").append(info.get("resType")).append("\n").append("name").append("=").append(info.get("name")).append("\n").append(RID_PROGRAMTYPE_ASINTEGER_KEY).append("=").append(info.get(RID_PROGRAMTYPE_ASINTEGER_KEY)).append("\n").append(RID_PROGRAMPATH_KEY).append("=").append(info.get(RID_PROGRAMPATH_KEY)).append("\n");
            ret = buff.toString();
        }
        return ret;
    }

    public static String getRID(Object[] results) {
        Properties RID = new Properties();
        RID.setProperty("resType", "5");
        RID.setProperty("name", String.valueOf(results[3]).toUpperCase());
        RID.setProperty(RID_PROGRAMTYPE_ASINTEGER_KEY, String.valueOf(results[5]));
        String path = String.valueOf(results[4]);
        path = ResourceIdentificator.preparePath(path);
        RID.setProperty(RID_PROGRAMPATH_KEY, path.toUpperCase());
        return EZSourceProgramIdentificator.getProgramRID(RID);
    }
}

