/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.ResourceIdentificator;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZResourceIdentificator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZResourceIdentificator.class);

    public static String getRID(Object[] results) {
        Properties RID = new Properties();
        RID.setProperty("resType", String.valueOf(results[0]));
        RID.setProperty("name", String.valueOf(results[3]).toUpperCase());
        if (results.length > 6 && results[6] != null) {
            RID.setProperty("qualifiername", String.valueOf(results[6]).toUpperCase());
        }
        return EZResourceIdentificator.getResourceRID(RID);
    }

    private static String getResourceRID(Properties info) {
        String ret = null;
        if (!info.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append("resType").append("=").append(info.get("resType")).append("\n").append("name").append("=").append(info.get("name")).append("\n");
            if (info.get("qualifiername") != null) {
                buff.append("qualifiername").append("=").append(info.get("qualifiername")).append("\n");
            }
            ret = buff.toString();
        }
        return ret;
    }

    public static String[][] getDetails(Collection<String> infos, EZSourceConnection conn) {
        String[][] ret = null;
        String tempTblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"tmp");
        String sqlCreateStmt = null;
        ServerType dbengine = conn.getProjectInfo().getDbEngine();
        switch (dbengine) {
            case SqlServer: {
                sqlCreateStmt = "create table " + tempTblName + " (name [nvarchar] (250) NOT NULL, " + " qualifier [nvarchar] (250), " + "RID [nvarchar] (800) NOT NULL, " + "rtype [int] NOT NULL)";
                break;
            }
            case Db2Z: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + " qualifier VARGRAPHIC(250), " + " RID VARGRAPHIC(800) NOT NULL, " + " rtype int NOT NULL )" + " CCSID UNICODE " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + " qualifier VARGRAPHIC(250), " + " RID VARGRAPHIC(800) NOT NULL, " + " rtype int NOT NULL )" + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        if (sqlCreateStmt != null) {
            conn.executeUpdate(sqlCreateStmt);
            HashSet<String> resourceTypes = new HashSet<String>();
            for (String RID : infos) {
                String ezResourceType = EZResourceIdentificator.getEZResourceType(RID);
                if (ezResourceType == null) continue;
                Pair<String, String> names = EZResourceIdentificator.getResourceName(RID);
                String resName = (String)names.getFirst();
                String qualifier = (String)names.getSecond();
                resourceTypes.add(ezResourceType);
                String q = String.format("insert into %s (name, qualifier, RID, rtype) VALUES ('%s', '%s', '%s', %s)", tempTblName, resName, qualifier, RID, ezResourceType);
                conn.executeInsert(q);
            }
            for (String ezResourceType : resourceTypes) {
                String q2 = EZResourceIdentificator.getQuery(tempTblName, ezResourceType);
                String[][] retForRes = conn.executeSQL(q2);
                if (retForRes == null || retForRes.length <= 0) continue;
                if (ret == null) {
                    ret = retForRes;
                    continue;
                }
                int len = ret.length;
                ret = (String[][])Arrays.copyOf(ret, ret.length + retForRes.length);
                System.arraycopy(retForRes, 0, ret, len, retForRes.length);
            }
            conn.executeUpdate("drop table " + tempTblName);
        }
        return ret;
    }

    private static String getQuery(String tempTblName, String ezResourceType) {
        String ret = null;
        switch (ezResourceType) {
            case "1": {
                ret = "Select AD_TBLNAME.RID, SQLTables.SqlTableID, -100, '1', SQLTables.TableName, CAST(NULL as Integer), NULL from SQLTables \tinner join AD_TBLNAME ON AD_TBLNAME.name=SQLTables.TableName and rtype = 1";
                break;
            }
            case "187": {
                ret = "Select AD_TBLNAME.RID, SqlFields.SqlFieldID, -100, '187', SqlFields.FieldName, CAST(NULL as Integer), NULL from SqlFields \tinner join AD_TBLNAME ON AD_TBLNAME.name=SqlFields.FieldName and rtype = 187 inner join SqlTables ON SqlTables.SQLTableId = SqlFields.SQLTableId and SqlTables.TableName = AD_TBLNAME.qualifier";
                break;
            }
            case "9": {
                ret = "Select AD_TBLNAME.RID, -1, -100, '9', MFCICSFile.DSName, CAST(NULL as Integer), NULL from MFCICSFile \tinner join AD_TBLNAME ON AD_TBLNAME.name=MFCICSFile.DSName and rtype = 9\nUNION Select AD_TBLNAME.RID, JCLPhysicalDataSet.DataSetID, -100, '9', JCLPhysicalDataSet.DataSetName, CAST(NULL as Integer), NULL from JCLPhysicalDataSet \tinner join AD_TBLNAME ON AD_TBLNAME.name=JCLPhysicalDataSet.DatasetName and rtype = 9";
                break;
            }
            case "6": {
                ret = "Select AD_TBLNAME.RID, bs.BMSId, -100, '6', bs.BMSName, CAST(NULL as Integer), NULL from BMS bs\tinner join AD_TBLNAME ON AD_TBLNAME.name=bs.BMSName and bs.IsMapSet = 0 and rtype = 6 inner join BMS bm ON bm.IsMapSet = -1 and bs.AncestorId = bm.BMSId and bm.BmsName = AD_TBLNAME.qualifier";
                break;
            }
            case "20": {
                ret = "Select AD_TBLNAME.RID, Resources.ResourceID, -100, '20', Resources.Name, CAST(NULL as Integer), NULL from Resources \tinner join AD_TBLNAME ON AD_TBLNAME.name= Resources.Name and Resources.ResourceType = 20 and rtype = 20";
                break;
            }
            case "209": {
                ret = "Select AD_TBLNAME.RID, IMSDBSegments.SegmentId, -100, '209', IMSDBSegments.SegmentName, CAST(NULL as Integer), NULL from IMSDBSegments \tinner join AD_TBLNAME ON AD_TBLNAME.name=IMSDBSegments.SegmentName and rtype = 209 inner join IMSDBInfo ON IMSDBInfo.DBId = IMSDBSegments.DBId and IMSDBInfo.DBName = AD_TBLNAME.qualifier";
                break;
            }
            case "212": {
                ret = "Select AD_TBLNAME.RID, IMSMapIOFormat.Id, -100, '212', IMSMapIOFormat.Name, CAST(NULL as Integer), NULL from IMSMapIOFormat \tinner join AD_TBLNAME ON AD_TBLNAME.name=IMSMapIOFormat.Name and rtype = 212 left join IMSMaps ON IMSMaps.MapId = IMSMapIOFormat.IMSMapId and IMSMaps.MapName = AD_TBLNAME.qualifier";
            }
        }
        return ret.replaceAll("AD_TBLNAME", tempTblName);
    }

    private static boolean isEZResource(String rid) {
        boolean ret = false;
        Properties p = ResourceIdentificator.loadRID(rid);
        ret = "1".equals(p.get("resType")) || "9".equals(p.get("resType")) || "187".equals(p.get("resType")) || "20".equals(p.get("resType")) || "212".equals(p.get("resType")) || "209".equals(p.get("resType")) || "6".equals(p.get("resType"));
        return ret;
    }

    static Pair<String, String> getResourceName(String RID) {
        String name = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        name = (String)p.get("name");
        String qual = (String)p.get("qualifiername");
        return new Pair((Object)name, (Object)qual);
    }

    private static String getEZResourceType(String rid) {
        Properties p = ResourceIdentificator.loadRID(rid);
        if (EZResourceIdentificator.isEZResource(rid)) {
            return (String)p.get("resType");
        }
        L.debug("RID is not of a accepted EZResource!");
        return null;
    }
}

