/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.model.AnnResource;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZJobInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZJclJobIdentificator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZJclJobIdentificator.class);
    static final String RID_JOB_PATH_KEY = "jobPath";

    public static Set<AnnResource> getAnnResources(Collection<EZObjectType> inpts) {
        final HashSet<AnnResource> resources = new HashSet<AnnResource>();
        HashMap<String, HashMap<Integer, EZObjectType>> toFill = new HashMap<String, HashMap<Integer, EZObjectType>>();
        for (EZObjectType inpt : inpts) {
            AnnResource ret = null;
            EZEntityID entId = inpt.getEntID();
            if (entId == null) continue;
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)entId.getSegment(EZSourceProjectIDSg.class);
            if (prjSg != null) {
                EZSourceJobIDSg ezJobIDSg = (EZSourceJobIDSg)entId.getSegment(EZSourceJobIDSg.class);
                if (ezJobIDSg != null) {
                    String path = (String)inpt.getProperty("job_path");
                    if (path != null) {
                        ret = EZJclJobIdentificator.buildAnnRes((EZJobInputType)inpt, prjSg.getProjectName());
                    } else {
                        Integer dbId = ezJobIDSg.getJobId();
                        HashMap<Integer, EZObjectType> tmp = (HashMap<Integer, EZObjectType>)toFill.get(prjSg.getProjectName());
                        if (tmp == null) {
                            tmp = new HashMap<Integer, EZObjectType>();
                            toFill.put(prjSg.getProjectName(), tmp);
                        }
                        tmp.put(dbId, inpt);
                    }
                } else {
                    L.debug("input without jobSegment in EntityID");
                }
            }
            if (ret == null) continue;
            resources.add(ret);
        }
        if (!toFill.isEmpty()) {
            IMFConnectionService connService = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            for (final String prj : toFill.keySet()) {
                final Map tmp = (Map)toFill.get(prj);
                final ArrayList ids = new ArrayList(tmp.keySet());
                IMFProjectHandler ph = connService.getProjectHandler(prj, null);
                try {
                    ph.executeWithLock(ph, new IMFRunnable(){

                        public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                            try {
                                try {
                                    String tempTblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp");
                                    String sqlStr = "select distinct JCLJob.JobID, JCLPosition.ResourceFilePath  from JCLJob  inner join JCLPosition on JCLPosition.PositionID=JCLJob.PositionID where JCLJob.JobID in (select * from @@EZ@@ )".replaceAll("@@EZ@@", tempTblName);
                                    conn.beginTransaction();
                                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[ids.size()]);
                                    Collections.fill(types, EZSourceDataType.Integer);
                                    String[][] dbRes = conn.executeSQL(sqlStr, types, ids);
                                    if (dbRes != null && dbRes.length > 0) {
                                        String[][] stringArray = dbRes;
                                        int n = dbRes.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            String[] res = stringArray[n2];
                                            Integer dbID = new Integer(res[0]);
                                            String path = res[1];
                                            EZObjectType obj = (EZObjectType)tmp.get(dbID);
                                            obj.addProperty("job_path", (Object)path);
                                            AnnResource ret = EZJclJobIdentificator.buildAnnRes((EZJobInputType)obj, prj);
                                            if (ret != null) {
                                                resources.add(ret);
                                            }
                                            ++n2;
                                        }
                                    }
                                }
                                catch (Throwable th) {
                                    L.error("", th);
                                    conn.voteRollbackTransaction();
                                    conn.endTransaction();
                                }
                            }
                            finally {
                                conn.voteRollbackTransaction();
                                conn.endTransaction();
                            }
                        }
                    }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException e) {
                    L.error("", (Throwable)e);
                }
                catch (ExecutionException e) {
                    L.error("", (Throwable)e);
                }
            }
            toFill.clear();
        }
        return resources;
    }

    private static AnnResource buildAnnRes(EZJobInputType inpt, String prjName) {
        AnnResource ret = null;
        String RID = EZJclJobIdentificator.getRID(inpt, null);
        if (RID != null) {
            ret = new AnnResource(RID);
            ret.setProjectInfo(prjName);
        } else {
            L.warn("input without RID: " + inpt);
        }
        return ret;
    }

    public static String getRID(EZJobInputType objType, Properties RID) {
        if (RID == null) {
            RID = new Properties();
        }
        EZJclJobIdentificator.fillRID(objType, RID);
        return EZJclJobIdentificator.getJobRID(RID);
    }

    public static String getJobRID(Properties info) {
        String ret = null;
        if (!info.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            buff.append("resType").append("=").append(info.get("resType")).append("\n").append("name").append("=").append(info.get("name")).append("\n").append(RID_JOB_PATH_KEY).append("=").append(info.get(RID_JOB_PATH_KEY)).append("\n");
            ret = buff.toString();
        }
        return ret;
    }

    static void fillRID(EZJobInputType prg, Properties RID) {
        EZEntityID entId = prg.getEntID();
        if (entId != null) {
            RID.setProperty("resType", "22");
            EZSourceJobIDSg ezJobIDSg = (EZSourceJobIDSg)entId.getSegment(EZSourceJobIDSg.class);
            if (ezJobIDSg != null) {
                RID.setProperty("name", ezJobIDSg.getJobName().toUpperCase());
                String path = "" + prg.getProperty("job_path");
                path = ResourceIdentificator.preparePath(path);
                RID.setProperty(RID_JOB_PATH_KEY, path.toUpperCase());
            }
        }
    }

    public static String getRID(Object[] results) {
        Properties RID = new Properties();
        RID.setProperty("resType", "22");
        RID.setProperty("name", String.valueOf(results[3]).toUpperCase());
        String path = String.valueOf(results[4]);
        path = ResourceIdentificator.preparePath(path);
        RID.setProperty(RID_JOB_PATH_KEY, path.toUpperCase());
        return EZJclJobIdentificator.getJobRID(RID);
    }

    public static String[][] getDetails(Collection<String> infos, EZSourceConnection conn) {
        String[][] ret = null;
        String tempTblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"tmp");
        String sqlCreateStmt = null;
        ServerType dbengine = conn.getProjectInfo().getDbEngine();
        switch (dbengine) {
            case SqlServer: {
                sqlCreateStmt = "create table " + tempTblName + " (name [nvarchar] (250) NOT NULL, RID [nvarchar] (800) NOT NULL, path [nvarchar] (300) NOT NULL)";
                break;
            }
            case Db2Z: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + " RID VARGRAPHIC(800) NOT NULL, path VARGRAPHIC(300) NOT NULL )" + " CCSID UNICODE " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                sqlCreateStmt = " DECLARE GLOBAL TEMPORARY TABLE " + tempTblName + " (name VARGRAPHIC(250) NOT NULL, " + " RID VARGRAPHIC(800) NOT NULL, path VARGRAPHIC(300) NOT NULL )" + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        if (sqlCreateStmt != null) {
            conn.executeUpdate(sqlCreateStmt);
            for (String RID : infos) {
                if (!EZJclJobIdentificator.isJob(RID)) continue;
                String jobName = EZJclJobIdentificator.getJobName(RID);
                String jobPath = EZJclJobIdentificator.getJobPath(RID);
                String q = String.format("insert into %s (name, RID, path) VALUES ('%s', '%s', '%s')", tempTblName, jobName.toUpperCase(), RID, jobPath.toUpperCase());
                conn.executeInsert(q);
            }
            String q2 = "Select AD_TBLNAME.RID, JCLJob.JobID, VC_ContainerVsResources.Version, '22', JCLJob.JobName, CAST(NULL as Integer), JCLPosition.ResourceFilePath from JCLJob \tinner join VC_ContainerVsResources ON VC_ContainerVsResources.IDResource=JCLJob.JobID and VC_ContainerVsResources.ResourceTypeID=22  inner join JCLPosition on JCLPosition.PositionID=JCLJob.PositionID\tinner join AD_TBLNAME ON AD_TBLNAME.name=UPPER(JCLJob.JobName)  AND AD_TBLNAME.path=UPPER(JCLPosition.ResourceFilePath) ";
            ret = conn.executeSQL(q2.replaceAll("AD_TBLNAME", tempTblName));
            conn.executeUpdate("drop table " + tempTblName);
        }
        return ret;
    }

    private static boolean isJob(String rid) {
        boolean ret = false;
        Properties p = ResourceIdentificator.loadRID(rid);
        ret = "22".equals(p.get("resType"));
        return ret;
    }

    static String getJobName(String RID) {
        String name = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if ("22".equals(p.get("resType"))) {
            name = (String)p.get("name");
        } else {
            L.warn("RID is not of a JCLJob!");
        }
        return name;
    }

    static String getJobPath(String RID) {
        String name = null;
        Properties p = ResourceIdentificator.loadRID(RID);
        if ("22".equals(p.get("resType"))) {
            name = (String)p.get(RID_JOB_PATH_KEY);
        } else {
            L.warn("RID is not of a JCLJob!");
        }
        return name;
    }
}

