/*
 * Decompiled with CFR 0.152.
 */
package com.ez.ann.db;

import com.ez.ann.db.EZDbException;
import com.ez.ann.db.ResourceCriteria;
import com.ez.ann.db.ResourceFindRunnableService;
import com.ez.ann.db.ResourceIdentificator;
import com.ez.ann.internal.Messages;
import com.ez.ann.model.AnnResource;
import com.ez.ann.model.EZAnnotation;
import com.ez.ann.model.EZKeyword;
import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.data.utils.Utils;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.ann.core.AnnotationsDBUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZAnnotationDbManager {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(EZAnnotationDbManager.class);
    public static final String GET_KEYWORDS_ERROR = Messages.getString(EZAnnotationDbManager.class, "get.keywords.error");
    public static final String SAVE_KEYWORDS_ERROR = Messages.getString(EZAnnotationDbManager.class, "save.keywords.error");
    private static final String NO_ANN_DATABASE_EXCEPTION_MESSAGE = Messages.getString(EZAnnotationDbManager.class, "noAnnDb.exception.message");
    public static final String NO_ANN_DB_CONNECTION_WARNING_MSG = Messages.getString(EZAnnotationDbManager.class, "noAnnDbConnection.warning");
    static EZAnnotationDbManager _INSTANCE = null;
    private DataSource datasource = null;
    private ServerType dbEngine = null;

    private EZAnnotationDbManager() {
        this.configureDataSource();
    }

    public static EZAnnotationDbManager getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new EZAnnotationDbManager();
        }
        return _INSTANCE;
    }

    public void saveAnn(EZAnnotation ann, boolean isInsert, IProgressMonitor pmonitor) throws Exception {
        Exception e;
        block25: {
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            e = null;
            try {
                try {
                    Integer annId = this.saveAnnotation(conn, isInsert, ann);
                    monitor.worked(10);
                    this.saveAnnDetails(ann, conn, annId, isInsert);
                    monitor.worked(10);
                    if (isInsert) {
                        Map<String, Integer> ids = this.saveAnnResource(conn, annId, ann);
                        monitor.worked(10);
                        ResourceIdentificator.saveAnnResr(annId, ids, conn, monitor.newChild(70));
                    }
                    monitor.done();
                }
                catch (Exception ex) {
                    L.debug("error saving annotation", (Throwable)ex);
                    e = ex;
                    if (conn == null) break block25;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block25;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    private Integer saveAnnotation(Connection conn, boolean isInsert, EZAnnotation ann) throws Exception {
        Integer annId;
        Exception e;
        block21: {
            e = null;
            Statement stmt = null;
            Statement pst = null;
            ResultSet rs = null;
            annId = isInsert ? null : ann.getDbId();
            try {
                try {
                    String sql = "";
                    if (isInsert) {
                        sql = "INSERT INTO Annotation (AID";
                        if (ann.getName() != null) {
                            sql = String.valueOf(sql) + ", name, deleted";
                        }
                        sql = String.valueOf(sql) + ") VALUES (?";
                        if (ann.getName() != null) {
                            sql = String.valueOf(sql) + ", ?";
                        }
                        sql = String.valueOf(sql) + ", 0)";
                    } else {
                        sql = "UPDATE Annotation SET Name=? WHERE ID = ?";
                    }
                    stmt = conn.prepareStatement(sql);
                    if (isInsert) {
                        stmt.setString(1, ann.getAID());
                        if (ann.getName() != null) {
                            stmt.setString(2, ann.getName());
                        }
                    } else {
                        stmt.setString(1, ann.getName());
                        stmt.setInt(2, annId);
                    }
                    L.trace(sql);
                    boolean added = stmt.execute();
                    L.trace("insert annotation: {}", (Object)added);
                    if (annId == null) {
                        pst = conn.prepareStatement("SELECT ID from Annotation WHERE AID=?");
                        pst.setString(1, ann.getAID());
                        rs = pst.executeQuery();
                        while (rs.next()) {
                            annId = rs.getInt("ID");
                            L.debug("annId={}", (Object)annId);
                        }
                    }
                }
                catch (Exception ex) {
                    L.debug("error saving annotation", (Throwable)ex);
                    e = ex;
                    if (pst != null) {
                        pst.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (pst != null) {
                    pst.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            if (pst != null) {
                pst.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        if (e != null) {
            throw e;
        }
        return annId;
    }

    private Map<String, Integer> saveAnnResource(Connection conn, Integer annId, EZAnnotation ann) throws Exception {
        HashMap<String, Integer> ids;
        Exception e;
        block14: {
            e = null;
            Statement stmt1 = null;
            Statement stmt2 = null;
            ResultSet rs = null;
            ids = new HashMap<String, Integer>();
            try {
                try {
                    String sql1 = "INSERT INTO AnnResource (annID, RID) VALUES (?,?)";
                    String sql2 = "SELECT ID, RID from AnnResource WHERE annID=?";
                    stmt1 = conn.prepareStatement(sql1);
                    stmt1.setInt(1, annId);
                    Set<AnnResource> resources = ann.getResources();
                    for (AnnResource annResource : resources) {
                        stmt1.setString(2, annResource.getRID());
                        stmt1.addBatch();
                    }
                    int[] nArray = stmt1.executeBatch();
                    L.trace("insert annRes: {}", (Object)nArray);
                    stmt2 = conn.prepareStatement(sql2);
                    stmt2.setInt(1, annId);
                    rs = stmt2.executeQuery();
                    while (rs.next()) {
                        ids.put(rs.getString("RID"), rs.getInt("ID"));
                    }
                }
                catch (Exception ex) {
                    L.debug("error saving annotation", (Throwable)ex);
                    e = ex;
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stmt1 != null) {
                    stmt1.close();
                }
                if (stmt2 != null) {
                    stmt2.close();
                }
                throw throwable;
            }
            if (stmt1 != null) {
                stmt1.close();
            }
            if (stmt2 != null) {
                stmt2.close();
            }
        }
        if (e != null) {
            throw e;
        }
        return ids;
    }

    private void saveAnnDetails(EZAnnotation ann, Connection conn, Integer annId, boolean isInsert) throws SQLException {
        String sql;
        if (!isInsert) {
            sql = "DELETE FROM AnnDetail WHERE annID= ? AND k IN (?, ?, ?, ?, ?)";
            PreparedStatement st = conn.prepareStatement(sql);
            st.setInt(1, annId);
            st.setString(2, "user");
            st.setString(3, "text");
            st.setString(4, "hyperlink");
            st.setString(5, "keyword");
            st.setString(6, "createDate");
            int ret = st.executeUpdate();
            L.trace("delete metadata: {}", (Object)ret);
        }
        sql = "INSERT INTO AnnDetail (annID, k, value) VALUES (?,?,?)";
        PreparedStatement pst = conn.prepareStatement(sql);
        if (ann.getUser() != null) {
            pst.setInt(1, annId);
            pst.setString(2, "user");
            pst.setString(3, ann.getUser());
            pst.addBatch();
        }
        if (ann.getDescription() != null) {
            pst.setInt(1, annId);
            pst.setString(2, "text");
            pst.setString(3, ann.getDescription());
            pst.addBatch();
        }
        if (ann.getHyperlinks() != null) {
            for (String hyp : ann.getHyperlinks()) {
                pst.setInt(1, annId);
                pst.setString(2, "hyperlink");
                pst.setString(3, hyp);
                pst.addBatch();
            }
        }
        if (ann.getKeywords() != null) {
            for (EZKeyword key : ann.getKeywords()) {
                if (key.getId() != null) {
                    pst.setInt(1, annId);
                    pst.setString(2, "keyword");
                    pst.setString(3, key.getId().toString());
                    pst.addBatch();
                    continue;
                }
                L.warn("trying to associate a not-saved keyword: {}", (Object)key);
            }
        }
        int[] res = pst.executeBatch();
        L.trace("insert annMetadata: {}", (Object)res);
        if (ann.getDate() != null) {
            pst = conn.prepareStatement("INSERT INTO AnnDetail (annID, k, createdDate) VALUES (?,?,?)");
            pst.setInt(1, annId);
            pst.setString(2, "createDate");
            pst.setTimestamp(3, new Timestamp(ann.getDate().getTime()));
            pst.execute();
        }
    }

    public Set<EZAnnotation> findAnn(Map<String, Object> criterion, IProgressMonitor pmonitor) throws Exception {
        HashMap<Integer, EZAnnotation> anns;
        Exception e;
        block54: {
            if (criterion == null || criterion.isEmpty()) {
                throw new RuntimeException("please specify at least a criterion");
            }
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            e = null;
            anns = new HashMap<Integer, EZAnnotation>();
            try {
                try {
                    boolean searchOnResources;
                    String detSQL = "";
                    HashMap<Integer, Object> params = new HashMap<Integer, Object>();
                    boolean bl = searchOnResources = criterion.get("byResources") != null;
                    if (searchOnResources) {
                        detSQL = this.searchOnResources(conn, (Set)criterion.get("byResources"), params);
                    }
                    String metadata = this.searchOnMetadata(criterion, params);
                    if (!detSQL.isEmpty() && !metadata.isEmpty()) {
                        detSQL = String.valueOf(detSQL) + " INTERSECT ";
                    }
                    detSQL = String.valueOf(detSQL) + metadata;
                    Object critKeys = criterion.get("keyword");
                    if (!detSQL.isEmpty() && critKeys != null) {
                        detSQL = String.valueOf(detSQL) + " INTERSECT ";
                    }
                    String tbl = null;
                    if (critKeys != null) {
                        if (critKeys instanceof Collection) {
                            try {
                                tbl = Utils.getTempTableName((ServerType)this.dbEngine, (String)"keyTmp");
                                this.createTempTbl(tbl, conn, false);
                                Collection keys = (Collection)critKeys;
                                if (!keys.isEmpty()) {
                                    HashSet<Integer> c = new HashSet<Integer>();
                                    for (EZKeyword k : keys) {
                                        c.add(k.getId());
                                    }
                                    this.populateTmpTable(tbl, conn, c);
                                }
                                String sql = " SELECT DISTINCT a.annID FROM AnnDetail a where ";
                                sql = String.valueOf(sql) + "a.k='keyword' and a.value in ( select * from " + tbl + " )";
                                detSQL = String.valueOf(detSQL) + sql;
                            }
                            catch (Exception ex) {
                                L.error("error searching by keywords", (Throwable)ex);
                            }
                        } else {
                            L.warn("wrong search by Keywords! critKeys={}", critKeys);
                        }
                    }
                    HashSet<Integer> ids = new HashSet<Integer>();
                    if (!detSQL.isEmpty()) {
                        L.trace("detSQL={}", (Object)detSQL);
                        PreparedStatement pst = conn.prepareStatement(detSQL);
                        if (!params.isEmpty()) {
                            for (Integer pos : params.keySet()) {
                                Object paramVal = params.get(pos);
                                pst.setObject(pos, paramVal);
                                L.trace("parameter: {} value={}", (Object)pos, paramVal);
                            }
                        } else {
                            L.trace("no parameters");
                        }
                        ResultSet rs = pst.executeQuery();
                        while (rs.next()) {
                            Integer annID = rs.getInt(1);
                            ids.add(annID);
                        }
                    }
                    if (tbl != null) {
                        this.cleanTempTbl(conn, tbl);
                    }
                    Object critNameText = criterion.get("ann_name_text");
                    boolean continueSearch = !ids.isEmpty() || critNameText != null && detSQL.isEmpty();
                    L.trace("ids={}, continueSearch={}", ids, (Object)continueSearch);
                    if (continueSearch) {
                        HashSet<String> tmpTbl = new HashSet<String>();
                        params = new HashMap();
                        String where = " WHERE Annotation.deleted=0 ";
                        String sql = "SELECT Annotation.ID, Annotation.name, AnnResource.RID, Resource.ProjectInfo, Resource.dbID from Annotation \tinner join AnnResource ON Annotation.id=AnnResource.annID inner join Resource ON AnnResource.id=Resource.annResID ";
                        String groupBy = " GROUP by Annotation.id, Annotation.name, Resource.ProjectInfo, Resource.dbID, AnnResource.RID";
                        if (!ids.isEmpty()) {
                            String tempTbl = Utils.getTempTableName((ServerType)this.dbEngine, (String)"tmp");
                            this.createTempTbl(tempTbl, conn, true);
                            this.populateTmpTable(tempTbl, conn, ids);
                            tmpTbl.add(tempTbl);
                            where = String.valueOf(where) + " AND Annotation.ID IN (select * from " + tempTbl + " ) ";
                        }
                        if (critNameText != null) {
                            sql = String.valueOf(sql) + " inner join AnnDetail ON Annotation.id=AnnDetail.annID ";
                            if (critNameText instanceof String && !((String)critNameText).trim().isEmpty()) {
                                String pTemp = Utils.convertDbLikeValue((String)((String)critNameText), (boolean)true);
                                where = String.valueOf(where) + " AND ( Annotation.name like ?";
                                params.put(1, pTemp);
                                where = String.valueOf(where) + " or (AnnDetail.k='text' and AnnDetail.value like ? ))";
                                params.put(2, pTemp);
                            } else if (critNameText instanceof Collection) {
                                Collection c = (Collection)critNameText;
                                String tblName = Utils.getTempTableName((ServerType)this.dbEngine, (String)"tmp_name");
                                this.createTempTbl(tblName, conn, false);
                                this.populateTmpTable(tblName, conn, c);
                                tmpTbl.add(tblName);
                                where = String.valueOf(where) + " AND ( Annotation.name in (select * from " + tblName + ")";
                                where = String.valueOf(where) + "or (AnnDetail.k='text' and AnnDetail.value in (select * from " + tblName + ")))";
                            }
                        }
                        sql = String.valueOf(sql) + where;
                        sql = String.valueOf(sql) + groupBy;
                        PreparedStatement pst = conn.prepareStatement(sql);
                        L.trace("sql= {}", (Object)sql);
                        if (!params.isEmpty()) {
                            for (Integer pos : params.keySet()) {
                                Object val = params.get(pos);
                                pst.setObject(pos, val);
                                L.trace("param: {} value={}", (Object)pos, val);
                            }
                        }
                        ResultSet result = pst.executeQuery();
                        while (result.next()) {
                            Integer annID = result.getInt(1);
                            EZAnnotation ann = (EZAnnotation)anns.get(annID);
                            if (ann == null) {
                                ann = new EZAnnotation();
                                ann.setDbId(annID);
                                anns.put(annID, ann);
                            }
                            ann.setName(result.getString(2));
                            ann.addResource(new AnnResource(result.getString(3), result.getString(4), result.getInt(5)));
                            continueSearch = true;
                        }
                        if (!tmpTbl.isEmpty()) {
                            for (String tblName : tmpTbl) {
                                this.cleanTempTbl(conn, tblName);
                            }
                        }
                    }
                    if (continueSearch) {
                        this.getDetails(conn, anns);
                    }
                }
                catch (Exception th) {
                    L.debug("error finding annotations", (Throwable)th);
                    e = th;
                    if (conn == null) break block54;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block54;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return new HashSet<EZAnnotation>(anns.values());
    }

    public Set<EZAnnotation> findAnn(Map<String, Object> criterion) throws Exception {
        return this.findAnn(criterion, (IProgressMonitor)new NullProgressMonitor());
    }

    private void cleanTempTbl(Connection conn, String tblName) throws SQLException {
        Statement createTemp = conn.createStatement();
        String delQ = String.format("delete from %s", tblName);
        createTemp.execute(delQ);
        createTemp.execute("drop table " + tblName);
        createTemp.close();
    }

    private void createTempTbl(String tblName, Connection conn, boolean isInteger) throws SQLException {
        String createTempSql = null;
        switch (this.dbEngine) {
            case SqlServer: {
                createTempSql = "create table " + tblName;
                if (isInteger) {
                    createTempSql = String.valueOf(createTempSql) + "(ID [int] NOT NULL)";
                    break;
                }
                createTempSql = String.valueOf(createTempSql) + "(name [nvarchar] (100) NOT NULL)";
                break;
            }
            case Db2Z: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tblName;
                if (isInteger) {
                    createTempSql = String.valueOf(createTempSql) + "(ID INTEGER NOT NULL)";
                } else {
                    createTempSql = String.valueOf(createTempSql) + "(name VARGRAPHIC(100) NOT NULL) ";
                    createTempSql = String.valueOf(createTempSql) + " CCSID UNICODE ";
                }
                createTempSql = String.valueOf(createTempSql) + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
            case Db2: {
                createTempSql = " DECLARE GLOBAL TEMPORARY TABLE " + tblName;
                createTempSql = isInteger ? String.valueOf(createTempSql) + "(ID INTEGER NOT NULL)" : String.valueOf(createTempSql) + "(name VARGRAPHIC(100) NOT NULL) ";
                createTempSql = String.valueOf(createTempSql) + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                break;
            }
        }
        if (createTempSql != null) {
            SQLException e = null;
            try {
                conn.createStatement().execute(createTempSql);
            }
            catch (SQLException ex) {
                L.warn("creating table {}", (Object)tblName, (Object)ex);
                e = ex;
            }
            if (e != null) {
                try {
                    this.cleanTempTbl(conn, tblName);
                }
                catch (SQLException ex) {
                    L.debug("trying to clean table {}", (Object)tblName, (Object)ex);
                    throw e;
                }
                conn.createStatement().execute(createTempSql);
                e = null;
            }
        } else {
            L.warn("no SQL stmt for creating temp tables");
        }
    }

    private void populateTmpTable(String tblName, Connection conn, Collection<?> toInsert) throws SQLException {
        String insertTempSql = "insert into AD_TBLNAME VALUES (?)".replace("AD_TBLNAME", tblName);
        PreparedStatement st = conn.prepareStatement(insertTempSql);
        for (Object n : toInsert) {
            if (n instanceof Integer) {
                st.setInt(1, (Integer)n);
            } else {
                st.setString(1, (String)n);
            }
            st.addBatch();
        }
        st.executeBatch();
        st.close();
    }

    private void getDetails(Connection conn, Map<Integer, EZAnnotation> anns) throws SQLException {
        String tempTbl = Utils.getTempTableName((ServerType)this.dbEngine, (String)"det_tmp");
        this.createTempTbl(tempTbl, conn, true);
        this.populateTmpTable(tempTbl, conn, anns.keySet());
        String sql = "select a.* from AnnDetail as a WHERE annID in (select * from AD_FROM ) ".replace("AD_FROM", tempTbl);
        PreparedStatement pSt = conn.prepareStatement(sql);
        L.debug("detailsSQL= {}/n annIds={}", (Object)sql, anns.keySet());
        ResultSet details = pSt.executeQuery();
        Map<Integer, Set<EZAnnotation>> toComplete = this.fillDetails(anns, details);
        pSt.close();
        if (toComplete != null && !toComplete.isEmpty()) {
            String delQ = String.format("delete from %s", tempTbl);
            conn.createStatement().execute(delQ);
            this.populateTmpTable(tempTbl, conn, toComplete.keySet());
            PreparedStatement st = conn.prepareStatement("SELECT ID, name from Keyword where ID IN (select * from AD_FROM )".replace("AD_FROM", tempTbl));
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String key = rs.getString(2);
                Set<EZAnnotation> toFill = toComplete.get(id);
                for (EZAnnotation a : toFill) {
                    a.addKeyword(new EZKeyword(id, key));
                }
            }
        }
        this.cleanTempTbl(conn, tempTbl);
    }

    private String searchOnMetadata(Map<String, Object> criterion, Map<Integer, Object> params) {
        String sql = "";
        String critUser = (String)criterion.get("user");
        Object startDate = criterion.get("startDate");
        Object endDate = criterion.get("endDate");
        if (startDate != null || endDate != null || critUser != null && !critUser.isEmpty()) {
            String where = "";
            sql = String.valueOf(sql) + " SELECT DISTINCT a.annID FROM AnnDetail a ";
            if (startDate != null || endDate != null) {
                sql = String.valueOf(sql) + " INNER JOIN AnnDetail c ON a.annID=c.annID ";
                where = !where.isEmpty() ? String.valueOf(where) + " and " : String.valueOf(where) + " WHERE ";
                where = String.valueOf(where) + " c.k='createDate' and c.createdDate ";
                if (startDate == null) {
                    Calendar eDate = this.prepareDate(endDate, false);
                    where = String.valueOf(where) + " <= ? ";
                    params.put(params.size() + 1, new Timestamp(eDate.getTimeInMillis()));
                } else {
                    Calendar sDate = this.prepareDate(startDate, true);
                    where = String.valueOf(where) + " >= ? ";
                    params.put(params.size() + 1, new Timestamp(sDate.getTimeInMillis()));
                    if (endDate != null) {
                        Calendar eDate = this.prepareDate(endDate, false);
                        where = String.valueOf(where) + " and c.createdDate <= ? ";
                        params.put(params.size() + 1, new Timestamp(eDate.getTimeInMillis()));
                    }
                }
            }
            if (critUser != null && !critUser.isEmpty()) {
                sql = String.valueOf(sql) + " INNER JOIN AnnDetail d ON a.annID=d.annID ";
                where = !where.isEmpty() ? String.valueOf(where) + " and " : String.valueOf(where) + " WHERE ";
                where = String.valueOf(where) + " d.k='user' and d.value like ? ";
                params.put(params.size() + 1, critUser);
            }
            sql = String.valueOf(sql) + where;
        }
        return sql;
    }

    private Calendar prepareDate(Object date, boolean isStart) {
        Calendar c = null;
        if (date instanceof Calendar) {
            c = (Calendar)date;
        } else if (date instanceof java.util.Date) {
            c = Calendar.getInstance();
            c.setTimeInMillis(((java.util.Date)date).getTime());
        }
        if (c != null) {
            if (isStart) {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
            } else {
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                c.set(14, 59);
            }
        } else {
            throw new RuntimeException("please set a proper date!");
        }
        return c;
    }

    private String searchOnResources(Connection conn, Set<ResourceCriteria> criterion, Map<Integer, Object> params) throws SQLException {
        String s = null;
        String where = " WHERE ";
        if (criterion != null && !criterion.isEmpty()) {
            int pos = params.size() + 1;
            for (ResourceCriteria obj : criterion) {
                String[] projectObj = (String[])obj.getValue("project");
                List resTypeObj = (List)obj.getValue("resourceType");
                String resNameObj = (String)obj.getValue("resourceName");
                s = s != null ? String.valueOf(s) + " INTERSECT " : "";
                where = " WHERE ";
                s = String.valueOf(s) + " SELECT DISTINCT a.annID FROM AnnDetail a ";
                if (projectObj != null) {
                    if (projectObj.length == 1) {
                        where = String.valueOf(where) + " a.k='resource' and a.project like ? ";
                        params.put(pos, projectObj[0]);
                        ++pos;
                    } else {
                        where = String.valueOf(where) + " a.k='resource' and a.project IN (";
                        where = String.valueOf(where) + this.getINParams(Arrays.asList(projectObj), true) + ")";
                    }
                }
                if (resNameObj != null) {
                    String[] parts;
                    if (projectObj != null) {
                        where = String.valueOf(where) + " and ";
                    }
                    if ((parts = resNameObj.split(",")).length > 1) {
                        where = String.valueOf(where) + " a.resName in (";
                        where = String.valueOf(where) + this.getINParams(Arrays.asList(parts), true) + ")";
                    } else {
                        where = String.valueOf(where) + " a.resName like ? ";
                        resNameObj = Utils.convertDbLikeValue((String)resNameObj, (boolean)true);
                        params.put(pos, resNameObj);
                        ++pos;
                    }
                }
                if (resTypeObj != null) {
                    if (projectObj != null || resNameObj != null) {
                        where = String.valueOf(where) + " and ";
                    }
                    if (resTypeObj.size() > 1) {
                        HashSet<String> otherTypes = new HashSet<String>();
                        HashSet<String> prgTypes = new HashSet<String>();
                        for (Triplet t : resTypeObj) {
                            String resType = (String)t.getThird();
                            if ("5".equals(resType)) {
                                if (t.getFirst() != null) {
                                    prgTypes.add(((Integer)t.getFirst()).toString());
                                    continue;
                                }
                                L.warn("resource program without program type?!");
                                otherTypes.add(resType);
                                continue;
                            }
                            otherTypes.add(resType);
                        }
                        if (!otherTypes.isEmpty()) {
                            where = String.valueOf(where) + " ( ( a.resType in (";
                            where = String.valueOf(where) + this.getINParams(otherTypes, true) + ") )";
                            where = !prgTypes.isEmpty() ? String.valueOf(where) + " OR " : String.valueOf(where) + " )";
                        } else {
                            where = String.valueOf(where) + "( ";
                        }
                        if (!prgTypes.isEmpty()) {
                            where = String.valueOf(where) + " (a.resType='5' and a.progType in (";
                            where = String.valueOf(where) + this.getINParams(prgTypes, false) + ") ) )";
                        }
                    } else {
                        String resType = (String)((Triplet)resTypeObj.get(0)).getThird();
                        Integer prgType = (Integer)((Triplet)resTypeObj.get(0)).getFirst();
                        where = String.valueOf(where) + " a.resType like ? ";
                        params.put(pos, resType);
                        ++pos;
                        if (prgType != null) {
                            where = String.valueOf(where) + " and a.progType like ? ";
                            params.put(pos, prgType);
                            ++pos;
                        }
                    }
                }
                s = String.valueOf(s) + where;
            }
        }
        return s;
    }

    private String getINParams(Collection<String> values, boolean asString) {
        StringBuffer buff = new StringBuffer();
        if (values != null && !values.isEmpty()) {
            for (String p : values) {
                if (asString) {
                    buff.append("'");
                }
                buff.append(p.trim());
                if (asString) {
                    buff.append("'");
                }
                buff.append(",");
            }
            buff = buff.deleteCharAt(buff.length() - 1);
        }
        return buff.toString();
    }

    private Map<Integer, Set<EZAnnotation>> fillDetails(Map<Integer, EZAnnotation> anns, ResultSet details) throws SQLException {
        HashMap<Integer, Set<EZAnnotation>> toComplete = new HashMap<Integer, Set<EZAnnotation>>();
        while (details.next()) {
            Timestamp sqlDate;
            Integer annID = details.getInt(1);
            EZAnnotation ann = anns.get(annID);
            if (ann == null) {
                ann = new EZAnnotation();
                ann.setDbId(annID);
                anns.put(annID, ann);
            }
            String key = details.getString(2);
            String value = details.getString(3);
            if ("user".equals(key)) {
                ann.setUser(value);
                continue;
            }
            if ("text".equals(key)) {
                ann.setDescription(value);
                continue;
            }
            if ("keyword".equals(key) && value != null) {
                Integer kId = Integer.valueOf(value);
                HashSet<EZAnnotation> tmp = (HashSet<EZAnnotation>)toComplete.get(kId);
                if (tmp == null) {
                    tmp = new HashSet<EZAnnotation>();
                    toComplete.put(kId, tmp);
                }
                tmp.add(ann);
                continue;
            }
            if ("hyperlink".equals(key)) {
                ann.addHyperlink(value);
                continue;
            }
            if (!"createDate".equals(key) || (sqlDate = details.getTimestamp("createdDate")) == null) continue;
            Date d = new Date(sqlDate.getTime());
            ann.setDate(d);
        }
        return toComplete;
    }

    private synchronized void configureDataSource() {
        DatabaseInfo dbInfo;
        if (this.datasource == null && (dbInfo = AnnotationsDBUtils.getAnnDbInfo()) != null) {
            String sqlServer = dbInfo.getHost();
            String sqlPort = String.valueOf(dbInfo.getPort());
            String instance = dbInfo.getInstance();
            if (instance != null && instance.isEmpty()) {
                instance = null;
            }
            String protocol = dbInfo.getProtocol();
            Boolean trustServerCertificate = dbInfo.isTrustServerCertificate();
            String db = dbInfo.getDatabase();
            String user = dbInfo.getUsername();
            String pass = dbInfo.getPassword();
            String dbType = dbInfo.getServerType();
            String schemaName = dbInfo.getSchema();
            String testString = null;
            String connString = null;
            this.dbEngine = ServerType.findByName((String)dbType);
            if (this.dbEngine == null) {
                L.warn("unknown database server type: {}; SqlServer it will be used!", (Object)dbType);
                this.dbEngine = ServerType.SqlServer;
            }
            String driverClass = null;
            StringBuilder sb = null;
            HikariConfig config = new HikariConfig();
            switch (this.dbEngine) {
                case SqlServer: {
                    String trustStorePath;
                    sb = new StringBuilder();
                    sb.append("jdbc:sqlserver://").append(sqlServer).append(":").append(sqlPort).append(";databaseName=").append(db);
                    if (instance != null && (instance = instance.trim()).length() > 0) {
                        sb.append(";instanceName=").append(instance);
                    }
                    if (protocol != null && !protocol.trim().isEmpty()) {
                        protocol = protocol.trim();
                        L.debug("Protocol: " + protocol);
                        L.debug("trustServerCertificate: " + trustServerCertificate);
                        if (protocol.equals("TLSv1.2") && Boolean.valueOf(trustServerCertificate).booleanValue()) {
                            sb.append(";encrypt=true");
                            sb.append(";trustServerCertificate=").append(trustServerCertificate);
                            sb.append(";sslProtocol=").append(protocol);
                        } else if (protocol.equals("TLSv1.2") && !Boolean.valueOf(trustServerCertificate).booleanValue()) {
                            sb.append(";encrypt=true");
                            sb.append(";trustServerCertificate=").append(trustServerCertificate);
                            sb.append(";hostNameInCertificate=").append(sqlServer);
                            sb.append(";sslProtocol=").append(protocol);
                        } else if (protocol.equals("TLSv1.3")) {
                            sb.append(";encrypt=strict");
                            sb.append(";trustServerCertificate=false");
                            sb.append(";hostNameInCertificate=").append(sqlServer);
                            sb.append(";sslProtocol=").append(protocol);
                        }
                        if (protocol.equals("TLSv1.2") && !Boolean.valueOf(trustServerCertificate).booleanValue() || protocol.equals("TLSv1.3")) {
                            trustStorePath = System.getProperty("javax.net.ssl.trustStore");
                            if (trustStorePath == null || trustStorePath.trim().isEmpty()) {
                                throw new RuntimeException(String.valueOf(protocol) + " - property javax.net.ssl.trustStore was not set to a valid path.");
                            }
                            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                            if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
                                throw new RuntimeException(String.valueOf(protocol) + " - property javax.net.ssl.trustStorePassword was not set to a valid password.");
                            }
                            config.addDataSourceProperty("trustStore", (Object)trustStorePath);
                            config.addDataSourceProperty("trustStorePassword", (Object)trustStorePassword);
                        }
                    } else {
                        L.debug("Protocol: null => encrypt=true;trustServerCertificate=true;sslProtocol=TLSv1.2");
                        sb.append(";encrypt=true");
                        sb.append(";trustServerCertificate=true");
                        sb.append(";sslProtocol=TLSv1.2");
                    }
                    connString = sb.toString();
                    L.info("connection string: " + connString);
                    testString = "select 1";
                    driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    break;
                }
                case Db2Z: {
                    connString = "jdbc:db2://" + sqlServer + ":" + sqlPort + "/" + instance + ":" + "currentPath=" + schemaName + ";" + "currentSchema=" + schemaName + ";" + "currentFunctionPath=" + schemaName + ";";
                    testString = "SELECT 1 FROM sysibm.sysdummy1";
                    driverClass = "com.ibm.db2.jcc.DB2Driver";
                    break;
                }
                case Db2: {
                    String trustStorePath;
                    if (schemaName == null) {
                        L.warn("Schema not provided, using default schema EZSCH");
                        schemaName = "EZSCH";
                    }
                    sb = new StringBuilder();
                    sb.append("jdbc:db2://");
                    sb.append(sqlServer);
                    sb.append(":");
                    sb.append(sqlPort);
                    sb.append("/");
                    sb.append(db);
                    sb.append(":currentPath=").append(schemaName);
                    sb.append(";currentSchema=").append(schemaName);
                    sb.append(";currentFunctionPath=").append(schemaName);
                    if (dbInfo.useTLS()) {
                        sb.append(";sslConnection=").append(true);
                        if (protocol == null || protocol.trim().isEmpty()) {
                            throw new IllegalArgumentException("No protocol.");
                        }
                        sb.append(";sslVersion=").append(protocol);
                        trustStorePath = System.getProperty("javax.net.ssl.trustStore");
                        if (trustStorePath == null || trustStorePath.trim().isEmpty()) {
                            throw new RuntimeException(String.valueOf(protocol) + " - property javax.net.ssl.trustStore was not set to a valid path.");
                        }
                        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                        if (trustStorePassword == null || trustStorePassword.trim().isEmpty()) {
                            throw new RuntimeException(String.valueOf(protocol) + " - property javax.net.ssl.trustStorePassword was not set to a valid password.");
                        }
                        config.addDataSourceProperty("sslTrustStoreLocation", (Object)trustStorePath);
                        config.addDataSourceProperty("sslTrustStorePassword", (Object)trustStorePassword);
                    }
                    sb.append(";");
                    connString = sb.toString();
                    testString = "SELECT 1 FROM sysibm.sysdummy1";
                    driverClass = "com.ibm.db2.jcc.DB2Driver";
                    break;
                }
            }
            if (sqlServer == null || sqlPort == null || db == null || connString == null) {
                throw new IllegalArgumentException("database connection string is not properly configured: " + connString);
            }
            if (user == null || pass == null) {
                throw new IllegalArgumentException("user or pass not specified");
            }
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                L.error("error loading driver class: {}", driverClass, (Object)e);
            }
            if (testString != null) {
                config.setConnectionTestQuery(testString);
            }
            config.setJdbcUrl(connString);
            config.setUsername(user);
            config.setPassword(pass);
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            this.datasource = new HikariDataSource(config);
        }
    }

    public Set<EZKeyword> getAllKeywords() throws SQLException {
        return this.getAllKeywords((IProgressMonitor)new NullProgressMonitor());
    }

    public Set<EZKeyword> getAllKeywords(IProgressMonitor monitor) throws SQLException {
        SQLException e;
        HashSet<EZKeyword> ret;
        block28: {
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            ret = new HashSet<EZKeyword>();
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement pst = null;
            e = null;
            try {
                try {
                    pst = conn.prepareStatement("SELECT * from Keyword ORDER by name");
                    ResultSet rs = pst.executeQuery();
                    while (rs.next()) {
                        Integer kID = rs.getInt(1);
                        String name = rs.getString(2);
                        ret.add(new EZKeyword(kID, name));
                    }
                }
                catch (SQLException ex) {
                    L.debug("error getting all keywords", (Throwable)ex);
                    e = ex;
                    if (pst != null) {
                        pst.close();
                    }
                    if (conn == null) break block28;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block28;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (pst != null) {
                    pst.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (pst != null) {
                pst.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return ret.isEmpty() ? null : ret;
    }

    public void saveKeywords(Set<EZKeyword> keysSet) throws SQLException {
        this.saveKeywords(keysSet, (IProgressMonitor)new NullProgressMonitor());
    }

    public void saveKeywords(Set<EZKeyword> keysSet, IProgressMonitor monitor) throws SQLException {
        SQLException e;
        block35: {
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Statement insStmt = null;
            Statement updStmt = null;
            e = null;
            try {
                try {
                    boolean hasIns = false;
                    boolean hasUpd = false;
                    HashSet<EZKeyword> toRem = new HashSet<EZKeyword>();
                    String tempTbl = Utils.getTempTableName((ServerType)this.dbEngine, (String)"keyTmp");
                    this.createTempTbl(tempTbl, conn, false);
                    String q = "insert into AD_TEMPTBL VALUES (?)".replace("AD_TEMPTBL", tempTbl);
                    PreparedStatement pst = conn.prepareStatement(q);
                    insStmt = conn.prepareStatement("insert into Keyword(name) values (?)");
                    updStmt = conn.prepareStatement("update Keyword set name = ? where id=?");
                    for (EZKeyword k : keysSet) {
                        if (k.getId() == null) {
                            insStmt.setString(1, k.getName());
                            insStmt.addBatch();
                            hasIns = true;
                            pst.setString(1, k.getName());
                            pst.addBatch();
                            toRem.add(k);
                            continue;
                        }
                        updStmt.setString(1, k.getName());
                        updStmt.setInt(2, k.getId());
                        updStmt.addBatch();
                        hasUpd = true;
                    }
                    if (hasIns) {
                        insStmt.executeBatch();
                        keysSet.removeAll(toRem);
                        toRem = null;
                        pst.executeBatch();
                        pst.close();
                        String query = "select * from Keyword where Keyword.name IN (select * from AD_FROM )".replace("AD_FROM", tempTbl);
                        pst = conn.prepareStatement(query);
                        ResultSet rs = pst.executeQuery();
                        while (rs.next()) {
                            Integer id = rs.getInt(1);
                            String k = rs.getString(2);
                            keysSet.add(new EZKeyword(id, k));
                        }
                        pst.close();
                        this.cleanTempTbl(conn, tempTbl);
                    }
                    if (hasUpd) {
                        updStmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    L.debug("error saving keywords", (Throwable)ex);
                    e = ex;
                    if (insStmt != null) {
                        insStmt.close();
                    }
                    if (updStmt != null) {
                        updStmt.close();
                    }
                    if (conn == null) break block35;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block35;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (insStmt != null) {
                    insStmt.close();
                }
                if (updStmt != null) {
                    updStmt.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (insStmt != null) {
                insStmt.close();
            }
            if (updStmt != null) {
                updStmt.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void deleteKeyword(EZKeyword keyword, IProgressMonitor monitor) throws SQLException {
        SQLException e;
        block28: {
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement stmt1 = null;
            PreparedStatement updStmt = null;
            e = null;
            try {
                try {
                    stmt1 = conn.prepareStatement("select annID from AnnDetail where  k='keyword' and value=?");
                    stmt1.setString(1, keyword.getId().toString());
                    ResultSet rs = stmt1.executeQuery();
                    boolean hasAnn = rs.next();
                    if (hasAnn) {
                        throw new EZDbException("Keyword has annotations associated!", EZDbException.KEYWORD_HAS_ANNOTATIONS);
                    }
                    updStmt = conn.prepareStatement("delete from Keyword where id=?");
                    updStmt.setInt(1, keyword.getId());
                    updStmt.executeUpdate();
                }
                catch (SQLException ex) {
                    L.debug("error deleting keyword: {}", (Object)keyword, (Object)ex);
                    e = ex;
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    if (conn == null) break block28;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block28;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (stmt1 != null) {
                    stmt1.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (stmt1 != null) {
                stmt1.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public boolean logicalDeleteAnn(EZAnnotation currentAnn, IProgressMonitor monitor) throws SQLException {
        SQLException e;
        boolean ret;
        block27: {
            ret = false;
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement st = null;
            e = null;
            try {
                try {
                    st = conn.prepareStatement("UPDATE Annotation SET deleted=1 WHERE id=?");
                    st.setInt(1, currentAnn.getDbId());
                    int res = st.executeUpdate();
                    ret = res > 0;
                }
                catch (SQLException ex) {
                    L.debug("error try to mark as deleted annotation with dbID={}", (Object)currentAnn.getDbId(), (Object)ex);
                    e = ex;
                    if (st != null) {
                        st.close();
                    }
                    if (conn == null) break block27;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block27;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return ret;
    }

    public boolean deleteAnn(EZAnnotation currentAnn, IProgressMonitor monitor) throws SQLException {
        SQLException e;
        boolean ret;
        block27: {
            ret = false;
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            PreparedStatement st = null;
            e = null;
            try {
                try {
                    st = conn.prepareStatement("DELETE from Annotation where id=?");
                    st.setInt(1, currentAnn.getDbId());
                    int res = st.executeUpdate();
                    ret = res > 0;
                }
                catch (SQLException ex) {
                    L.debug("error deleting annotation with dbID={}", (Object)currentAnn.getDbId(), (Object)ex);
                    e = ex;
                    if (st != null) {
                        st.close();
                    }
                    if (conn == null) break block27;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block27;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return ret;
    }

    public boolean hasAnn(String prjName, String resTypeId, String dbId) throws SQLException {
        this.configureDataSource();
        if (this.datasource == null) {
            throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
        }
        boolean has = false;
        if (prjName != null && resTypeId != null && dbId != null) {
            SQLException e;
            block16: {
                Connection conn = null;
                Statement st = null;
                e = null;
                try {
                    try {
                        conn = this.datasource.getConnection();
                        st = conn.prepareStatement("SELECT COUNT (annResID) from Resource inner join AnnResource on AnnResource.ID=Resource.annResID inner join Annotation on annotation.id=AnnResource.annID where Annotation.deleted=0 and projectInfo=? and resTypeID=? and dbID=?");
                        st.setString(1, prjName);
                        st.setInt(2, new Integer(resTypeId));
                        st.setInt(3, new Integer(dbId));
                        ResultSet res = st.executeQuery();
                        while (res.next()) {
                            boolean bl = has = res.getInt(1) > 0;
                        }
                    }
                    catch (SQLException ex) {
                        L.debug("error founding annotations for prjName={}, resType={}, dbId={}", new Object[]{prjName, resTypeId, dbId, ex});
                        e = ex;
                        if (st != null) {
                            st.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        st.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    throw throwable;
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            if (e != null) {
                throw e;
            }
        } else {
            L.warn("input without a project, resourceType or dbId; cannot find annotations");
        }
        return has;
    }

    public boolean hasAnn(EZObjectType inputType) throws SQLException {
        this.configureDataSource();
        if (this.datasource == null) {
            throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
        }
        boolean has = false;
        String RID = ResourceIdentificator.getRID(inputType);
        if (RID != null) {
            String prjName = null;
            EZSourceProjectIDSg prjsg = (EZSourceProjectIDSg)inputType.getEntID().getSegment(EZSourceProjectIDSg.class);
            if (prjsg != null) {
                SQLException e;
                block18: {
                    prjName = prjsg.getProjectName();
                    Connection conn = null;
                    Statement st = null;
                    e = null;
                    try {
                        try {
                            conn = this.datasource.getConnection();
                            st = conn.prepareStatement("SELECT COUNT (AnnResource.ID) from AnnResource inner join Resource on Resource.annResID=AnnResource.ID inner join Annotation on Annotation.id=AnnResource.annID where Annotation.deleted=0 AND AnnResource.RID=? AND Resource.projectInfo=?");
                            st.setString(1, RID);
                            st.setString(2, prjName);
                            ResultSet res = st.executeQuery();
                            while (res.next()) {
                                boolean bl = has = res.getInt(1) > 0;
                            }
                        }
                        catch (SQLException ex) {
                            L.debug("error founding annotations for: {}", (Object)inputType, (Object)ex);
                            e = ex;
                            if (st != null) {
                                st.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            st.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        throw throwable;
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                if (e != null) {
                    throw e;
                }
            } else {
                L.warn("input without a project segment; cannot find annotations");
            }
        } else {
            L.warn("input without RID: {}; cannot find annotations", (Object)inputType);
        }
        return has;
    }

    public Set<EZObjectType> haveAnnotations(Set<EZObjectType> inputs, SubMonitor monitor) throws SQLException {
        SQLException e;
        HashSet<EZObjectType> ret;
        block42: {
            this.configureDataSource();
            if (this.datasource == null) {
                throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
            }
            ret = new HashSet<EZObjectType>();
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Statement insertSt = null;
            Statement st = null;
            e = null;
            try {
                try {
                    HashMap<Integer, EZObjectType> tmp = new HashMap<Integer, EZObjectType>();
                    int k = 1;
                    String tblName = Utils.getTempTableName((ServerType)this.dbEngine, (String)"tmp");
                    String sqlStr = null;
                    switch (this.dbEngine) {
                        case SqlServer: {
                            sqlStr = "create table " + tblName + " (id [int] not null, project [nvarchar] (100) not null, restypeid [int], dbID [int] )";
                            break;
                        }
                        case Db2Z: {
                            sqlStr = " DECLARE GLOBAL TEMPORARY TABLE " + tblName + " (id integer not null, project vargraphic(100) not null, restypeid integer, dbID integer )" + " CCSID UNICODE " + " ON COMMIT PRESERVE ROWS NOT LOGGED ";
                            break;
                        }
                        case Db2: {
                            sqlStr = " DECLARE GLOBAL TEMPORARY TABLE " + tblName + " (id integer not null, project vargraphic(100) not null, restypeid integer, dbID integer )" + " WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ";
                            break;
                        }
                    }
                    Assert.isNotNull(sqlStr);
                    conn.createStatement().execute(sqlStr);
                    insertSt = conn.prepareStatement("insert into AD_TBLNAME values (?, ?, ?, ?)".replace("AD_TBLNAME", tblName));
                    for (EZObjectType o : inputs) {
                        Integer resTypeID = null;
                        Integer dbid = null;
                        EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)o.getEntID().getSegment(EZSourceProgramIDSg.class);
                        if (prgsg != null) {
                            resTypeID = Integer.valueOf("5");
                            dbid = prgsg.getProgramId();
                        } else {
                            EZSourceJobIDSg jobSg = (EZSourceJobIDSg)o.getEntID().getSegment(EZSourceJobIDSg.class);
                            if (jobSg != null) {
                                resTypeID = Integer.valueOf("22");
                                dbid = jobSg.getJobId();
                            }
                        }
                        if (resTypeID == null || dbid == null) continue;
                        EZSourceProjectIDSg prjsg = (EZSourceProjectIDSg)o.getEntID().getSegment(EZSourceProjectIDSg.class);
                        if (prjsg != null) {
                            String prjName = prjsg.getProjectName();
                            if (prjName == null) continue;
                            tmp.put(k, o);
                            insertSt.setInt(1, k);
                            insertSt.setString(2, prjName);
                            insertSt.setInt(3, resTypeID);
                            insertSt.setInt(4, dbid);
                            insertSt.addBatch();
                            ++k;
                            continue;
                        }
                        L.warn("input without project segment: {}", (Object)o);
                    }
                    insertSt.executeBatch();
                    if (k > 1) {
                        String q = "SELECT AD_TBLNAME.id from Resource inner join AD_TBLNAME on Resource.projectInfo=AD_TBLNAME.project and Resource.resTypeID=AD_TBLNAME.restypeid and Resource.dbID=AD_TBLNAME.dbid inner join AnnResource on AnnResource.ID=Resource.annResID inner join Annotation on annotation.id=AnnResource.annID where Annotation.deleted=0 group by AD_TBLNAME.id ";
                        st = conn.prepareStatement(q.replaceAll("AD_TBLNAME", tblName));
                        ResultSet rs = st.executeQuery();
                        while (rs.next()) {
                            Integer id = rs.getInt(1);
                            ret.add((EZObjectType)tmp.remove(id));
                        }
                    }
                    Statement createTemp = conn.createStatement();
                    String delQ = String.format("delete from %s", tblName);
                    String dropQ = String.format("drop table %s", tblName);
                    createTemp.execute(delQ);
                    createTemp.execute(dropQ);
                    createTemp.close();
                    tmp.clear();
                }
                catch (SQLException ex) {
                    L.debug("error finding annotations for many inputs", (Throwable)ex);
                    e = ex;
                    if (insertSt != null) {
                        insertSt.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (conn == null) break block42;
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        break block42;
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (insertSt != null) {
                    insertSt.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    try {
                        if (e != null) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                    }
                    finally {
                        conn.setAutoCommit(ac);
                        conn.close();
                    }
                }
                throw throwable;
            }
            if (insertSt != null) {
                insertSt.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                try {
                    if (e != null) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                }
                finally {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
            }
        }
        if (e != null) {
            throw e;
        }
        return ret;
    }

    public void closeDatasource() {
        if (this.datasource != null) {
            ((HikariDataSource)this.datasource).close();
        } else {
            L.info("datasource not configured! close is ignored");
        }
    }

    public void saveAnnotations(Set<EZAnnotation> annots, Set<String> projects) throws Exception {
        this.configureDataSource();
        if (this.datasource == null) {
            throw new IllegalStateException(NO_ANN_DATABASE_EXCEPTION_MESSAGE);
        }
        HashSet<String> rids = new HashSet<String>();
        for (EZAnnotation ann : annots) {
            Set<String> st = ann.getRIDs();
            if (st == null || st.isEmpty()) {
                st = new HashSet<String>();
                for (AnnResource r : ann.getResources()) {
                    st.add(r.getRID());
                }
            }
            rids.addAll(st);
        }
        Map<String, Map<String, String[][]>> prjsData = this.checkProjects4Resrs(rids, projects);
        if (prjsData.isEmpty()) {
            L.info("no resources where found for the given RIDs in the given projects {}", projects);
        } else {
            Connection conn = this.datasource.getConnection();
            boolean ac = conn.getAutoCommit();
            conn.setAutoCommit(false);
            for (EZAnnotation ann : annots) {
                Exception e = null;
                try {
                    try {
                        Integer annId = this.saveAnnotation(conn, true, ann);
                        this.saveAnnDetails(ann, conn, annId, true);
                        Map<String, Integer> ids = this.saveAnnResource(conn, annId, ann);
                        Set<String> resRIDs = ann.getRIDs();
                        for (String RID : resRIDs) {
                            Map<String, String[][]> dbData = prjsData.get(RID);
                            for (String prjName : dbData.keySet()) {
                                ResourceIdentificator.saveAnnotResource(annId, ids, conn, prjName, dbData.get(prjName));
                            }
                        }
                    }
                    catch (Exception ex) {
                        L.error("error saving one annotation; continue trying to save the others", (Throwable)ex);
                        e = ex;
                        if (conn == null) continue;
                        try {
                            if (e != null) {
                                conn.rollback();
                                continue;
                            }
                            conn.commit();
                            continue;
                        }
                        finally {
                            L.debug("finally of saving annotation {}", (Object)ann.getDbId());
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            if (e != null) {
                                conn.rollback();
                            } else {
                                conn.commit();
                            }
                        }
                        finally {
                            L.debug("finally of saving annotation {}", (Object)ann.getDbId());
                        }
                    }
                    throw throwable;
                }
                if (conn == null) continue;
                try {
                    if (e != null) {
                        conn.rollback();
                        continue;
                    }
                    conn.commit();
                }
                finally {
                    L.debug("finally of saving annotation {}", (Object)ann.getDbId());
                }
            }
            if (conn != null) {
                try {
                    conn.setAutoCommit(ac);
                    conn.close();
                }
                finally {
                    L.debug("end of saving annotations");
                }
            }
        }
    }

    private Map<String, Map<String, String[][]>> checkProjects4Resrs(Set<String> RIDs, Set<String> projects) {
        HashMap<String, Map<String, String[][]>> ret = new HashMap<String, Map<String, String[][]>>();
        ResourceFindRunnableService srv = (ResourceFindRunnableService)ServiceUtils.getService(ResourceFindRunnableService.class);
        if (srv != null) {
            for (String prjName : projects) {
                String[][] dbRes = srv.find(RIDs, prjName);
                if (dbRes == null || dbRes.length <= 0) continue;
                int i = 0;
                while (i < dbRes.length) {
                    String[][] rrr;
                    String RID = dbRes[i][0];
                    HashMap<String, String[][]> prjData = (HashMap<String, String[][]>)ret.get(RID);
                    if (prjData == null) {
                        prjData = new HashMap<String, String[][]>();
                        ret.put(RID, prjData);
                    }
                    if ((rrr = (String[][])prjData.get(prjName)) == null) {
                        rrr = new String[1][dbRes[i].length];
                        prjData.put(prjName, rrr);
                    }
                    System.arraycopy(dbRes[i], 0, rrr[0], 0, dbRes[i].length);
                    ++i;
                }
            }
        } else {
            L.warn("ResourceFind service not found; cannot continue");
        }
        return ret;
    }
}

