/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.tableviewer;

import com.ez.mainframe.editors.ContentEditorInput;
import com.ez.mainframe.editors.IEZSourceViewer;
import com.ez.mainframe.editors.tableviewer.EditorNatTableStyleConfiguration;
import com.ez.mainframe.editors.tableviewer.FileDataProvider;
import com.ez.mainframe.editors.tableviewer.ISyntaxProvider;
import com.ez.mainframe.editors.tableviewer.NoGridDataLayer;
import com.ez.mainframe.editors.tableviewer.NoGridSelectionLayer;
import com.ez.mainframe.editors.tableviewer.NoGridViewportLayer;
import com.ez.mainframe.editors.tableviewer.SelectionLayerConfiguration;
import com.ez.mainframe.editors.tableviewer.SyntaxTextPainter;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewListEditor
extends EditorPart
implements IEZSourceViewer {
    private static final Logger L = LoggerFactory.getLogger(ViewListEditor.class);
    private NatTable viewer;
    private SelectionLayer sl;
    private ViewportLayer vl;
    private IDataProvider dp;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        File file = null;
        try {
            if (input instanceof IURIEditorInput) {
                file = new File(((IURIEditorInput)input).getURI());
            } else if (input instanceof ContentEditorInput) {
                file = new File(((ContentEditorInput)input).getPath());
            }
            if (file != null) {
                this.dp = new FileDataProvider(file);
            }
        }
        catch (Exception e) {
            L.error("could not open file {}", (Object)input.getName(), (Object)e);
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.init(parent, this.dp);
    }

    protected abstract ISyntaxProvider getSyntaxProvider();

    private NatTable init(Composite parent, IDataProvider dp) {
        NatTable viewer = null;
        NoGridDataLayer dl = new NoGridDataLayer(dp);
        dl.setColumnPercentageSizing(true);
        dl.setColumnWidthPercentageByPosition(0, 100);
        SyntaxTextPainter sp = new SyntaxTextPainter(this.getSyntaxProvider());
        EditorNatTableStyleConfiguration conf = new EditorNatTableStyleConfiguration((ICellPainter)sp);
        dl.addConfiguration((IConfiguration)conf);
        this.sl = new NoGridSelectionLayer((IUniqueIndexLayer)dl);
        this.sl.addConfiguration((IConfiguration)new SelectionLayerConfiguration(dp));
        CopyDataCommandHandler copyHandler = new CopyDataCommandHandler(this.sl);
        copyHandler.setCopyFormattedText(true);
        this.vl = new NoGridViewportLayer((IUniqueIndexLayer)this.sl);
        this.vl.setRegionName("BODY");
        this.vl.registerCommandHandler((ILayerCommandHandler)copyHandler);
        DataLayer rowData = new DataLayer((IDataProvider)new DefaultRowHeaderDataProvider(dp));
        int digitCount = dp == null ? 0 : this.getDigitCount(dp.getRowCount());
        int fontHeight = JFaceResources.getTextFont().getFontData()[0].getHeight();
        int fontWidth = fontHeight * 5 / 6;
        int space = 5;
        rowData.setDefaultColumnWidth(space + fontWidth * digitCount);
        rowData.setColumnsResizableByDefault(true);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowData, (ILayer)this.vl, this.sl, false, (ILayerPainter)new CellLayerPainter());
        CompositeLayer compositeLayer = new CompositeLayer(2, 1);
        compositeLayer.setChildLayer("ROW_HEADER", (ILayer)rowHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)this.vl, 1, 0);
        viewer = new NatTable(parent, (ILayer)compositeLayer, false);
        viewer.configure();
        return viewer;
    }

    @Override
    public void jumpTo(int[] bounds) {
        if (bounds != null && bounds.length > 0) {
            int line = bounds[0];
            int cc = this.sl.getColumnCount();
            int i = 0;
            while (i < cc) {
                this.sl.setSelectedCell(i, line - 1);
                ++i;
            }
            this.vl.moveRowPositionIntoViewport(line - 1);
        }
    }

    @Override
    public void jumpTo(int startOffset) {
        this.jumpTo(new int[]{((FileDataProvider)this.dp).getLineNumberForCharOffset(startOffset)});
    }

    private int getDigitCount(int number) {
        int digits = 0;
        while (number > 0) {
            ++digits;
            number /= 10;
        }
        return digits;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void dispose() {
        ((FileDataProvider)this.dp).clearLineIndexes();
        super.dispose();
    }
}

