/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.tableviewer;

import com.ez.mainframe.editors.tableviewer.ISyntaxElement;
import com.ez.mainframe.editors.tableviewer.ISyntaxProvider;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SyntaxTextPainter
extends TextPainter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ISyntaxProvider syntaxProvider;

    public SyntaxTextPainter(ISyntaxProvider syntaxProvider) {
        this.syntaxProvider = syntaxProvider;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        block7: {
            Rectangle originalClipping;
            block9: {
                String[] lines;
                int contentHeight;
                String text;
                int fontHeight;
                boolean strikethrough;
                boolean underline;
                IStyle cellStyle;
                block8: {
                    Color backgroundColor;
                    if (this.paintBg && (backgroundColor = this.getBackgroundColour(cell, configRegistry)) != null) {
                        Color originalBackground = gc.getBackground();
                        gc.setBackground(backgroundColor);
                        gc.fillRectangle(rectangle);
                        gc.setBackground(originalBackground);
                    }
                    if (!this.paintFg) break block7;
                    originalClipping = gc.getClipping();
                    gc.setClipping(rectangle.intersection(originalClipping));
                    cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
                    this.setupGCFromConfig(gc, cellStyle);
                    underline = this.renderUnderlined(cellStyle);
                    strikethrough = this.renderStrikethrough(cellStyle);
                    fontHeight = gc.getFontMetrics().getHeight();
                    text = this.convertDataType(cell, configRegistry);
                    text = this.getTextToDisplay(cell, gc, rectangle.width, text);
                    int numberOfNewLines = this.getNumberOfNewLines(text);
                    contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
                    int contentToCellDiff = cell.getBounds().height - rectangle.height;
                    if (this.performRowResize(contentHeight, rectangle)) {
                        ILayer layer = cell.getLayer();
                        layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
                    }
                    if (numberOfNewLines != 1) break block8;
                    int contentWidth = Math.min(this.getLengthFromCache(gc, text), rectangle.width);
                    this.drawTextInLine(gc, text, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentWidth) + this.spacing, rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight) + this.spacing, 3, cellStyle);
                    if (!underline && !strikethrough) break block9;
                    int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentWidth) + this.spacing;
                    int y = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight) + this.spacing;
                    if (underline) {
                        int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                        gc.drawLine(x, underlineY, x + gc.textExtent((String)text).x, underlineY);
                    }
                    if (!strikethrough) break block9;
                    int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                    gc.drawLine(x, strikeY, x + gc.textExtent((String)text).x, strikeY);
                    break block9;
                }
                int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                    this.drawTextInLine(gc, line, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing, yStartPos + this.spacing, 3, cellStyle);
                    if (underline || strikethrough) {
                        int x = rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing;
                        int y = yStartPos + this.spacing;
                        if (underline) {
                            int underlineY = y + fontHeight - gc.getFontMetrics().getDescent() / 2;
                            gc.drawLine(x, underlineY, x + gc.textExtent((String)line).x, underlineY);
                        }
                        if (strikethrough) {
                            int strikeY = y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2;
                            gc.drawLine(x, strikeY, x + gc.textExtent((String)line).x, strikeY);
                        }
                    }
                    yStartPos += fontHeight;
                    ++n2;
                }
            }
            gc.setClipping(originalClipping);
        }
    }

    protected void drawTextInLine(GC gc, String text, int x, int y, int flags, IStyle baseStyle) {
        if (this.syntaxProvider == null) {
            gc.drawText(text, x, y, flags);
        } else {
            ISyntaxElement[] chunks = this.syntaxProvider.getSyntax(text);
            if (chunks != null) {
                int px = x;
                ISyntaxElement[] iSyntaxElementArray = chunks;
                int n = chunks.length;
                int n2 = 0;
                while (n2 < n) {
                    ISyntaxElement chunk = iSyntaxElementArray[n2];
                    IStyle style = chunk.getStyle();
                    String part = chunk.getText();
                    this.setupGCFromConfig(gc, style);
                    gc.drawText(part, px, y);
                    px += gc.textExtent((String)part).x;
                    this.setupGCFromConfig(gc, baseStyle);
                    ++n2;
                }
            } else {
                gc.drawText(text, x, y, flags);
            }
        }
    }

    public void setupGCFromConfig(GC gc, IStyle cellStyle) {
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        Font font = (Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        if (font != null) {
            gc.setAntialias(-1);
            gc.setTextAntialias(-1);
            gc.setFont(font);
        }
        gc.setForeground(fg != null ? fg : GUIHelper.COLOR_LIST_FOREGROUND);
        gc.setBackground(bg != null ? bg : GUIHelper.COLOR_LIST_BACKGROUND);
    }
}

