/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.tableviewer;

import com.ez.mainframe.editors.tableviewer.GoToLineDialog;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.KeyEvent;

public class GoToLineAction
implements IKeyAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private GoToLineDialog goToLineDialog;

    public void run(NatTable natTable, KeyEvent event) {
        int opened;
        if (this.goToLineDialog == null) {
            this.goToLineDialog = new GoToLineDialog(natTable.getShell(), natTable);
        }
        if ((opened = this.goToLineDialog.open()) == 0) {
            int line = Integer.parseInt(this.goToLineDialog.getValue());
            ILayer underlying = natTable.getLayer();
            ViewportLayer vpLayer = null;
            if (underlying instanceof ViewportLayer) {
                vpLayer = (ViewportLayer)underlying;
            } else if (underlying instanceof CompositeLayer) {
                CompositeLayer cl = (CompositeLayer)underlying;
                int cc = cl.getColumnCount();
                int rc = cl.getRowCount();
                int r = 0;
                int c = 0;
                while (r < rc || c < cc) {
                    ILayer layer = cl.getUnderlyingLayerByPosition(c, r);
                    if (layer instanceof ViewportLayer) {
                        vpLayer = (ViewportLayer)layer;
                        break;
                    }
                    if (c == cc - 1) {
                        c = 0;
                        ++r;
                        continue;
                    }
                    ++c;
                }
            }
            if (vpLayer != null) {
                vpLayer.moveRowPositionIntoViewport(line - 1);
                IUniqueIndexLayer layer = vpLayer.getScrollableLayer();
                if (layer instanceof SelectionLayer) {
                    SelectionLayer sl = (SelectionLayer)layer;
                    int cc = sl.getColumnCount();
                    int i = 0;
                    while (i < cc) {
                        sl.setSelectedCell(i, line - 1);
                        ++i;
                    }
                }
            } else {
                throw new RuntimeException("For the GoToLineAction to work it needs the a ViewportLayer");
            }
        }
    }
}

