/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.tableviewer;

import com.ez.internal.file.LineFileReader;
import com.ez.mainframe.editors.EZEditorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataProvider
implements IDataProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2025.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FileDataProvider.class);
    private File file;
    private TreeMap<Long, Long[]> lineIndexes;

    public FileDataProvider(File file) {
        block14: {
            LineFileReader lineFileReader = null;
            try {
                try {
                    if (!file.exists()) {
                        File tempFile;
                        this.file = tempFile = EZEditorUtil.createTempFile(file);
                        tempFile.deleteOnExit();
                    } else {
                        this.file = file;
                    }
                    lineFileReader = new LineFileReader(this.file, Charset.forName(ResourcesPlugin.getEncoding()));
                    this.lineIndexes = lineFileReader.getLineIndexes();
                }
                catch (Exception e) {
                    L.error("Error while opening/reading file {}: ", (Object)file.getAbsolutePath(), (Object)e);
                    if (lineFileReader == null) break block14;
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e2) {
                        L.error("Error while closing file {}: ", (Object)file.getAbsolutePath(), (Object)e2);
                    }
                }
            }
            finally {
                if (lineFileReader != null) {
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e) {
                        L.error("Error while closing file {}: ", (Object)file.getAbsolutePath(), (Object)e);
                    }
                }
            }
        }
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Object returnValue;
        block13: {
            returnValue = null;
            LineFileReader lineFileReader = null;
            try {
                try {
                    lineFileReader = new LineFileReader(this.file, this.lineIndexes, Charset.forName(ResourcesPlugin.getEncoding()));
                    this.lineIndexes = lineFileReader.getLineIndexes();
                    if ((long)rowIndex < lineFileReader.getLineCount()) {
                        returnValue = lineFileReader.getLine((long)rowIndex)[0];
                    }
                }
                catch (IOException e) {
                    L.error("Error while opening/reading file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    if (lineFileReader == null) break block13;
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e2) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e2);
                    }
                }
            }
            finally {
                if (lineFileReader != null) {
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    }
                }
            }
        }
        return returnValue;
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        int count;
        block12: {
            count = 0;
            LineFileReader lineFileReader = null;
            try {
                try {
                    lineFileReader = new LineFileReader(this.file, this.lineIndexes, Charset.forName(ResourcesPlugin.getEncoding()));
                    this.lineIndexes = lineFileReader.getLineIndexes();
                    count = Long.valueOf(lineFileReader.getLineCount()).intValue();
                }
                catch (IOException e) {
                    L.error("Error while opening/reading file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    if (lineFileReader == null) break block12;
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e2) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e2);
                    }
                }
            }
            finally {
                if (lineFileReader != null) {
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    }
                }
            }
        }
        return count;
    }

    public int getLineNumberForCharOffset(int charIdx) {
        int lineNumber;
        block13: {
            lineNumber = 0;
            LineFileReader lineFileReader = null;
            try {
                try {
                    lineFileReader = new LineFileReader(this.file, this.lineIndexes, Charset.forName(ResourcesPlugin.getEncoding()));
                    this.lineIndexes = lineFileReader.getLineIndexes();
                    Object[] lineInfo = lineFileReader.getLineOfChar((long)charIdx);
                    if (lineInfo != null && lineInfo[1] != null) {
                        lineNumber = 1 + ((Long)lineInfo[1]).intValue();
                    }
                }
                catch (IOException e) {
                    L.error("Error while opening/reading file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    if (lineFileReader == null) break block13;
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e2) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e2);
                    }
                }
            }
            finally {
                if (lineFileReader != null) {
                    try {
                        lineFileReader.close();
                    }
                    catch (IOException e) {
                        L.error("Error while closing file {}: ", (Object)this.file.getAbsolutePath(), (Object)e);
                    }
                }
            }
        }
        return lineNumber;
    }

    public void clearLineIndexes() {
        if (this.lineIndexes != null) {
            this.lineIndexes.clear();
            this.lineIndexes = null;
        }
    }
}

