/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.tableviewer;

import com.ez.mainframe.editors.tableviewer.ISyntaxElement;
import com.ez.mainframe.editors.tableviewer.ISyntaxProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public abstract class ChunkSyntaxProvider
implements ISyntaxProvider {
    Set<String> commands = new HashSet<String>(){
        {
            this.add("INSERT");
            this.add("USE");
            this.add("DELETE");
            this.add("FOR");
            this.add("COMPILE");
            this.add("SET-DATE-AND-TIME");
        }
    };
    Map<String, Color> colors = new HashMap<String, Color>(){
        {
            this.put("command", Display.getDefault().getSystemColor(9));
            this.put("property", Display.getDefault().getSystemColor(6));
            this.put("name", Display.getDefault().getSystemColor(11));
            this.put("module", Display.getDefault().getSystemColor(14));
            this.put("comment", Display.getDefault().getSystemColor(8));
        }
    };

    @Override
    public ISyntaxElement[] getSyntax(String text) {
        ArrayList<ISyntaxElement> elements = new ArrayList<ISyntaxElement>();
        List<Chunk> chunks = this.chunkify(text);
        int idx = 0;
        int[] state = new int[1];
        for (Chunk chunk : chunks) {
            elements.add(this.describeChunk(idx, chunk, state));
            ++idx;
        }
        return elements.toArray(new ISyntaxElement[0]);
    }

    protected abstract ISyntaxElement describeChunk(int var1, Chunk var2, int[] var3);

    private List<Chunk> chunkify(String text) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int state = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            boolean white = Character.isWhitespace(c);
            switch (state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (white) break;
                    chunks.add(Chunk.make(sb.toString(), start));
                    sb.delete(0, sb.length());
                    start = i;
                    break;
                }
                case 2: {
                    if (!white) break;
                    chunks.add(Chunk.make(sb.toString(), start));
                    sb.delete(0, sb.length());
                    start = i;
                }
            }
            state = white ? 1 : 2;
            sb.append(c);
            ++i;
        }
        if (sb.length() != 0) {
            chunks.add(Chunk.make(sb.toString(), start));
        }
        return chunks;
    }

    public static class Chunk {
        public String text;
        public int pos;

        static Chunk make(String text, int pos) {
            Chunk c = new Chunk();
            c.text = text;
            c.pos = pos;
            return c;
        }
    }

    public static class SyntaxElement
    implements ISyntaxElement {
        private IStyle style;
        private String text;

        public static ISyntaxElement createDefault(String text) {
            SyntaxElement se = new SyntaxElement();
            se.text = text;
            se.style = new Style();
            return se;
        }

        public static ISyntaxElement create(String text, Color color) {
            SyntaxElement se = new SyntaxElement();
            se.text = text;
            se.style = new Style();
            se.style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)color);
            return se;
        }

        @Override
        public IStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

