/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.pl1;

import com.ez.mainframe.editors.CaseInsensitiveWordRule;
import com.ez.mainframe.editors.ColorManager;
import com.ez.mainframe.editors.IColorConstants;
import com.ez.mainframe.editors.WhitespaceDetector;
import com.ez.mainframe.editors.WordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class PL1CodeScanner
extends RuleBasedScanner {
    public PL1CodeScanner(ColorManager manager, String[] keywords) {
        Token string = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.STRING)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.KEYWORD), manager.getColor(IColorConstants.BACKGROUND), 1));
        Token other = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        this.setDefaultReturnToken((IToken)other);
        rules.add((Object)new WordPredicateRule((IToken)string));
        rules.add(new MultiLineRule("/*", "*/", (IToken)string, '\u0000', true));
        rules.add(new SingleLineRule("/*", "*/", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new SingleLineRule("`", "`", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        CaseInsensitiveWordRule wordRule = new CaseInsensitiveWordRule(new WordDetector(), (IToken)other);
        int i = 0;
        int n = keywords.length;
        while (i < n) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class WordPredicateRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public WordPredicateRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return super.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

