/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.natural;

import com.ez.mainframe.editors.CaseInsensitiveWordRule;
import com.ez.mainframe.editors.ColorManager;
import com.ez.mainframe.editors.IColorConstants;
import com.ez.mainframe.editors.WhitespaceDetector;
import com.ez.mainframe.editors.WordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class NaturalCodeScanner
extends RuleBasedScanner {
    private static final int columnRule = 5;

    public NaturalCodeScanner(ColorManager manager, String[] keywords) {
        Token string = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.STRING)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.KEYWORD), manager.getColor(IColorConstants.BACKGROUND), 1));
        Token other = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        this.setDefaultReturnToken((IToken)other);
        EndOfLineRule starRule = new EndOfLineRule("*", (IToken)string);
        starRule.setColumnConstraint(5);
        rules.add(starRule);
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new SingleLineRule("`", "`", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        CaseInsensitiveWordRule wordRule = new CaseInsensitiveWordRule(new WordDetector(), (IToken)other);
        int i = 0;
        int n = keywords.length;
        while (i < n) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

