/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.jcl;

import com.ez.mainframe.editors.CaseInsensitiveWordRule;
import com.ez.mainframe.editors.ColorManager;
import com.ez.mainframe.editors.IColorConstants;
import com.ez.mainframe.editors.PositionalRule;
import com.ez.mainframe.editors.WhitespaceDetector;
import com.ez.mainframe.editors.jcl.JCLOperatorDetector;
import com.ez.mainframe.editors.jcl.JCLSyntax;
import com.ez.mainframe.editors.jcl.JCLWordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.graphics.RGB;

public class JCLCodeScanner
extends RuleBasedScanner {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public JCLCodeScanner(ColorManager manager) {
        Token string = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.STRING)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.KEYWORD), manager.getColor(IColorConstants.BACKGROUND), 1));
        Token param = new Token((Object)new TextAttribute(manager.getColor(new RGB(115, 44, 123))));
        Token comment = new Token((Object)new TextAttribute(manager.getColor(new RGB(109, 146, 155))));
        Token operator = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.OPERATOR)));
        Token other = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        this.setDefaultReturnToken((IToken)other);
        rules.add(new SingleLineRule("//*", null, (IToken)comment, '\u0000', true));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new SingleLineRule("`", "`", (IToken)string, '\\'));
        PositionalRule after72 = new PositionalRule((IToken)comment, 72, -1);
        rules.add(after72);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        CaseInsensitiveWordRule opRule = new CaseInsensitiveWordRule(new JCLOperatorDetector(), (IToken)other);
        int i = 0;
        int n = JCLSyntax.OPERATORS.length;
        while (i < n) {
            opRule.addWord(JCLSyntax.OPERATORS[i], (IToken)operator);
            ++i;
        }
        rules.add(opRule);
        CaseInsensitiveWordRule keyWordRule = new CaseInsensitiveWordRule(new JCLWordDetector(), (IToken)other);
        int i2 = 0;
        int n2 = JCLSyntax.KEYWORDS.length;
        while (i2 < n2) {
            keyWordRule.addWord(JCLSyntax.KEYWORDS[i2], (IToken)keyword);
            ++i2;
        }
        i2 = 0;
        n2 = JCLSyntax.PARAMS.length;
        while (i2 < n2) {
            keyWordRule.addWord(JCLSyntax.PARAMS[i2], (IToken)param);
            ++i2;
        }
        rules.add(keyWordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

