/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.ddcl;

import com.ez.mainframe.editors.tableviewer.ChunkSyntaxProvider;
import com.ez.mainframe.editors.tableviewer.ISyntaxElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DDCLSyntaxProvider
extends ChunkSyntaxProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Set<String> commands = new HashSet<String>(){
        {
            this.add("INSERT");
            this.add("USE");
            this.add("DELETE");
            this.add("FOR");
            this.add("COMPILE");
            this.add("SET-DATE-AND-TIME");
        }
    };
    Map<String, Color> colors = new HashMap<String, Color>(){
        {
            this.put("command", Display.getDefault().getSystemColor(9));
            this.put("property", Display.getDefault().getSystemColor(6));
            this.put("name", Display.getDefault().getSystemColor(11));
            this.put("module", Display.getDefault().getSystemColor(14));
            this.put("comment", Display.getDefault().getSystemColor(8));
        }
    };

    @Override
    protected ISyntaxElement describeChunk(int idx, ChunkSyntaxProvider.Chunk chunk, int[] state) {
        ISyntaxElement desc = null;
        if (chunk.pos == 0 && this.commands.contains(chunk.text.toUpperCase())) {
            desc = ChunkSyntaxProvider.SyntaxElement.create(chunk.text, this.colors.get("command"));
            state[0] = 1;
        } else if (idx == 2 && chunk.text.startsWith("*")) {
            desc = ChunkSyntaxProvider.SyntaxElement.create(chunk.text, this.colors.get("property"));
            state[0] = 2;
        } else if (chunk.text.startsWith("!") && (chunk.text.endsWith("!/") || chunk.text.endsWith("!"))) {
            desc = ChunkSyntaxProvider.SyntaxElement.create(chunk.text, this.colors.get("name"));
        } else if (idx == 2 && state[0] == 1) {
            desc = ChunkSyntaxProvider.SyntaxElement.create(chunk.text, this.colors.get("module"));
        }
        if (desc == null) {
            desc = ChunkSyntaxProvider.SyntaxElement.createDefault(chunk.text);
        }
        return desc;
    }
}

