/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.ddcl;

import com.ez.mainframe.editors.CaseInsensitiveWordRule;
import com.ez.mainframe.editors.ColorManager;
import com.ez.mainframe.editors.IColorConstants;
import com.ez.mainframe.editors.OperatorDetector;
import com.ez.mainframe.editors.WhitespaceDetector;
import com.ez.mainframe.editors.WordDetector;
import com.ez.mainframe.editors.ddcl.DDCLSyntax;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class DDCLCodeScanner
extends RuleBasedScanner {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public DDCLCodeScanner(ColorManager manager) {
        Token string = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.STRING)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.KEYWORD), manager.getColor(IColorConstants.BACKGROUND), 1));
        Token operator = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.OPERATOR)));
        Token other = new Token((Object)new TextAttribute(manager.getColor(IColorConstants.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        this.setDefaultReturnToken((IToken)other);
        rules.add(new MultiLineRule("\"", "\"", (IToken)string, '\u0000', true));
        rules.add(new SingleLineRule("@", "\n", (IToken)string, '\\'));
        rules.add(new SingleLineRule("@", "\r", (IToken)string, '\\'));
        rules.add(new SingleLineRule("**", "\n", (IToken)string, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new SingleLineRule("`", "`", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        CaseInsensitiveWordRule opRule = new CaseInsensitiveWordRule(new OperatorDetector(), Token.UNDEFINED);
        int i = 0;
        int n = DDCLSyntax.OPERATORS.length;
        while (i < n) {
            opRule.addWord(DDCLSyntax.OPERATORS[i], (IToken)operator);
            ++i;
        }
        rules.add(opRule);
        CaseInsensitiveWordRule wordRule = new CaseInsensitiveWordRule(new WordDetector(), (IToken)other);
        int i2 = 0;
        int n2 = DDCLSyntax.KEYWORDS.length;
        while (i2 < n2) {
            wordRule.addWord(DDCLSyntax.KEYWORDS[i2], (IToken)keyword);
            ++i2;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

