/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.cobol;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.internal.analysis.config.inputs.EZCobolSrcSelectionType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.PathMapping;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.editors.EZEditor;
import com.ez.mainframe.editors.cobol.CobolConfiguration;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZCobolSrcSelectionSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobolEditor
extends EZEditor {
    private static final Logger L = LoggerFactory.getLogger(CobolEditor.class);
    public static String COBOL_EDITOR_ID = "editor.id.cobol";
    private final String COBOL_SOURCE_ANALYSIS_ACTION = "Cobol Source Analysis Action";

    public CobolEditor() {
        this.setSourceViewerConfiguration(new CobolConfiguration(this.colorManager));
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (!this.isExpandedSource) {
            if (this.getAction("Cobol Source Analysis Action") == null) {
                this.setAction("Cobol Source Analysis Action", this.getCobolSrcAnalyzeAction());
            }
            this.addAction(menu, "additions", "Cobol Source Analysis Action");
        } else {
            L.trace("it's an expanded file, should not have any action on it");
        }
        this.addViewExpandedSourceAction(menu);
    }

    private IAction getCobolSrcAnalyzeAction() {
        EZWorkspace wk = EZWorkspace.getInstance();
        EZCobolSrcSelectionType objType = new EZCobolSrcSelectionType();
        List listAnalysisTypes = wk.getSpecificAnalysisType((EZObjectType)objType);
        CobolSrcAnalyzeAction analyzeAction = null;
        if (listAnalysisTypes != null && !listAnalysisTypes.isEmpty()) {
            EZAnalysisType analysisType = (EZAnalysisType)listAnalysisTypes.get(0);
            analyzeAction = new CobolSrcAnalyzeAction(analysisType, (EZObjectType)objType);
        }
        return analyzeAction;
    }

    private void completeObjectTypeEntity(EZObjectType objectType) {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int startLine = selection.getStartLine() + 1;
        int endLine = selection.getEndLine() + 1;
        String sourceFilePath = this.sourcePath;
        if (!sourceFilePath.startsWith("//") && sourceFilePath.length() > 3 && sourceFilePath.indexOf(":") == 2) {
            sourceFilePath = sourceFilePath.substring(1);
        }
        if (File.separator.equals("\\")) {
            sourceFilePath = sourceFilePath.replaceAll("/", "\\\\");
        }
        sourceFilePath = PathMapping.convertFromMapped((String)sourceFilePath);
        EZEntityID entityId = new EZEntityID();
        objectType.setEntID(entityId);
        EZCobolSrcSelectionSg cobolSrcSelectionSg = new EZCobolSrcSelectionSg(sourceFilePath, Integer.valueOf(startLine), Integer.valueOf(endLine), selection.getText());
        entityId.addSegment((EZSegment)cobolSrcSelectionSg);
        if (this.project != null) {
            IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
            List projects = service.getProjects();
            for (ProjectInfo pInfo : projects) {
                if (pInfo.isEclipse() || !this.project.equals(pInfo.getName())) continue;
                EZSourceProjectIDSg ezsourcePrjSg = new EZSourceProjectIDSg(pInfo);
                entityId.addSegment((EZSegment)ezsourcePrjSg);
                break;
            }
        }
    }

    @Override
    protected String getEditorId() {
        return COBOL_EDITOR_ID;
    }

    private class CobolSrcAnalyzeAction
    extends Action {
        private EZAnalysisType analysisType;
        private EZObjectType objectType;
        private Job job;

        public CobolSrcAnalyzeAction(EZAnalysisType analysisType, EZObjectType objType) {
            super(analysisType.getName());
            this.analysisType = null;
            this.objectType = null;
            this.job = null;
            this.analysisType = analysisType;
            this.objectType = objType;
            this.setImageDescriptor(analysisType.getIconDescriptor());
            this.job = new Job("analyze action job"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(CobolSrcAnalyzeAction.this.getText(), -1);
                    CobolSrcAnalyzeAction.this.execute();
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            this.job.setUser(true);
        }

        private void execute() {
            EZAnalysis analysis = this.analysisType.getImplementorInstance();
            ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
            inputs.add(this.objectType);
            analysis.addContextValue("input_list", inputs);
            analysis.execute();
        }

        public boolean isEnabled() {
            ISelection selection = CobolEditor.this.getSelectionProvider().getSelection();
            boolean enabled = selection != null && !selection.isEmpty() && selection instanceof ITextSelection;
            return enabled;
        }

        public void run() {
            if (CobolEditor.this.sourcePath != null) {
                CobolEditor.this.completeObjectTypeEntity(this.objectType);
                this.job.setName(this.getText());
                this.job.schedule();
            }
        }
    }
}

