/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.assembler;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

class StatementRule
implements IRule {
    protected IWordDetector detector;
    protected IToken defaultToken;
    protected StringBuilder buffer = new StringBuilder();

    public StatementRule(IWordDetector detector, IToken defaultToken) {
        this.detector = detector;
        this.defaultToken = defaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        int col = scanner.getColumn();
        if (c != -1 && (this.detector.isWordPart((char)c) || (char)c == '@') && this.isValid(scanner, col)) {
            this.buffer.setLength(0);
            do {
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.detector.isWordPart((char)c));
            scanner.unread();
            this.buffer.toString();
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected boolean isValid(ICharacterScanner scanner, int col) {
        boolean has = true;
        while (scanner.getColumn() > 0) {
            scanner.unread();
        }
        int c = scanner.read();
        if (!Character.isSpaceChar(c)) {
            do {
                c = scanner.read();
            } while (scanner.getColumn() < col && c != -1 && (this.detector.isWordPart((char)c) || (char)c == '@'));
            if (scanner.getColumn() == col) {
                has = false;
            }
        }
        do {
            if (!Character.isSpaceChar(c)) {
                has = false;
                break;
            }
            c = scanner.read();
        } while (scanner.getColumn() < col);
        while (scanner.getColumn() < col) {
            scanner.read();
        }
        return has;
    }
}

