/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors.assembler;

import com.ez.mainframe.editors.assembler.StatementRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

class EndOfStatementCommentRule
extends StatementRule {
    public EndOfStatementCommentRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        int col = scanner.getColumn();
        if (c != -1 && this.detector.isWordStart((char)c) && this.isValid(scanner, col)) {
            this.buffer.setLength(0);
            do {
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && scanner.getColumn() != 1);
            scanner.unread();
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    @Override
    protected boolean isValid(ICharacterScanner scanner, int col) {
        boolean has = true;
        while (scanner.getColumn() > 0) {
            scanner.unread();
        }
        int c = scanner.read();
        if (!Character.isSpaceChar((char)c)) {
            do {
                c = scanner.read();
            } while (scanner.getColumn() < col && c != -1 && this.detector.isWordPart((char)c));
            if (scanner.getColumn() == col) {
                has = false;
            }
        }
        if (has) {
            while (scanner.getColumn() < col && Character.isSpaceChar((char)c)) {
                c = scanner.read();
            }
        }
        if (has) {
            while (scanner.getColumn() < col && c != -1 && !Character.isSpaceChar((char)c)) {
                c = scanner.read();
            }
            if (scanner.getColumn() == col) {
                has = false;
            }
        }
        if (has) {
            while (scanner.getColumn() < col && Character.isSpaceChar((char)c)) {
                c = scanner.read();
            }
        }
        if (has) {
            while (scanner.getColumn() < col && c != -1 && !Character.isSpaceChar((char)c)) {
                c = scanner.read();
            }
            if (scanner.getColumn() == col) {
                has = false;
            }
        }
        if (has) {
            while (scanner.getColumn() < col && Character.isSpaceChar((char)c)) {
                c = scanner.read();
            }
            if (scanner.getColumn() != col) {
                has = false;
            }
        }
        while (scanner.getColumn() < col) {
            scanner.read();
        }
        return has;
    }
}

