/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.editors.ContentEditorInput;
import com.ez.mainframe.editors.IEditorMetadata;
import com.ez.mainframe.editors.internal.Activator;
import com.ez.mainframe.editors.internal.Messages;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewExpandedSrcAction
extends Action {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ViewExpandedSrcAction.class);
    private String resourcePath;
    private String editorId;
    private String projectName;
    private String fileName;

    public ViewExpandedSrcAction(String resourcePath, String editorId) {
        this(editorId);
        this.resourcePath = resourcePath;
    }

    private ViewExpandedSrcAction(String editorId) {
        super(Messages.getString(ViewExpandedSrcAction.class, "action.title"));
        this.editorId = editorId;
    }

    public void run() {
        new OpenEditorJob(Messages.getString(ViewExpandedSrcAction.class, "viewExpanded.jobname")).schedule();
    }

    public void setInfo(String ... info) {
        Assert.isTrue((info != null && info.length == 2 ? 1 : 0) != 0);
        this.projectName = info[0];
        this.fileName = info[1];
    }

    private class OpenEditorJob
    extends Job {
        public OpenEditorJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ContentEditorInput fileStoreEditorInput;
            block6: {
                L.debug("trying to open file from path: {}  with editorId={}", (Object)ViewExpandedSrcAction.this.resourcePath, (Object)ViewExpandedSrcAction.this.editorId);
                fileStoreEditorInput = null;
                HttpResponseConsumer consumer = null;
                if (ViewExpandedSrcAction.this.resourcePath != null) {
                    try {
                        consumer = FileAuthUtils.getFileContent((String)ViewExpandedSrcAction.this.resourcePath);
                        if (consumer != null && consumer.getContent() != null) {
                            fileStoreEditorInput = new ContentEditorInput(consumer.getContent(), true);
                            String[] info = new String[]{ViewExpandedSrcAction.this.projectName, ViewExpandedSrcAction.this.resourcePath, ViewExpandedSrcAction.this.fileName, ViewExpandedSrcAction.this.resourcePath};
                            ((IEditorMetadata)fileStoreEditorInput).setInfo(info);
                            break block6;
                        }
                        L.warn("consumer is null or without content; cannot show expanded source!");
                    }
                    catch (Exception e) {
                        L.error("error downloading file: {}", (Object)ViewExpandedSrcAction.this.resourcePath, (Object)e);
                        String msg = Messages.getString(ViewExpandedSrcAction.class, "openFile.error.message", new String[]{ViewExpandedSrcAction.this.resourcePath});
                        LogUtil.displayErrorMessage((Throwable)e, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
                    }
                } else {
                    L.warn("no filePath; cannot show expanded source!");
                }
            }
            if (fileStoreEditorInput == null || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ContentEditorInput edInpt = fileStoreEditorInput;
            Display.getDefault().asyncExec(new Runnable((IEditorInput)edInpt){
                private final /* synthetic */ IEditorInput val$edInpt;
                {
                    this.val$edInpt = iEditorInput;
                }

                @Override
                public void run() {
                    try {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
                        IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)this.val$edInpt, (String)ViewExpandedSrcAction.this.editorId);
                    }
                    catch (PartInitException e) {
                        L.error("exception at open editor", (Throwable)e);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

