/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PositionalRule
implements IRule {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static final int UNDEFINED = -1;
    protected IToken fToken;
    protected int fStartPos = -1;
    protected int fEndPos = -1;

    public PositionalRule(IToken token, int startPos, int endPos) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
        this.fStartPos = startPos;
        this.fEndPos = endPos;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int column;
        scanner.read();
        int startColumn = column = scanner.getColumn();
        while (!(this.fStartPos != -1 && this.fStartPos >= column || this.fEndPos != -1 && this.fEndPos < column)) {
            scanner.read();
            column = scanner.getColumn();
        }
        scanner.unread();
        if (startColumn != column) {
            return this.fToken;
        }
        return Token.UNDEFINED;
    }
}

