/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.mainframe.editors.EZEditor;
import com.ez.mainframe.editors.IEZSourceViewer;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.ui.IEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZEditorUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZEditorUtil.class);
    public static final String CONTEXT_PROJECTS = "context_project";
    public static final String CONTEXT_PATH = "context file path";

    public static void jumpTo(IEditorPart part, int[] bounds) {
        if (bounds != null && bounds.length > 0) {
            if (part instanceof EZEditor) {
                EZEditor.CustomScrollLinesAction scrollAction = (EZEditor.CustomScrollLinesAction)((EZEditor)part).getAction("CUSTOM_SCROLL_LINE_UP");
                scrollAction.setJumpTo(bounds);
                scrollAction.run();
            } else if (part instanceof IEZSourceViewer) {
                ((IEZSourceViewer)part).jumpTo(bounds);
            }
        }
    }

    public static File createTempFile(File file) throws Exception {
        try {
            HttpResponseConsumer consumer = FileAuthUtils.getFileContent((String)file.getPath());
            String content = consumer.getContent();
            Path tempPath = Files.createTempFile(file.getName(), ".tmp", new FileAttribute[0]);
            Files.write(tempPath, content.getBytes(), StandardOpenOption.WRITE);
            return tempPath.toFile();
        }
        catch (Exception e) {
            L.error(String.format("Cannot create a .tmp file associated with %s. Please check the error %s", file.getName(), e.getMessage()));
            throw e;
        }
    }
}

