/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.mainframe.editors.EZEditor;
import com.ez.mainframe.editors.IEditorMetadata;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class EZEditorInput
extends FileStoreEditorInput
implements IEditorMetadata {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String projectName;
    private boolean isExpandedSource = false;
    private boolean hasExpandedFile = false;

    public EZEditorInput(IFileStore fileStore) {
        this(fileStore, false);
    }

    public EZEditorInput(IFileStore fileStore, boolean isExpandedSource) {
        super(fileStore);
        this.isExpandedSource = isExpandedSource;
    }

    public String getName() {
        String name = super.getName();
        String sourcePath = this.getPath();
        if (this.isExpandedSource && sourcePath != null) {
            name = EZEditor.getExpandedSourceName(name, sourcePath);
        }
        return name;
    }

    @Override
    public String getFileName() {
        return this.getName();
    }

    @Override
    public String getPath() {
        return this.getURI().getPath();
    }

    @Override
    public String getProject() {
        return this.projectName;
    }

    @Override
    public boolean isExpandedSource() {
        return this.isExpandedSource;
    }

    @Override
    public void setInfo(String ... info) {
        this.projectName = info[0];
    }

    @Override
    public void hasExpanded(boolean hasExpandedSrc) {
        this.hasExpandedFile = hasExpandedSrc;
    }

    @Override
    public boolean hasExpandedFile() {
        return this.hasExpandedFile;
    }
}

