/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.mainframe.editors.ColorManager;
import com.ez.mainframe.editors.EZEncodingSupport;
import com.ez.mainframe.editors.IEditorMetadata;
import com.ez.mainframe.editors.ViewExpandedSrcAction;
import com.ez.mainframe.editors.internal.Messages;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZEditor
extends TextEditor {
    private static final Logger L = LoggerFactory.getLogger(EZEditor.class);
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String ECLIPSE_DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String RDZ_DEFAULT_TEXT_EDITOR_ID = "com.ibm.ftt.lpex.systemz.SystemzLpex";
    public static final String EDITOR_ID = "ezeditor.id";
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    public static final String EXPANDED_SOURCE_FOLDER = System.getProperty("expandedSrc.dir") != null && !System.getProperty("expandedSrc.dir").isEmpty() ? System.getProperty("expandedSrc.dir") : ".expanded";
    private static final String VIEW_EXPANDED_SOURCE_ACTION = "View Expanded source action";
    protected ColorManager colorManager;
    protected String sourcePath;
    protected String project;
    protected boolean isExpandedSource = false;
    protected String fileName = null;
    private boolean hasExpandedFile = false;

    public EZEditor() {
        this.installEncodingSupport();
        this.colorManager = new ColorManager();
    }

    protected void installEncodingSupport() {
        if (this.fEncodingSupport != null) {
            return;
        }
        this.fEncodingSupport = new EZEncodingSupport();
        this.fEncodingSupport.initialize((StatusTextEditor)this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.fEncodingSupport.setEncoding("UTF-8");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        CustomScrollLinesAction action = new CustomScrollLinesAction();
        action.setActionDefinitionId("CUSTOM_SCROLL_LINE_UP");
        this.setAction("CUSTOM_SCROLL_LINE_UP", (IAction)action);
        IEditorInput edInput = this.getEditorInput();
        if (edInput instanceof IEditorMetadata) {
            IEditorMetadata meta = (IEditorMetadata)edInput;
            this.sourcePath = meta.getPath();
            this.project = meta.getProject();
            this.isExpandedSource = meta.isExpandedSource();
            this.hasExpandedFile = meta.hasExpandedFile();
        } else if (edInput instanceof FileStoreEditorInput) {
            this.sourcePath = ((FileStoreEditorInput)edInput).getURI().getPath();
            String name = EZEditor.getExpandedSourceName(edInput.getName(), this.sourcePath);
            if (!name.equals(edInput.getName())) {
                this.isExpandedSource = true;
            }
            this.setPartName(name);
        }
        this.fileName = FilenameUtils.getName((String)this.sourcePath);
        L.trace("open file {} in editor {}", (Object)this.fileName, (Object)this.getEditorId());
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected void addViewExpandedSourceAction(IMenuManager menu) {
        if (this.sourcePath == null || this.isExpandedSource) {
            return;
        }
        String resPath = this.getExpandedFilePath();
        if (resPath != null) {
            IEditorInput edInput;
            ViewExpandedSrcAction action = (ViewExpandedSrcAction)this.getAction(VIEW_EXPANDED_SOURCE_ACTION);
            if (action == null) {
                action = new ViewExpandedSrcAction(resPath, this.getEditorId());
                action.setInfo(this.project, this.fileName);
                this.setAction(VIEW_EXPANDED_SOURCE_ACTION, (IAction)action);
            }
            if ((edInput = this.getEditorInput()) instanceof IEditorMetadata) {
                this.hasExpandedFile = ((IEditorMetadata)edInput).hasExpandedFile();
            }
            action.setEnabled(this.hasExpandedFile);
            this.addAction(menu, "additions", VIEW_EXPANDED_SOURCE_ACTION);
        }
    }

    private String getExpandedFilePath() {
        String ret = null;
        L.trace("sourcePath={}", (Object)this.sourcePath);
        L.trace("fileName={}", (Object)this.fileName);
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)this.sourcePath);
        IPath file = new Path(parentPath).append(EXPANDED_SOURCE_FOLDER).append(File.separator).append(this.fileName);
        ret = file.toOSString();
        L.debug("expanded path={}", (Object)ret);
        return ret;
    }

    protected void setPartName(String partName) {
        super.setPartName(partName);
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    public static String getExpandedSourceName(String name, String sourcePath) {
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)sourcePath);
        String parentName = FilenameUtils.getName((String)parentPath);
        if (EXPANDED_SOURCE_FOLDER.equalsIgnoreCase(parentName)) {
            name = Messages.getString(EZEditor.class, "expanded.source.in.editor.title", new String[]{name});
        }
        return name;
    }

    public Object getAdapter(Class adapter) {
        if (IGotoMarker.class.equals((Object)adapter)) {
            return this.fGotoMarkerAdapter;
        }
        return super.getAdapter(adapter);
    }

    public class CustomScrollLinesAction
    extends Action {
        public static final String ACTION_ID = "CUSTOM_SCROLL_LINE_UP";
        private int lineToJump;
        private int[] bounds;

        public void setLineToJump(int lineToJump) {
            this.lineToJump = lineToJump;
        }

        public void setJumpTo(int[] bounds) {
            this.bounds = bounds;
            this.lineToJump = bounds[0];
        }

        public void run() {
            if (this.lineToJump < 1) {
                return;
            }
            ISourceViewer fSourceViewer = EZEditor.this.getSourceViewer();
            try {
                ITextViewerExtension5 extension = null;
                int rOffset = 0;
                int rLength = 0;
                if (fSourceViewer instanceof ITextViewerExtension5) {
                    extension = (ITextViewerExtension5)fSourceViewer;
                    rLength = extension.getModelCoverage().getLength();
                } else {
                    rOffset = fSourceViewer.getTopIndexStartOffset();
                    rLength = fSourceViewer.getBottomIndexEndOffset() - rOffset;
                }
                int start = fSourceViewer.getDocument().getLineOffset(this.lineToJump - 1);
                int length = fSourceViewer.getDocument().getLineLength(this.lineToJump - 1);
                if (this.bounds != null && this.bounds.length > 1) {
                    int startColumn = this.bounds[1];
                    start = start + startColumn - 1;
                    length -= startColumn - 1;
                    if (this.bounds.length > 2) {
                        int startLine = this.bounds[0] - 1;
                        int endLine = this.bounds[2] - 1;
                        if (endLine > 0 && endLine != startLine && this.bounds.length > 3) {
                            int endColumn = this.bounds[3];
                            length = fSourceViewer.getDocument().getLineOffset(endLine) - start;
                            length += endColumn;
                        }
                    }
                }
                int diff = start - rLength / 2;
                int topOffset = 0;
                if (diff >= 0) {
                    topOffset = diff;
                }
                int topLine = this.lineToJump - 1;
                int lOff = topOffset;
                while (topLine > 0 && lOff >= topOffset) {
                    lOff = fSourceViewer.getDocument().getLineOffset(--topLine);
                }
                if (diff >= 0) {
                    ++topLine;
                }
                fSourceViewer.setTopIndex(topLine);
                EZEditor.this.selectAndReveal(start, length);
            }
            catch (BadLocationException e) {
                L.error("error at selecting line", (Throwable)e);
            }
        }
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        private GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker marker) {
            int candidateLineNumber = marker.getAttribute("lineNumber", 1);
            Action scrollAction = (Action)EZEditor.this.getAction("CUSTOM_SCROLL_LINE_UP");
            ((CustomScrollLinesAction)scrollAction).setJumpTo(new int[]{candidateLineNumber});
            scrollAction.run();
        }
    }
}

