/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.mainframe.editors.ContentEditorInput;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ContentEditorInputFactory
implements IElementFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String FILE_NAME = "FILE_NAME";
    private static final String FILE_PATH = "FILE_PATH";
    private static final String INPUT_CONTENT = "INPUT_CONTENT";
    private static final String PROJECT_NAME = "PROJECT_NAME";
    private static final String TOOLTIP = "TOOLTIP_TEXT";
    private static final String IS_EXPANDED_FILE = "isExpanded";
    private static final String HAS_EXPANDED_FILE = "hasExpanded";
    static final String ID = "com.ez.mainframe.editors.ContentEditorInputFactory";

    static void saveState(IMemento memento, ContentEditorInput input) {
        String content = input.getInputString();
        memento.putString(INPUT_CONTENT, content);
        memento.putString(PROJECT_NAME, input.getProject());
        memento.putString(FILE_PATH, input.getPath());
        memento.putString(FILE_NAME, input.getFileName());
        memento.putString(TOOLTIP, input.getToolTipText());
        memento.putBoolean(HAS_EXPANDED_FILE, input.hasExpandedFile());
        memento.putBoolean(IS_EXPANDED_FILE, input.isExpandedSource());
    }

    public IAdaptable createElement(IMemento memento) {
        String contentString = memento.getString(INPUT_CONTENT);
        if (contentString == null) {
            return null;
        }
        ContentEditorInput cei = new ContentEditorInput(contentString);
        cei.setInfo(memento.getString(PROJECT_NAME), memento.getString(FILE_PATH), memento.getString(FILE_NAME), memento.getString(TOOLTIP), memento.getBoolean(HAS_EXPANDED_FILE).toString(), memento.getBoolean(IS_EXPANDED_FILE).toString());
        return cei;
    }
}

