/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.editors;

import com.ez.mainframe.editors.ContentEditorInputFactory;
import com.ez.mainframe.editors.EZEditor;
import com.ez.mainframe.editors.IEditorMetadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEditorInput
implements IStorageEditorInput,
IEditorMetadata,
IPersistableElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ContentEditorInput.class);
    private String inputString;
    private String projectName;
    private String fileName;
    private String filePath;
    private String tooltip;
    private boolean isExpanded = false;
    private boolean hasExpandedFile = false;

    public ContentEditorInput(String inputString) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(inputString);
        this.inputString = StandardCharsets.UTF_8.decode(buffer).toString();
    }

    public ContentEditorInput(String input, boolean isExpanded) {
        this(input);
        this.isExpanded = isExpanded;
    }

    public String getInputString() {
        return this.inputString;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        String name = "";
        name = this.isExpanded ? EZEditor.getExpandedSourceName(this.fileName, this.filePath) : this.getFileName();
        return name;
    }

    public String getToolTipText() {
        String tooltipText = this.tooltip != null ? this.tooltip : this.getPath();
        return tooltipText;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ContentEditorInput) {
            ContentEditorInput input = (ContentEditorInput)o;
            boolean ret = false;
            ret = this.getPath() == null ? input.getPath() == null : this.getPath().equalsIgnoreCase(input.getPath()) && this.tooltip.equalsIgnoreCase(input.tooltip);
            return ret;
        }
        return false;
    }

    public IStorage getStorage() throws CoreException {
        return new IStorage(){

            public InputStream getContents() throws CoreException {
                try {
                    return new ByteArrayInputStream(ContentEditorInput.this.inputString.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException();
                }
            }

            public IPath getFullPath() {
                return null;
            }

            public String getName() {
                return ContentEditorInput.this.getName();
            }

            public boolean isReadOnly() {
                return false;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    @Override
    public String getProject() {
        return this.projectName;
    }

    @Override
    public void setInfo(String ... info) {
        Assert.isTrue((info != null && info.length >= 4 ? 1 : 0) != 0);
        this.projectName = info[0];
        this.filePath = info[1];
        this.fileName = info[2];
        this.tooltip = info[3];
        if (info.length > 4) {
            try {
                this.hasExpandedFile = Boolean.valueOf(info[4]);
            }
            catch (Exception e) {
                L.error("error evaluating hasExpandedFile state", (Throwable)e);
            }
        }
        if (info.length > 5) {
            try {
                this.isExpanded = Boolean.valueOf(info[5]);
            }
            catch (Exception e) {
                L.error("error evaluating expanded state", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isExpandedSource() {
        return this.isExpanded;
    }

    public void saveState(IMemento memento) {
        ContentEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "com.ez.mainframe.editors.ContentEditorInputFactory";
    }

    @Override
    public void hasExpanded(boolean hasExpandedSrc) {
        this.hasExpandedFile = hasExpandedSrc;
    }

    @Override
    public boolean hasExpandedFile() {
        return this.hasExpandedFile;
    }
}

