/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.state;

import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkSessionEvent;
import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.state.SessionState;
import com.ez.keeper.client.state.SessionStateListener;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionStateMonitorImpl {
    protected final Logger L = LoggerFactory.getLogger(this.getClass());
    private ZkSessionImpl session;
    private String name;
    private SessionStateListener l;
    private State CONNECTED = new State(SessionState.Connected);
    private State DISCONNECTED = new State(SessionState.Disconnected);
    private State EXPIRED = new State(SessionState.Expired);
    private State CLOSED = new State(SessionState.Closed);
    private State state;
    private ZkEventListener sessionListener;
    private volatile boolean destroyed;

    SessionStateMonitorImpl(ZkSessionImpl session, SessionStateListener l) {
        this.session = session;
        if (this.name == null) {
            this.name = super.toString();
        }
        this.l = l;
    }

    private void moveState(State newState) {
        if (this.state != newState || newState == this.CONNECTED) {
            this.L.info(String.format("State transition: %s=>%s", this.state, newState));
            this.state = newState;
            try {
                this.l.onStateChanged(this.state.getSessionState());
            }
            catch (Exception ex) {
                this.L.error("Unexpected error.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninitialize() {
        SessionStateMonitorImpl sessionStateMonitorImpl = this;
        synchronized (sessionStateMonitorImpl) {
            if (!this.destroyed) {
                this.session.removeListener(this.sessionListener);
                this.destroyed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        this.sessionListener = new ZkEventListenerAdapter(){

            @Override
            public void notifySessionEvent(ZkSessionEvent e) {
                Watcher.Event.KeeperState s = e.getState();
                if (s == Watcher.Event.KeeperState.SyncConnected || s == Watcher.Event.KeeperState.ConnectedReadOnly) {
                    SessionStateMonitorImpl.this.onConnectionAvailable();
                } else if (s == Watcher.Event.KeeperState.Expired) {
                    SessionStateMonitorImpl.this.onSessionExpired();
                } else {
                    SessionStateMonitorImpl.this.onConnectionUnavailable();
                }
            }
        };
        SessionStateMonitorImpl sessionStateMonitorImpl = this;
        synchronized (sessionStateMonitorImpl) {
            SessionState ss = this.session.registerListenerAndGetState(this.sessionListener);
            switch (ss) {
                case Connected: {
                    this.state = this.CONNECTED;
                    break;
                }
                case Disconnected: {
                    this.state = this.DISCONNECTED;
                    break;
                }
                case Closed: {
                    this.state = this.CLOSED;
                    break;
                }
                case Expired: {
                    this.state = this.EXPIRED;
                    break;
                }
                default: {
                    throw new IllegalStateException(ss.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionUnavailable() {
        SessionStateMonitorImpl sessionStateMonitorImpl = this;
        synchronized (sessionStateMonitorImpl) {
            if (!this.destroyed) {
                this.state.onConnectionUnavailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionAvailable() {
        SessionStateMonitorImpl sessionStateMonitorImpl = this;
        synchronized (sessionStateMonitorImpl) {
            if (!this.destroyed) {
                this.state.onConnectionAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionExpired() {
        SessionStateMonitorImpl sessionStateMonitorImpl = this;
        synchronized (sessionStateMonitorImpl) {
            if (!this.destroyed) {
                this.state.onSessionExpired();
            }
        }
    }

    private class State {
        private SessionState sessionState;

        protected State(SessionState sessionState) {
            this.sessionState = sessionState;
        }

        private void onConnectionUnavailable() {
            if (this != SessionStateMonitorImpl.this.EXPIRED && this != SessionStateMonitorImpl.this.CLOSED) {
                SessionStateMonitorImpl.this.moveState(SessionStateMonitorImpl.this.DISCONNECTED);
            }
        }

        private void onConnectionAvailable() {
            if (this != SessionStateMonitorImpl.this.EXPIRED && this != SessionStateMonitorImpl.this.CLOSED) {
                SessionStateMonitorImpl.this.moveState(SessionStateMonitorImpl.this.CONNECTED);
            }
        }

        private void onSessionExpired() {
            if (this != SessionStateMonitorImpl.this.EXPIRED && this != SessionStateMonitorImpl.this.CLOSED) {
                SessionStateMonitorImpl.this.moveState(SessionStateMonitorImpl.this.EXPIRED);
            }
        }

        public SessionState getSessionState() {
            return this.sessionState;
        }

        public String toString() {
            return this.sessionState.name();
        }
    }
}

