/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.state;

import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.state.SessionStateListener;
import com.ez.keeper.client.state.SessionStateMonitorImpl;
import java.util.HashMap;

public class SessionStateListenerRegistry {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static HashMap<SessionStateListener, SessionStateMonitorImpl> MAP = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ZkSessionImpl session, String name, SessionStateListener l) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (l == null) {
            throw new IllegalArgumentException("l");
        }
        HashMap<SessionStateListener, SessionStateMonitorImpl> hashMap = MAP;
        synchronized (hashMap) {
            if (MAP.containsKey(l)) {
                throw new IllegalArgumentException("Already registered");
            }
            SessionStateMonitorImpl m = new SessionStateMonitorImpl(session, l);
            m.initialize();
            MAP.put(l, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureRegistered(ZkSessionImpl session, String name, SessionStateListener l) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (l == null) {
            throw new IllegalArgumentException("l");
        }
        HashMap<SessionStateListener, SessionStateMonitorImpl> hashMap = MAP;
        synchronized (hashMap) {
            if (!MAP.containsKey(l)) {
                SessionStateMonitorImpl m = new SessionStateMonitorImpl(session, l);
                m.initialize();
                MAP.put(l, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(SessionStateListener l) {
        if (l == null) {
            throw new IllegalArgumentException("l");
        }
        HashMap<SessionStateListener, SessionStateMonitorImpl> hashMap = MAP;
        synchronized (hashMap) {
            SessionStateMonitorImpl m = MAP.remove(l);
            if (m == null) {
                throw new IllegalArgumentException("Not registered");
            }
            m.uninitialize();
        }
    }
}

