/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.session;

import com.ez.keeper.client.StateUtils;
import com.ez.keeper.client.ZkDefaultSessionFactory;
import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEvents;
import com.ez.keeper.client.ZkException;
import com.ez.keeper.client.ZkMonitor;
import com.ez.keeper.client.ZkNetworkException;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkRequestMonitor;
import com.ez.keeper.client.ZkSessionExpiredException;
import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.ZkTreeMonitor;
import com.ez.keeper.client.log4j.Loggers;
import com.ez.keeper.client.log4j.MDCLoggingProxy;
import com.ez.keeper.client.policy.ZkSessionPolicy;
import com.ez.keeper.client.request.ZkAsyncRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.request.ZkTransactionalRequest;
import com.ez.keeper.client.session.RequestExecutor;
import com.ez.keeper.client.state.SessionState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.Configuration;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;

public class ZkDefaultSession
implements ZkSessionImpl {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = Loggers.getLogger(ZkDefaultSession.class);
    public static final String MDC_KEY = "ezkid";
    private MDCContextValue mdcContextProvider;
    private volatile String mdcContextValue;
    private int referenceCount;
    private final String name;
    private ZooKeeper zk;
    private long sessionId;
    private byte[] password;
    private Configuration conf;
    private ExecutorService listenerExecutor;
    private RequestExecutor requestExecutor;
    private Set<ZkEventListener> eventListeners;
    private State state = State.Created;
    private ZkDefaultSessionFactory factory;
    private ZkSessionPolicy policy;

    public ZkDefaultSession(String name, ZkDefaultSessionFactory factory, ZkSessionPolicy policy, Configuration conf) {
        this.conf = conf;
        this.factory = factory;
        this.eventListeners = new HashSet<ZkEventListener>();
        this.name = name;
        this.policy = policy;
        this.referenceCount = 1;
        this.mdcContextProvider = new MDCContextValue();
    }

    public Object getMDCContextValue() {
        return this.mdcContextProvider;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(ZkEventListener eventListener) {
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            this.eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionState registerListenerAndGetState(ZkEventListener eventListener) {
        State state = this.state;
        synchronized (state) {
            ZooKeeper.States zks = this.zk.getState();
            SessionState state2 = zks.isConnected() ? SessionState.Connected : (zks.isAlive() ? SessionState.Disconnected : SessionState.Closed);
            Set<ZkEventListener> set = this.eventListeners;
            synchronized (set) {
                this.eventListeners.add(eventListener);
            }
            return state2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ZkEventListener eventListener) {
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            this.eventListeners.remove(eventListener);
        }
    }

    @Override
    public List<ZkResult> executeList(List<ZkRequest> requestsList, ZkEventListener l) {
        int type = 2;
        for (ZkRequest re : requestsList) {
            if (re instanceof ZkAsyncRequest) continue;
            throw new IllegalArgumentException("Request not instance of " + ZkAsyncRequest.class);
        }
        return this.doExecute(type, requestsList, l);
    }

    @Override
    public List<ZkResult> executeList(List<ZkRequest> requestsList) {
        return this.executeList(requestsList, null);
    }

    @Override
    public ZkResult execute(ZkRequest request) {
        return this.execute(request, null);
    }

    @Override
    public ZkResult execute(ZkRequest request, ZkEventListener listener) {
        int type = 2;
        if (!(request instanceof ZkAsyncRequest)) {
            type = 0;
        }
        List<ZkResult> reList = this.doExecute(type, Collections.singletonList(request), listener);
        return reList.get(0);
    }

    @Override
    public List<ZkResult> execute(List<ZkRequest> requestsList, ZkEventListener l) {
        for (ZkRequest re : requestsList) {
            if (re instanceof ZkTransactionalRequest) continue;
            throw new IllegalArgumentException(re + " not instance of " + ZkTransactionalRequest.class);
        }
        return this.doExecute(1, requestsList, l);
    }

    @Override
    public List<ZkResult> execute(List<ZkRequest> requestsList) {
        for (ZkRequest re : requestsList) {
            if (re instanceof ZkTransactionalRequest) continue;
            throw new IllegalArgumentException(re + " not instance of " + ZkTransactionalRequest.class);
        }
        return this.doExecute(1, requestsList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ZkResult> executeAsync(ZkRequest request, final ZkEventListener listener) {
        Watcher w = null;
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        State state = this.state;
        synchronized (state) {
            int requestType;
            StateUtils.assertTrue((Object)this.state, new Object[]{State.Initialized});
            if (listener != null) {
                w = this.createWatcherProxy(new Watcher(){

                    public void process(WatchedEvent event) {
                        ZkDefaultSession.this.onLocalEvent(event, listener);
                    }
                });
            }
            RequestFuture future = new RequestFuture();
            int n = requestType = request instanceof ZkAsyncRequest ? 2 : 0;
            if (requestType == 0) {
                L.debug(String.format("Request %s in serial mode.", request));
            }
            RequestInfo ri = new RequestInfo(requestType, Collections.singletonList(request), w, future, listener);
            this.requestExecutor.submit(new RequestRunnable(ri));
            if (L.isDebugEnabled() && L.isDebugEnabled()) {
                L.debug("Request submitted: " + request);
            }
            return future;
        }
    }

    @Override
    public ZkMonitor watch(ZkRequest request, ZkEventListener l, String watcherName) {
        return this.watch(request, l, watcherName, 0);
    }

    @Override
    public ZkMonitor watch(ZkRequest request, ZkEventListener l, String watcherName, int flags) {
        ZkRequestMonitor m = new ZkRequestMonitor(this, request, l, watcherName, flags);
        m.start();
        return m;
    }

    @Override
    public ZkMonitor watch(String nodePath, ZkEventListener l, String watcherName) {
        return this.watch(nodePath, l, watcherName, null);
    }

    @Override
    public ZkMonitor watch(String nodePath, ZkEventListener l, String watcherName, Integer maxLevel) {
        ZkTreeMonitor m = new ZkTreeMonitor(this, nodePath, l, watcherName, maxLevel);
        m.start();
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postUserEvent(ZkEvent zkEvent, ZkEventListener l) {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertFalse((Object)this.state, (Object)State.Created);
            this.onUserEvent(zkEvent, new ZkEventListener[]{l});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSessionId() {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertFalse((Object)this.state, (Object)State.Created);
            return this.sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSessionPasswd() {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertFalse((Object)this.state, (Object)State.Created);
            return this.password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int increaseReference() {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertTrue((Object)this.state, (Object)State.Initialized);
            ++this.referenceCount;
            return this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decreaseReference() {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertTrue((Object)this.state, new Object[]{State.Initialized, State.Expired});
            if (this.referenceCount == 0) {
                throw new IllegalStateException("referenceCount == 0");
            }
            --this.referenceCount;
            return this.referenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired() {
        State state = this.state;
        synchronized (state) {
            return this.state == State.Expired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestExecutor(RequestExecutor requestExecutor) {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertTrue((Object)this.state, (Object)State.Created);
            this.requestExecutor = requestExecutor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        State state = this.state;
        synchronized (state) {
            StateUtils.assertTrue((Object)this.state, (Object)State.Created);
            try {
                this.listenerExecutor = Executors.newSingleThreadExecutor();
                this.requestExecutor.start();
                try {
                    this.ensureSession();
                }
                catch (ZkNetworkException ex) {
                    L.info("No connection yet...");
                    if (L.isDebugEnabled()) {
                        L.debug("Connection failed.", (Throwable)ex);
                    }
                }
            }
            finally {
                this.state = State.Initialized;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninitialize() {
        block27: {
            State state;
            try {
                state = this.state;
                synchronized (state) {
                    StateUtils.assertTrue((Object)this.state, new Object[]{State.Expired, State.Initialized});
                    L.info("Uninitializing session...");
                    this.state = State.Closing;
                    if (this.zk == null) {
                        L.info("Zookeeper session already destroyed.");
                    } else {
                        this.destroySession();
                    }
                }
                if (this.requestExecutor != null) {
                    try {
                        this.requestExecutor.stop(null);
                    }
                    catch (Exception ex) {
                        L.error("Unexpected error.", (Throwable)ex);
                    }
                    finally {
                        this.requestExecutor = null;
                    }
                }
                if (this.listenerExecutor == null) break block27;
                try {
                    List<Runnable> queue = this.listenerExecutor.shutdownNow();
                    if (queue != null && !queue.isEmpty()) {
                        L.debug("Undelivered events because executor is shutting down.");
                    }
                }
                catch (Exception ex) {
                    L.error("Unexpected error.", (Throwable)ex);
                }
                finally {
                    this.listenerExecutor = null;
                }
            }
            finally {
                state = this.state;
                synchronized (state) {
                    this.state = State.Finished;
                }
                L.info("Session uninitialized.");
            }
        }
    }

    @Override
    public void release() {
        this.factory.release(this);
    }

    private void ensureSession() {
        if (this.zk == null) {
            boolean isTLSZookeeperEnabled;
            String host = this.conf.getString("zookeeper.host", "localhost");
            int port = this.conf.getInt("zookeeper.port", 2181);
            int timeout = this.conf.getInt("zookeeper.timeout", 30000);
            L.info(String.format("Creating session to %s:%d, timeout: %d...", host, port, timeout));
            boolean bl = isTLSZookeeperEnabled = System.getProperty("zookeeper.client.secure") != null && System.getProperty("zookeeper.client.secure").contentEquals("true");
            if (isTLSZookeeperEnabled) {
                L.info("is tls enabled ", (Object)isTLSZookeeperEnabled);
                L.info("get system property zookeeper.ssl.trustStore.location with value {}", (Object)System.getProperty("zookeeper.ssl.trustStore.location"));
                L.info("get system property zookeeper.ssl.keyStore.location with value {}", (Object)System.getProperty("zookeeper.ssl.keyStore.location"));
                System.setProperty("zookeeper.clientCnxnSocket", ClientCnxnSocketNetty.class.getName());
            }
            try {
                this.zk = new ZooKeeper(host + ":" + port, timeout, this.createWatcherProxy(new Watcher(){

                    public void process(WatchedEvent event) {
                        ZkDefaultSession.this.onGlobalEvent(event);
                    }
                }));
                L.info("Zookeeper client: " + this.zk);
                this.setSessionInfo(this.zk.getSessionId(), this.zk.getSessionPasswd());
                L.info("Session created.");
            }
            catch (Exception e) {
                throw ZkException.create(e, this.sessionId);
            }
        }
    }

    private void setSessionInfo(long sessionId, byte[] password) {
        this.sessionId = sessionId;
        this.password = password;
        this.mdcContextValue = String.format("%s:0x%x", this.name, this.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZkResult> doExecute(int requestType, List<ZkRequest> requestList, final ZkEventListener listener) {
        List<ZkResult> results = null;
        if (requestList == null || requestList.size() == 0) {
            throw new IllegalArgumentException("requestList");
        }
        if (requestType == 0) {
            L.debug(String.format("Request list in serial mode.", new Object[0]));
        }
        try {
            Watcher w = null;
            RequestFuture future = new RequestFuture();
            State state = this.state;
            synchronized (state) {
                StateUtils.assertTrue((Object)this.state, new Object[]{State.Initialized});
                if (listener != null) {
                    w = this.createWatcherProxy(new Watcher(){

                        public void process(WatchedEvent event) {
                            ZkDefaultSession.this.onLocalEvent(event, listener);
                        }
                    });
                }
                RequestInfo ri = new RequestInfo(requestType, requestList, w, future, null);
                this.requestExecutor.submit(new RequestRunnable(ri));
            }
            try {
                results = future.getResults();
            }
            catch (InterruptedException e) {
                L.error("Interrupted.", (Throwable)e);
                throw new ZkException(this.sessionId, "Interrupted while wait for request.");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ZkException) {
                    throw (ZkException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        finally {
            if (L.isTraceEnabled()) {
                L.trace("Request finished : " + requestList);
                L.trace("Request result: " + results);
            }
        }
        return results;
    }

    private void abortRequest(Runnable r) {
        if (r instanceof RequestRunnable) {
            RequestRunnable rr = (RequestRunnable)r;
            RequestInfo ri = rr.ri;
            CancellationException ex = new CancellationException();
            ri.future.setFinished(null, ex);
            for (ZkRequest re : ri.re) {
                this.onRequestFinished(ZkEvents.createRequestEvent(re, ex), ri);
            }
        }
    }

    private boolean handleException(ZkException ez, RequestInfo ri) {
        boolean recover = false;
        if (ez instanceof ZkSessionExpiredException) {
            L.info("Session expired.");
            this.destroySession();
            if (this.policy.reconnectOnSessionExpired()) {
                this.state = State.Initialized;
                recover = true;
            } else {
                this.state = State.Expired;
            }
        } else if (ez instanceof ZkNetworkException) {
            boolean bl = recover = this.policy.reconnectOnNetworkError() && this.mayRetry(ri);
        }
        if (recover && L.isTraceEnabled()) {
            L.trace("Trying again: " + ri);
        }
        return recover;
    }

    private boolean mayRetry(RequestInfo ri) {
        boolean mayRetry = false;
        int retryMax = this.conf.getInt("zookeeper.retry_count", 1);
        if (ri.count.get() > retryMax) {
            if (L.isDebugEnabled()) {
                L.debug(String.format("Too many attempts (%d), request will be aborted: %s", ri.count.get(), ri));
            }
        } else {
            mayRetry = true;
        }
        return mayRetry;
    }

    private void destroySession() {
        try {
            try {
                L.info("Session will close.");
                this.zk.close();
                L.info("Session closed.");
            }
            catch (InterruptedException ex) {
                L.debug("Interrupted.", (Throwable)ex);
            }
            catch (Exception ex) {
                L.error("Can't close.", (Throwable)ex);
            }
        }
        finally {
            this.zk = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGlobalEvent(WatchedEvent e) {
        if (L.isTraceEnabled()) {
            L.trace("Event received: " + e);
        }
        State state = this.state;
        synchronized (state) {
            if (this.state != State.Finished) {
                this.onEvent("global", e, this.getAllEventListenersCopy());
            } else {
                L.warn(String.format("Session state %s, event %s discarded.", new Object[]{this.state, e.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLocalEvent(WatchedEvent e, ZkEventListener l) {
        if (L.isTraceEnabled()) {
            L.trace("Event received: " + e);
        }
        State state = this.state;
        synchronized (state) {
            if (l != null) {
                if (this.state != State.Finished) {
                    this.onEvent("local", e, new ZkEventListener[]{l});
                } else {
                    L.warn(String.format("Session state %s, event %s discarded.", new Object[]{this.state, e.toString()}));
                }
            } else {
                L.trace("No listener for the command, delivering upstairs...");
                if (!ZkEvents.isConnectionEvent(e)) {
                    if (this.state != State.Finished) {
                        this.onEvent("local", e, this.getAllEventListenersCopy());
                    } else {
                        L.warn(String.format("Session state %s, event %s discarded.", new Object[]{this.state, e.toString()}));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestFinished(final ZkRequestEvent e, final RequestInfo ri) {
        if (ri.rl != null) {
            State state = this.state;
            synchronized (state) {
                if (this.state != State.Finished) {
                    this.listenerExecutor.execute(new SessionRunnable(this.sessionId){

                        @Override
                        public void run() {
                            try {
                                ri.rl.notifyEvent(e);
                            }
                            catch (Exception e2) {
                                L.error("Uncaught exception while delivering event.", (Throwable)e2);
                            }
                        }
                    });
                } else {
                    L.warn(String.format("State %s, data event will not be delivered.", new Object[]{this.state}));
                }
            }
        }
    }

    private void onEvent(String prefix, WatchedEvent e, ZkEventListener[] targets) {
        if (ZkEvents.isConnectionEvent(e)) {
            this.handleConnectionEvent(prefix, e);
        }
        if (L.isTraceEnabled()) {
            L.trace("Delivering event: " + e);
        }
        this.postEvent(ZkEvents.createFromWatchedEvent(e), targets);
    }

    private void onUserEvent(ZkEvent zkEvent, ZkEventListener[] targets) {
        if (L.isTraceEnabled()) {
            L.trace("User event received" + zkEvent);
        }
        this.postEvent(zkEvent, targets);
    }

    private void postEvent(final ZkEvent zkEvent, ZkEventListener[] targets) {
        if (targets != null && targets.length > 0) {
            for (final ZkEventListener t : targets) {
                SessionRunnable sr = new SessionRunnable(this.sessionId){

                    @Override
                    public void run() {
                        try {
                            t.notifyEvent(zkEvent);
                        }
                        catch (Exception e) {
                            L.error("Uncaught exception while delivering event.", (Throwable)e);
                        }
                    }
                };
                Runnable ar = MDCLoggingProxy.createProxy(sr, Runnable.class, MDC_KEY, this.mdcContextProvider);
                this.listenerExecutor.execute(ar);
            }
        } else if (L.isTraceEnabled()) {
            L.trace("No target to deliver.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkEventListener[] getAllEventListenersCopy() {
        ZkEventListener[] factoryListeners = this.factory != null ? this.factory.getEventListenersCopy() : null;
        Set<ZkEventListener> set = this.eventListeners;
        synchronized (set) {
            ZkEventListener[] allListeners;
            if (factoryListeners != null) {
                allListeners = this.eventListeners.toArray(new ZkEventListener[this.eventListeners.size() + factoryListeners.length]);
                System.arraycopy(factoryListeners, 0, allListeners, this.eventListeners.size(), factoryListeners.length);
            } else {
                allListeners = (ZkEventListener[])this.eventListeners.toArray((T[])null);
            }
            return allListeners;
        }
    }

    private void handleConnectionEvent(String prefix, WatchedEvent e) {
        switch (e.getState()) {
            case Disconnected: {
                L.info(String.format("%s event: session 0x%x disconnected.", prefix, this.sessionId));
                break;
            }
            case SyncConnected: 
            case ConnectedReadOnly: {
                this.setSessionInfo(this.zk.getSessionId(), this.zk.getSessionPasswd());
                L.info(String.format("%s event: session 0x%x connected.", prefix, this.sessionId));
                L.info("Zookeeper client: " + this.zk);
                break;
            }
            case Expired: {
                L.info(String.format("%s event: session 0x%x expired.", prefix, this.sessionId));
                break;
            }
            default: {
                L.info(String.format("%s event: connection event: ", prefix, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRequest(RequestInfo ri) {
        block23: {
            try {
                ZooKeeper zkRef;
                Object object = this.state;
                synchronized (object) {
                    if (this.state == State.Expired) {
                        throw new ZkSessionExpiredException(this.sessionId, "Session already expired.");
                    }
                    StateUtils.assertTrue((Object)this.state, (Object)State.Initialized);
                    this.ensureSession();
                    zkRef = this.zk;
                }
                if (ri.type == 0 || ri.type == 1) {
                    this.doRunRequest(ri, zkRef);
                    break block23;
                }
                if (ri.type == 2) {
                    this.doRunAsyncRequest(ri, zkRef);
                    break block23;
                }
                throw new RuntimeException("Unknown type: " + ri.type);
            }
            catch (Exception ex) {
                ZkException zkEx = ZkException.create(ex, this.sessionId);
                L.trace("Request failed.", (Throwable)ex);
                RequestInfo requestInfo = ri;
                synchronized (requestInfo) {
                    this.handleRequestFinishedWithError(ri, null, zkEx);
                }
            }
            finally {
                RequestInfo requestInfo = ri;
                synchronized (requestInfo) {
                    ri.count.incrementAndGet();
                }
            }
        }
    }

    private void doRunRequest(RequestInfo ri, ZooKeeper zkRef) throws Exception {
        List<ZkResult> rl = null;
        L.trace("Run request: " + ri);
        if (ri.type == 0) {
            ZkRequest re = ri.re.get(0);
            ZkResult rere = re.execute(zkRef, ri.w);
            rl = Collections.singletonList(rere);
        } else if (ri.type == 1) {
            LinkedList<Op> ops = new LinkedList<Op>();
            int expectedResults = 0;
            L.debug("Create transaction.");
            for (ZkRequest re : ri.re) {
                ZkTransactionalRequest tre = (ZkTransactionalRequest)((Object)re);
                List<Op> requestOps = tre.enroll(zkRef);
                expectedResults += requestOps.size();
                ri.expectedResults.put(re, requestOps.size());
                ops.addAll(requestOps);
            }
            L.debug("Commiting transaction.");
            ArrayList opRel = new ArrayList(zkRef.multi(ops));
            L.debug("Transaction commited.");
            if (opRel.size() != expectedResults) {
                throw new RuntimeException("Unexpected result list size.");
            }
            rl = new ArrayList<ZkResult>();
            int j = 0;
            for (int i = 0; i < ri.re.size(); ++i) {
                ZkRequest re = ri.re.get(i);
                ZkTransactionalRequest tre = (ZkTransactionalRequest)((Object)re);
                Integer requestExpectedResults = ri.expectedResults.get(re);
                int k = j + requestExpectedResults;
                List<OpResult> requestResults = opRel.subList(j, k);
                rl.add(tre.getResult(requestResults));
                j = k;
            }
        } else {
            throw new RuntimeException("Unknown type: " + ri.type);
        }
        if (rl != null) {
            this.handleRquestFinished(ri, rl);
        }
    }

    private void doRunAsyncRequest(RequestInfo ri, ZooKeeper zkRef) throws Exception {
        ArrayList<ZkResult> rl = null;
        L.debug("Run request: " + ri);
        rl = new ArrayList<ZkResult>(ri.re.size());
        for (int i = 0; i < ri.re.size(); ++i) {
            rl.add(null);
        }
        final ArrayList<ZkResult> rl2 = rl;
        final AtomicInteger count = new AtomicInteger();
        final RequestInfo ri2 = ri;
        int i = 0;
        for (ZkRequest re : ri.re) {
            final int j = i;
            final int size = ri.re.size();
            if (re instanceof ZkAsyncRequest) {
                ZkAsyncRequest are = (ZkAsyncRequest)((Object)re);
                ZkAsyncRequest.ZkAsyncCallback cb = new ZkAsyncRequest.ZkAsyncCallback(){

                    @Override
                    public void done(ZkResult r, Object ctx) {
                        rl2.set(j, r);
                        if (r.getThrowable() != null) {
                            L.debug("Request failed: ", r.getThrowable());
                        }
                        if (count.incrementAndGet() == size) {
                            ZkDefaultSession.this.handleAsyncRequestFinished(ri2, rl2);
                        }
                    }
                };
                try {
                    are.execute(zkRef, ri.w, cb, new Object());
                }
                catch (Exception ex) {
                    rl2.set(j, new ZkResult(null, null, ex));
                    L.debug("Request failed: ", (Throwable)ex);
                    if (count.incrementAndGet() == size) {
                        this.handleAsyncRequestFinished(ri2, rl2);
                    }
                }
            } else {
                throw new RuntimeException(String.format("%s not an instance of %s", re, ZkAsyncRequest.class.getCanonicalName()));
            }
            ++i;
        }
    }

    private void handleAsyncRequestFinished(RequestInfo ri, List<ZkResult> rl) {
        Throwable t;
        boolean tryRecoverError = false;
        ZkException ex = null;
        if (ri.re.size() == 1 && (t = rl.get(0).getThrowable()) != null) {
            ex = (ZkException)t;
            tryRecoverError = true;
        }
        if (tryRecoverError) {
            this.handleRequestFinishedWithError(ri, rl, ex);
        } else {
            this.handleRquestFinished(ri, rl);
        }
    }

    private void handleRequestFinishedWithError(RequestInfo ri, List<ZkResult> rl, ZkException zkEx) {
        boolean recover = false;
        L.trace(String.format("Request failed: " + ri, new Object[0]), (Throwable)zkEx);
        if (ri.re.size() == 1 || ri.type == 1) {
            recover = this.handleException(zkEx, ri);
        }
        if (!recover) {
            ri.future.setFinished(rl, zkEx);
            for (ZkRequest re : ri.re) {
                try {
                    this.onRequestFinished(ZkEvents.createRequestEvent(re, zkEx), ri);
                }
                catch (Exception ex2) {
                    L.error("Unexpected error.", (Throwable)ex2);
                }
            }
        } else {
            int delay = this.conf.getInt("zookeeper.retry_delay", 500);
            if (L.isTraceEnabled()) {
                L.trace("Request failed, submit again: " + ri);
            }
            this.requestExecutor.putback(new RequestRunnable(ri, delay));
        }
    }

    private void handleRquestFinished(RequestInfo ri, List<ZkResult> rl) {
        L.debug("Request finished; result : " + rl);
        ri.future.setFinished(rl, null);
        for (int i = 0; i < ri.re.size() && i < rl.size(); ++i) {
            ZkRequest re = ri.re.get(i);
            try {
                this.onRequestFinished(ZkEvents.createRequestEvent(re, rl.get(i)), ri);
                continue;
            }
            catch (Exception ex) {
                L.error("Unexpected error.", (Throwable)ex);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        b.append("state: ");
        b.append((Object)this.state);
        b.append(", name: ");
        b.append(this.name);
        b.append(", session: ");
        b.append(String.format("0x%x", this.sessionId));
        b.append(", references: ");
        b.append(this.referenceCount);
        b.append("]");
        return b.toString();
    }

    private Watcher createWatcherProxy(Watcher w) {
        return MDCLoggingProxy.createProxy(w, Watcher.class, MDC_KEY, this.getMDCContextValue());
    }

    private class MDCContextValue {
        ZkDefaultSession s;

        private MDCContextValue() {
            this.s = ZkDefaultSession.this;
        }

        public String toString() {
            return this.s.mdcContextValue;
        }
    }

    public static class RequestFuture
    implements Future<ZkResult> {
        private volatile boolean isDone;
        private volatile boolean isCanceled;
        private List<ZkResult> resultList = new ArrayList<ZkResult>();
        private Exception ex;
        private final Object guard = new Object();

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean success = true;
            if (mayInterruptIfRunning) {
                L.warn("Future may no be interrupted if it is running.");
            }
            if (this.isDone) {
                success = false;
            } else {
                this.isCanceled = true;
            }
            return success;
        }

        @Override
        public boolean isCancelled() {
            return this.isCanceled;
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZkResult get() throws InterruptedException, ExecutionException {
            Object object = this.guard;
            synchronized (object) {
                if (!this.isDone) {
                    this.guard.wait();
                }
                if (!this.isDone) {
                    throw new IllegalStateException("Not finished.");
                }
                if (this.resultList.size() > 1) {
                    throw new IllegalStateException("Multi result future. Please call ");
                }
                if (this.ex != null) {
                    if (this.ex instanceof CancellationException) {
                        throw (CancellationException)this.ex;
                    }
                    throw new ExecutionException(this.ex);
                }
                return this.resultList.size() > 0 ? this.resultList.get(0) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZkResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (unit != null && unit != TimeUnit.MILLISECONDS) {
                throw new IllegalArgumentException("Only miliseconds allowed.");
            }
            Object object = this.guard;
            synchronized (object) {
                if (!this.isDone) {
                    this.guard.wait(timeout);
                }
                if (this.isDone) {
                    ZkResult re;
                    Throwable t;
                    if (this.resultList.size() > 1) {
                        throw new IllegalStateException("Multi result future. Please call ");
                    }
                    if (this.ex != null) {
                        throw new ExecutionException(this.ex);
                    }
                    if (this.resultList.size() == 1 && (t = (re = this.resultList.get(0)).getThrowable()) != null) {
                        throw new ExecutionException(t);
                    }
                }
                return this.resultList.size() > 0 ? this.resultList.get(0) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ZkResult> getResults() throws InterruptedException, ExecutionException {
            Object object = this.guard;
            synchronized (object) {
                ZkResult re;
                Throwable t;
                if (!this.isDone) {
                    this.guard.wait();
                }
                if (!this.isDone) {
                    throw new IllegalStateException("Not finished.");
                }
                if (this.ex != null) {
                    if (this.ex instanceof CancellationException) {
                        throw (CancellationException)this.ex;
                    }
                    throw new ExecutionException(this.ex);
                }
                if (this.resultList.size() == 1 && (t = (re = this.resultList.get(0)).getThrowable()) != null) {
                    throw new ExecutionException(t);
                }
                return this.resultList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ZkResult> getResults(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (unit != null && unit != TimeUnit.MILLISECONDS) {
                throw new IllegalArgumentException("Only miliseconds allowed.");
            }
            Object object = this.guard;
            synchronized (object) {
                if (!this.isDone) {
                    this.guard.wait(timeout);
                }
                if (this.isDone && this.ex != null) {
                    throw new ExecutionException(this.ex);
                }
                return this.resultList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFinished(List<ZkResult> resultList, Exception ex) {
            Object object = this.guard;
            synchronized (object) {
                this.resultList = resultList;
                this.ex = ex;
                this.isDone = true;
                this.guard.notify();
            }
        }
    }

    private class RequestRunnable
    implements Runnable {
        RequestInfo ri;
        Integer delay = null;

        RequestRunnable(RequestInfo ri) {
            this.ri = ri;
        }

        RequestRunnable(RequestInfo ri, Integer delay) {
            this.ri = ri;
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.delay != null && this.delay > 0) {
                Object f = new Object();
                L.trace("Delayed request: " + this.delay);
                Object object = f;
                synchronized (object) {
                    try {
                        f.wait(this.delay.intValue());
                    }
                    catch (InterruptedException e) {
                        L.debug("Interrupted.", (Throwable)e);
                        Thread.currentThread().interrupt();
                        ZkDefaultSession.this.abortRequest(this);
                        throw new RuntimeException(e);
                    }
                }
            }
            ZkDefaultSession.this.runRequest(this.ri);
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " ri: " + this.ri + "]";
        }
    }

    private static class RequestInfo {
        static final int TYPE_SERIAL = 0;
        static final int TYPE_TRANS = 1;
        static final int TYPE_ASYNC = 2;
        final List<ZkRequest> re;
        final Map<ZkRequest, Integer> expectedResults;
        final Watcher w;
        final ZkEventListener rl;
        final AtomicInteger count = new AtomicInteger();
        final RequestFuture future;
        final int type;

        RequestInfo(int type, List<ZkRequest> rel, Watcher w, RequestFuture future, ZkEventListener rl) {
            if (rel == null || rel.size() == 0) {
                throw new IllegalArgumentException("rel");
            }
            this.type = type;
            if (type == 1) {
                for (ZkRequest re : rel) {
                    if (re instanceof ZkTransactionalRequest) continue;
                    throw new IllegalArgumentException(re + " not instance of " + ZkTransactionalRequest.class);
                }
            }
            if (type == 2) {
                for (ZkRequest re : rel) {
                    if (re instanceof ZkAsyncRequest) continue;
                    throw new IllegalArgumentException(re + " not instance of " + ZkTransactionalRequest.class);
                }
            }
            this.re = Collections.unmodifiableList(rel);
            this.expectedResults = new HashMap<ZkRequest, Integer>();
            this.w = w;
            this.future = future;
            this.rl = rl;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("[");
            b.append("re: ");
            b.append(this.re);
            b.append(", count: ");
            b.append(this.count);
            b.append("]");
            return b.toString();
        }
    }

    private static abstract class SessionRunnable
    implements Runnable {
        protected long sessionId;

        public SessionRunnable(long sessionId) {
            this.sessionId = sessionId;
        }
    }

    private static enum State {
        Created,
        Initialized,
        Expired,
        Closing,
        Finished;

    }
}

