/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.session;

import com.ez.keeper.client.log4j.Loggers;
import com.ez.keeper.client.log4j.MDCLoggingProxy;
import com.ez.keeper.client.session.RequestExecutor;
import java.util.LinkedList;
import org.slf4j.Logger;

public class ThreadRequestExecutor
implements RequestExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = Loggers.getLogger(ThreadRequestExecutor.class);
    LinkedList<Runnable> reqs;
    State state = State.Created;
    Thread t;
    final Object guard = new Object();
    volatile boolean canceling;
    Object mdcContextProvider;

    public ThreadRequestExecutor(Object mdcContextProvider) {
        this.reqs = new LinkedList();
        this.mdcContextProvider = mdcContextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Created) {
                throw new IllegalStateException("Expected " + (Object)((Object)State.Created) + " but found " + (Object)((Object)this.state));
            }
            Runnable r = MDCLoggingProxy.createProxy(new Runnable(){

                @Override
                public void run() {
                    ThreadRequestExecutor.this.runLoop();
                }
            }, Runnable.class, "ezkid", this.mdcContextProvider);
            this.t = new Thread(r, "RequestExecutor");
            this.state = State.Started;
            this.t.start();
        }
    }

    public void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(Integer timeout) {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Started) {
                throw new IllegalStateException("Expected " + (Object)((Object)State.Started) + " but found " + (Object)((Object)this.state));
            }
            this.canceling = true;
            this.state = State.Canceling;
            this.t.interrupt();
            try {
                if (timeout != null) {
                    this.guard.wait(timeout.intValue());
                } else {
                    this.guard.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.state != State.Canceled) {
                L.warn("Can't stop thread.");
            }
            this.state = State.Stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putback(Runnable r) {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Started) {
                throw new IllegalStateException("Expected " + (Object)((Object)State.Started) + " but found " + (Object)((Object)this.state));
            }
            this.reqs.add(0, r);
            this.guard.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Runnable r) {
        Object object = this.guard;
        synchronized (object) {
            if (this.state != State.Started) {
                throw new IllegalStateException("Expected " + (Object)((Object)State.Started) + " but found " + (Object)((Object)this.state));
            }
            this.reqs.add(r);
            this.guard.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanQueue() {
        Object object = this.guard;
        synchronized (object) {
            L.info("Pending requests... canceling them.");
            if (this.reqs.size() > 0) {
                for (Runnable r : this.reqs) {
                    this.callAbort(r);
                }
                this.reqs.clear();
            }
            this.onThreadStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStep(Integer count, boolean block) {
        int i = 0;
        while (count == null || i < count) {
            try {
                Runnable r = null;
                Object object = this.guard;
                synchronized (object) {
                    block16: {
                        if (!this.canceling) break block16;
                        L.debug("Executor closing, aborting thread.");
                        break;
                    }
                    if (this.reqs.size() > 0) {
                        r = this.reqs.removeFirst();
                    }
                    if (r == null && block) {
                        try {
                            this.guard.wait();
                        }
                        catch (InterruptedException e) {
                            L.trace("Interrupted.", (Throwable)e);
                        }
                    }
                }
                if (r == null) continue;
                L.trace("Running request...");
                try {
                    r.run();
                    L.trace("Request done.");
                }
                catch (Exception e) {
                    if (Thread.interrupted()) {
                        L.debug("Interrupted.", (Throwable)e);
                        this.callAbort(r);
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    L.error("Uncaught error.", (Throwable)e);
                }
            }
            finally {
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoop() {
        this.runStep(null, true);
        this.cleanQueue();
        Object object = this.guard;
        synchronized (object) {
            this.state = State.Canceled;
            this.guard.notifyAll();
        }
    }

    protected void onAbort(Runnable r) {
    }

    private void callAbort(Runnable r) {
        L.debug("Aborting request: " + r);
        try {
            this.onAbort(r);
        }
        catch (Exception ex) {
            L.error("Unexpected error while aborting request: " + r.toString(), (Throwable)ex);
        }
    }

    private void onThreadStopped() {
        this.state = State.Stopped;
        this.t = null;
    }

    private static enum State {
        Created,
        Started,
        Canceling,
        Canceled,
        Stopped;

    }
}

