/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.session;

import com.ez.keeper.client.log4j.Loggers;
import com.ez.keeper.client.session.RequestExecutor;
import java.util.LinkedList;
import org.slf4j.Logger;

public class SynchronousRequestExecutor
implements RequestExecutor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = Loggers.getLogger(SynchronousRequestExecutor.class);
    LinkedList<Runnable> reqs = new LinkedList();

    public SynchronousRequestExecutor(Object mdcContextProvider) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Integer timeout) {
        this.cleanQueue();
    }

    @Override
    public void putback(Runnable r) {
        this.reqs.add(0, r);
        this.step();
    }

    @Override
    public void submit(Runnable r) {
        this.reqs.add(r);
        this.step();
    }

    private boolean step() {
        Runnable r = null;
        if (this.reqs.size() > 0) {
            r = this.reqs.removeLast();
        }
        L.trace("Running request...");
        try {
            r.run();
            L.trace("Request done.");
        }
        catch (Exception e) {
            if (Thread.interrupted()) {
                L.debug("Interrupted.", (Throwable)e);
                this.callAbort(r);
                Thread.currentThread().interrupt();
            }
            L.error("Uncaught error.", (Throwable)e);
        }
        return r != null;
    }

    protected void onAbort(Runnable r) {
    }

    private void callAbort(Runnable r) {
        L.debug("Aborting request: " + r);
        try {
            this.onAbort(r);
        }
        catch (Exception ex) {
            L.error("Unexpected error while aborting request: " + r.toString(), (Throwable)ex);
        }
    }

    private void cleanQueue() {
        L.info("Pending requests... canceling them.");
        if (this.reqs.size() > 0) {
            for (Runnable r : this.reqs) {
                this.callAbort(r);
            }
            this.reqs.clear();
        }
    }
}

