/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.request.ZkTransactionalRequest;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkSetDataRequest
extends ZkBaseRequest
implements ZkTransactionalRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    Integer version;

    public ZkSetDataRequest(String path, byte[] data, Integer version) {
        super(path, ZkEventType.RequestFinished, data);
        this.version = version;
    }

    public ZkSetDataRequest(String path, byte[] data) {
        this(path, data, null);
    }

    @Override
    public ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        byte[] d = (byte[])this.argument;
        Stat stat = zk.setData(this.path, d, this.version != null ? this.version : -1);
        return new ZkResult(null, stat);
    }

    @Override
    public List<Op> enroll(ZooKeeper zk) {
        byte[] d = (byte[])this.argument;
        return Collections.singletonList(Op.setData((String)this.path, (byte[])d, (int)(this.version != null ? this.version : -1)));
    }

    @Override
    public ZkResult getResult(List<OpResult> r) {
        OpResult.SetDataResult sdr = (OpResult.SetDataResult)r.get(0);
        return new ZkResult(null, sdr.getStat());
    }
}

