/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.ZkException;
import com.ez.keeper.client.request.ZkAsyncRequest;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkResult;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkNodeExistsRequest
extends ZkBaseRequest
implements ZkAsyncRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ZkNodeExistsRequest(String path) {
        super(path, ZkEventType.NodeStatAvailable, null);
    }

    @Override
    public void execute(ZooKeeper zk, Watcher w, final ZkAsyncRequest.ZkAsyncCallback cb, Object ctx) throws Exception {
        AsyncCallback.StatCallback zcb = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code rcCode = KeeperException.Code.get((int)rc);
                cb.done(new ZkResult(stat, stat, rcCode == KeeperException.Code.OK || rcCode == KeeperException.Code.NONODE ? null : ZkException.create((Exception)KeeperException.create((KeeperException.Code)rcCode), 0L)), ctx);
            }
        };
        if (w == null) {
            zk.exists(this.path, false, zcb, ctx);
        } else {
            zk.exists(this.path, w, zcb, ctx);
        }
    }

    @Override
    public ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        Stat r = w == null ? zk.exists(this.path, false) : zk.exists(this.path, w);
        return new ZkResult(r, r);
    }
}

