/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.ZkException;
import com.ez.keeper.client.request.ZkAsyncRequest;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkResult;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkGetChildrenRequest
extends ZkBaseRequest
implements ZkAsyncRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ZkGetChildrenRequest(String path) {
        super(path, ZkEventType.NodeChildrenAvailable, null);
    }

    @Override
    public void execute(ZooKeeper zk, Watcher w, final ZkAsyncRequest.ZkAsyncCallback cb, Object ctx) throws Exception {
        AsyncCallback.Children2Callback zcb = new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                cb.done(new ZkResult(children, stat, rc == KeeperException.Code.OK.intValue() ? null : ZkException.create((Exception)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)), 0L)), ctx);
            }
        };
        if (w == null) {
            zk.getChildren(this.path, false, zcb, ctx);
        } else {
            zk.getChildren(this.path, w, zcb, ctx);
        }
    }

    @Override
    public ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        Stat stat = new Stat();
        List r = w == null ? zk.getChildren(this.path, false, stat) : zk.getChildren(this.path, w, stat);
        return new ZkResult(r, stat);
    }
}

