/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.request.ZkTransactionalRequest;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZkDeleteNodeRequest
extends ZkBaseRequest
implements ZkTransactionalRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected Integer version;

    public ZkDeleteNodeRequest(String path) {
        this(path, null);
    }

    public ZkDeleteNodeRequest(String path, Integer version) {
        super(path, ZkEventType.RequestFinished, null);
        this.version = version;
    }

    @Override
    protected ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        zk.delete(this.path, this.version != null ? this.version : -1);
        return new ZkResult(null, null);
    }

    @Override
    public List<Op> enroll(ZooKeeper zk) {
        this.L.debug(this.fmsg("Enroll: delete node: " + this.path));
        return Collections.singletonList(Op.delete((String)this.path, (int)(this.version != null ? this.version : -1)));
    }

    @Override
    public ZkResult getResult(List<OpResult> r) {
        return new ZkResult(null, null);
    }
}

