/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.request.ZkCreateNodeRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.request.ZkTransactionalRequest;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZkCreatePathRequest
extends ZkCreateNodeRequest
implements ZkTransactionalRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public ZkCreatePathRequest(String path, String data) {
        this(path, data, false, false);
    }

    public ZkCreatePathRequest(String path, String data, boolean ephemeral, boolean sequential) {
        super(path, data, ephemeral, sequential);
    }

    public ZkCreatePathRequest(String path, byte[] data, boolean ephemeral, boolean sequential) {
        super(path, data, ephemeral, sequential);
    }

    public ZkCreatePathRequest(String path, byte[] data) {
        this(path, data, false, false);
    }

    @Override
    protected ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        if (!ZkPath.validate(this.path)) {
            throw new IllegalArgumentException("Path is not absolute: " + this.path);
        }
        if (!ZkPath.isAbsolute(this.path)) {
            throw new IllegalArgumentException("Path is not absolute: " + this.path);
        }
        byte[] data = (byte[])this.argument;
        List<Op> opList = this.enroll(zk, w);
        return this.getLastResult(zk.multi(opList));
    }

    @Override
    public List<Op> enroll(ZooKeeper zk) throws Exception {
        return this.enroll(zk, null);
    }

    @Override
    public ZkResult getResult(List<OpResult> r) {
        if (r.size() == 0) {
            throw new IllegalArgumentException("Unexpected result list size: " + r.size());
        }
        return this.getLastResult(r);
    }

    private List<Op> enroll(ZooKeeper zk, Watcher w) throws Exception {
        byte[] data = (byte[])this.argument;
        ArrayList<Op> ops = new ArrayList<Op>();
        if (!ZkPath.validate(this.path)) {
            throw new IllegalArgumentException("Path is not absolute: " + this.path);
        }
        if (!ZkPath.isAbsolute(this.path)) {
            throw new IllegalArgumentException("Path is not absolute: " + this.path);
        }
        this.L.debug(this.fmsg("Enroll: creating path: " + this.path));
        String[] segs = ZkPath.split(this.path);
        if (segs.length == 1) {
            this.L.warn(this.fmsg("Nothing to do for root path."));
        } else {
            String currPath = segs[0];
            int j = 1;
            for (int i = 1; i < segs.length; ++i) {
                boolean last;
                boolean exists = false;
                exists = zk.exists(currPath = ZkPath.join(currPath, segs[i]), null) != null;
                boolean bl = last = j == segs.length - 1;
                if (!exists) {
                    this.L.debug(this.fmsg("Enroll: create path: " + currPath));
                    ops.add(Op.create((String)currPath, (byte[])(!last || data == null ? new byte[]{} : data), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)(last ? this.mode : CreateMode.PERSISTENT)));
                } else if (last) {
                    this.L.trace(this.fmsg("Path exists, setting data: " + currPath));
                    ops.add(Op.setData((String)currPath, (byte[])(data == null ? new byte[]{} : data), (int)-1));
                } else {
                    this.L.trace(this.fmsg("Skip existing path: " + currPath));
                }
                ++j;
            }
        }
        return ops;
    }

    private ZkResult getLastResult(List<OpResult> r) {
        if (r.size() > 0) {
            OpResult opr = r.get(r.size() - 1);
            if (opr instanceof OpResult.CreateResult) {
                OpResult.CreateResult opcr = (OpResult.CreateResult)opr;
                return new ZkResult(opcr.getPath(), null);
            }
            if (opr instanceof OpResult.SetDataResult) {
                return new ZkResult(this.path, null);
            }
            throw new IllegalArgumentException("Unexpected result type: " + opr.getClass());
        }
        return null;
    }
}

