/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.request.ZkBaseRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.request.ZkTransactionalRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class ZkCreateNodeRequest
extends ZkBaseRequest
implements ZkTransactionalRequest {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected static Map<Integer, CreateMode> modes = new HashMap<Integer, CreateMode>(){
        {
            this.put(0, CreateMode.PERSISTENT);
            this.put(1, CreateMode.EPHEMERAL);
            this.put(2, CreateMode.PERSISTENT_SEQUENTIAL);
            this.put(3, CreateMode.EPHEMERAL_SEQUENTIAL);
        }
    };
    protected CreateMode mode;

    public ZkCreateNodeRequest(String path, String data) {
        this(path, data, false, false);
    }

    public ZkCreateNodeRequest(String path, String data, boolean ephemeral, boolean sequential) {
        super(path, ZkEventType.RequestFinished, data != null ? data.getBytes() : null);
        this.mode = modes.get((ephemeral ? 1 : 0) | (sequential ? 2 : 0));
    }

    public ZkCreateNodeRequest(String path, byte[] data) {
        this(path, data, false, false);
    }

    public ZkCreateNodeRequest(String path, byte[] data, boolean ephemeral, boolean sequential) {
        super(path, ZkEventType.RequestFinished, data);
        this.mode = modes.get((ephemeral ? 1 : 0) | (sequential ? 2 : 0));
    }

    @Override
    protected ZkResult doExecute(ZooKeeper zk, Watcher w) throws Exception {
        byte[] data = (byte[])this.argument;
        this.L.debug(this.fmsg("Creating node: " + this.path));
        String path = zk.create(this.path, data != null ? data : new byte[]{}, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, this.mode);
        this.L.debug(this.fmsg("Created node: " + path));
        return new ZkResult(path, null);
    }

    @Override
    public List<Op> enroll(ZooKeeper zk) throws Exception {
        byte[] data = (byte[])this.argument;
        this.L.debug(this.fmsg("Enroll: creating node: " + this.path));
        return Collections.singletonList(Op.create((String)this.path, (byte[])(data != null ? data : new byte[]{}), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)this.mode));
    }

    @Override
    public ZkResult getResult(List<OpResult> r) {
        if (r.size() == 0 || r.size() > 1) {
            throw new IllegalArgumentException("Unexpected result list size: " + r.size());
        }
        OpResult opr = r.get(r.size() - 1);
        if (opr instanceof OpResult.CreateResult) {
            OpResult.CreateResult opcr = (OpResult.CreateResult)opr;
            return new ZkResult(opcr.getPath(), null);
        }
        throw new IllegalArgumentException("Unexpected result type: " + opr.getClass());
    }
}

