/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.request;

import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.log4j.Loggers;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;

public abstract class ZkBaseRequest
implements ZkRequest {
    protected final Logger L = Loggers.getLogger(this.getClass());
    protected Object argument = null;
    protected String path;
    protected ZkEventType eventType;

    public ZkBaseRequest(String path, ZkEventType eventType, Object argument) {
        if (eventType == null) {
            throw new IllegalArgumentException("eventType");
        }
        this.path = path;
        this.argument = argument;
        this.eventType = eventType;
    }

    @Override
    public ZkEventType getFinishEventType() {
        return this.eventType;
    }

    @Override
    public ZkResult execute(ZooKeeper zk, Watcher w) throws Exception {
        ZkResult r = null;
        if (this.L.isDebugEnabled()) {
            this.L.debug("Executing request " + this);
        }
        r = this.doExecute(zk, w);
        if (this.L.isDebugEnabled()) {
            this.L.debug("Request done; result: " + r);
        }
        return r;
    }

    public Object getArgument() {
        return this.argument;
    }

    public String getPath() {
        return this.path;
    }

    protected abstract ZkResult doExecute(ZooKeeper var1, Watcher var2) throws Exception;

    protected void toString(StringBuilder b) {
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        b.append("class: ");
        b.append(this.getClass().getSimpleName());
        b.append(", path ");
        b.append(this.path);
        b.append(", argument ");
        b.append(this.argument);
        this.toString(b);
        b.append("]");
        return b.toString();
    }

    protected String fmsg(String msg) {
        return String.format("%s: %s", this.path, msg);
    }
}

