/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.log4j;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCLoggingProxy {
    private static final Logger L = LoggerFactory.getLogger(MDCLoggingProxy.class);

    public static <I, C> I createProxy(C object, Class<I> clazz, String key, Object valueProvider) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("valueProvider is null");
        }
        return (I)Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new NDCInvocationHandler(object, key, valueProvider));
    }

    private static class NDCInvocationHandler
    implements InvocationHandler {
        private String key;
        private Object valueProvider;
        private Object target;

        NDCInvocationHandler(Object target, String key, Object valueProvider) {
            this.key = key;
            this.valueProvider = valueProvider;
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String oldValue = MDC.get((String)this.key);
            if (oldValue != null && L.isTraceEnabled()) {
                L.trace("Key already in context: " + this.key);
            }
            MDC.put((String)this.key, (String)this.valueProvider.toString());
            try {
                Object object = method.invoke(this.target, args);
                return object;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            finally {
                MDC.remove((String)this.key);
                if (oldValue != null) {
                    MDC.put((String)this.key, (String)oldValue.toString());
                }
            }
        }
    }
}

