/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.lock;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkNetworkException;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkRequestEvent;
import com.ez.keeper.client.ZkSessionImpl;
import com.ez.keeper.client.lock.JsonTemplate;
import com.ez.keeper.client.lock.LockListener;
import com.ez.keeper.client.lock.LockState;
import com.ez.keeper.client.request.ZkCreatePathRequest;
import com.ez.keeper.client.request.ZkDeleteNodeRequest;
import com.ez.keeper.client.request.ZkGetChildrenRequest;
import com.ez.keeper.client.request.ZkGetDataRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import com.ez.keeper.client.state.SessionState;
import com.ez.keeper.client.state.SessionStateListener;
import com.ez.keeper.client.state.SessionStateListenerRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteLock {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final Logger L = LoggerFactory.getLogger(this.getClass());
    public static final String READ_PREFIX = "read-";
    public static final String WRITE_PREFIX = "write-";
    private final String path;
    private final Map<String, String> debugInfo;
    private final ZkSessionImpl zk;
    private final UUID appSessionId;
    private final LockListener l;
    private final Object stateGuard = new Object();
    private LockState lockState = LockState.None;
    private SessionStateListener sessionStateListener;
    private SynchronizedState INIT = new SynchronizedState(new BaseState("INIT"){

        @Override
        public synchronized void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, null, null, null, args);
            SessionStateListenerRegistry.ensureRegistered(this.rwLockl.zk, null, this.rwLockl.sessionStateListener);
            ReadWriteLock.this.setLockState(LockState.None);
        }

        @Override
        public void onBeginAcquire(LockState lockType) {
            if (lockType == LockState.Read) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.CREATE_READ_NODE, "onBeginAcquire", new Object[0]);
            } else if (lockType == LockState.Write) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.CREATE_WRITE_NODE, "onBeginAcquire", new Object[0]);
            } else {
                throw new IllegalStateException();
            }
        }
    });
    private SynchronizedState CREATE_READ_NODE = new SynchronizedState(new BaseState("CREATE_READ_NODE"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, null, null, null, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            this.ephemeralReadNode = ReadWriteLock.getLastSegment((String)r.getData());
            ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_READ, "processResult", new Object[0]);
        }

        @Override
        protected void sendRequest() {
            String ephemeral = ZkPath.join(this.rwLockl.path, ReadWriteLock.READ_PREFIX);
            this.submitRequest(new ZkCreatePathRequest(ephemeral, JsonTemplate.getEphemaralPayload(ReadWriteLock.this.appSessionId.toString(), ReadWriteLock.this.debugInfo), true, true));
        }

        @Override
        public void onSessionExpired() {
            this.sessionState = SessionState.Expired;
        }
    });
    private SynchronizedState CREATE_WRITE_NODE = new SynchronizedState(new BaseState("CREATE_WRITE_NODE"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, null, null, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            this.ephemeralWriteNode = ReadWriteLock.getLastSegment((String)r.getData());
            ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_WRITE, "processResult", new Object[0]);
        }

        @Override
        protected void sendRequest() {
            String ephemeral = ZkPath.join(this.rwLockl.path, ReadWriteLock.WRITE_PREFIX);
            this.submitRequest(new ZkCreatePathRequest(ephemeral, JsonTemplate.getEphemaralPayload(ReadWriteLock.this.appSessionId.toString(), ReadWriteLock.this.debugInfo), true, true));
        }

        @Override
        public void onSessionExpired() {
            this.sessionState = SessionState.Expired;
        }
    });
    private SynchronizedState TRY_READ = new SynchronizedState(new BaseState("TRY_READ"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, null, null, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            List children = (List)r.getData();
            this.waitNode = ReadWriteLock.getNextLowestWriteChild(children, this.ephemeralReadNode);
            if (this.waitNode == null) {
                ReadWriteLock.this.L.debug("Lock acquired.");
                ReadWriteLock.this.moveState(ReadWriteLock.this.READ_HELD, "processResult", new Object[0]);
            } else {
                ReadWriteLock.this.L.debug("Have to wait for " + this.waitNode);
                ReadWriteLock.this.moveState(ReadWriteLock.this.WAIT_READ, "processResult", new Object[0]);
            }
        }

        @Override
        protected void sendRequest() {
            this.submitRequest(new ZkGetChildrenRequest(this.rwLockl.path));
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }
    });
    private SynchronizedState TRY_WRITE = new SynchronizedState(new BaseState("TRY_WRITE"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, null, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            List children = (List)r.getData();
            this.waitNode = ReadWriteLock.getNextLowestChild(children, this.ephemeralReadNode != null ? this.ephemeralReadNode : this.ephemeralWriteNode);
            if (this.waitNode == null) {
                ReadWriteLock.this.L.debug("Lock acquired.");
                ReadWriteLock.this.moveState(ReadWriteLock.this.WRITE_HELD, "processResult", new Object[0]);
            } else {
                ReadWriteLock.this.L.debug("Have to wait for " + this.waitNode);
                ReadWriteLock.this.moveState(ReadWriteLock.this.WAIT_WRITE, "processResult", new Object[0]);
            }
        }

        @Override
        protected void sendRequest() {
            this.submitRequest(new ZkGetChildrenRequest(this.rwLockl.path));
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }
    });
    private SynchronizedState READ_HELD = new SynchronizedState(new BaseState("READ_HELD"){

        @Override
        public synchronized void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, null, null, args);
            ReadWriteLock.this.setLockState(LockState.Read);
        }

        @Override
        public void onBeginAcquire(LockState lockType) {
            if (lockType != LockState.Write) {
                throw new IllegalStateException();
            }
            ReadWriteLock.this.moveState(ReadWriteLock.this.CREATE_WRITE_NODE, "onBeginAcquire", new Object[0]);
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }
    });
    private SynchronizedState WRITE_HELD = new SynchronizedState(new BaseState("WRITE_HELD"){

        @Override
        public synchronized void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, null, args);
            ReadWriteLock.this.setLockState(LockState.Write);
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }
    });
    private SynchronizedState WAIT_READ = new SynchronizedState(new BaseState("WAIT_READ"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, null, waitNode, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            Object data = r.getData();
            if (data == null) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_READ, "processResult", new Object[0]);
            } else if (ReadWriteLock.this.L.isDebugEnabled()) {
                String sdata = null;
                try {
                    sdata = new String((byte[])data, "utf8");
                }
                catch (Exception ex) {
                    ReadWriteLock.this.L.error("", (Throwable)ex);
                }
                if (sdata != null) {
                    ReadWriteLock.this.L.debug("Lock holder info: {}", (Object)sdata);
                }
            }
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }

        @Override
        protected void sendRequest() {
            this.submitRequest(new ZkGetDataRequest(ZkPath.join(this.rwLockl.path, this.waitNode)), new ZkEventListenerAdapter(){

                @Override
                public void notifyNodeDeleted(ZkNodeEvent e) {
                    this.onNodeDeleted();
                }
            });
        }

        private void onNodeDeleted() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_READ, "onNodeDeleted", new Object[0]);
        }
    });
    private SynchronizedState WAIT_WRITE = new SynchronizedState(new BaseState("WAIT_WRITE"){

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
            this.sendRequest();
        }

        @Override
        public void processResult(ZkResult r) {
            Object data = r.getData();
            if (data == null) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_WRITE, "processResult", new Object[0]);
            } else if (ReadWriteLock.this.L.isDebugEnabled()) {
                String sdata = null;
                try {
                    sdata = new String((byte[])data, "utf8");
                }
                catch (Exception ex) {
                    ReadWriteLock.this.L.error("", (Throwable)ex);
                }
                if (sdata != null) {
                    ReadWriteLock.this.L.debug("Lock holder info: {}", (Object)sdata);
                }
            }
        }

        @Override
        public void onRelease() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
        }

        @Override
        public void onCancel() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
        }

        @Override
        protected void sendRequest() {
            this.submitRequest(new ZkGetDataRequest(ZkPath.join(this.rwLockl.path, this.waitNode)), new ZkEventListenerAdapter(){

                @Override
                public void notifyNodeDeleted(ZkNodeEvent e) {
                    this.onNodeDeleted();
                }
            });
        }

        private void onNodeDeleted() {
            ReadWriteLock.this.moveState(ReadWriteLock.this.TRY_WRITE, "onNodeDeleted", new Object[0]);
        }
    });
    private SynchronizedState FINALIZING = new SynchronizedState(new BaseState("FINALIZING"){
        String toDelete;

        @Override
        public synchronized void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
            if (this.sessionState == SessionState.Expired) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZED, "onEnter && session expired", new Object[0]);
            } else {
                if (this.ephemeralWriteNode != null) {
                    this.toDelete = this.ephemeralWriteNode;
                } else if (this.ephemeralReadNode != null) {
                    this.toDelete = this.ephemeralReadNode;
                }
                if (this.toDelete != null) {
                    this.sendRequest();
                } else if (this.ephemeralReadNode != null) {
                    ReadWriteLock.this.moveState(ReadWriteLock.this.READ_HELD, "onEnter", new Object[0]);
                } else {
                    ReadWriteLock.this.moveState(ReadWriteLock.this.INIT, "onEnter", new Object[0]);
                }
            }
        }

        @Override
        protected void sendRequest() {
            this.submitRequest(new ZkDeleteNodeRequest(ZkPath.join(this.rwLockl.path, this.toDelete)));
        }

        @Override
        public void processResult(ZkResult r) {
            if (this.ephemeralReadNode != null && this.ephemeralWriteNode != null) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.READ_HELD, "processResult", new Object[0]);
            } else {
                ReadWriteLock.this.moveState(ReadWriteLock.this.INIT, "processResult", new Object[0]);
            }
        }
    });
    private SynchronizedState FINALIZED = new SynchronizedState(new BaseState("FINALIZED"){

        @Override
        public synchronized void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            super.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
            ReadWriteLock.this.setLockState(LockState.None);
        }

        @Override
        public synchronized void onLeave() {
            SessionStateListenerRegistry.unregister(this.rwLockl.sessionStateListener);
        }
    });
    private SynchronizedState state = this.INIT;

    public ReadWriteLock(ZkSessionImpl zk, UUID appSessionId, String path) {
        this(zk, appSessionId, path, Collections.emptyMap(), null);
    }

    public ReadWriteLock(ZkSessionImpl zk, UUID appSessionId, String path, Map<String, String> debugInfo) {
        this(zk, appSessionId, path, debugInfo, null);
    }

    public ReadWriteLock(ZkSessionImpl zk, UUID appSessionId, String path, Map<String, String> debugInfo, LockListener l) {
        if (zk == null) {
            throw new IllegalArgumentException("zk");
        }
        if (appSessionId == null) {
            throw new IllegalArgumentException("appSessionId");
        }
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this.zk = zk;
        this.appSessionId = appSessionId;
        this.path = path;
        this.l = l;
        this.debugInfo = debugInfo;
        this.sessionStateListener = new SessionStateListener(){

            @Override
            public void onStateChanged(SessionState state) {
                switch (state) {
                    case Disconnected: {
                        ReadWriteLock.this.state.onDisconnected();
                        break;
                    }
                    case Connected: {
                        ReadWriteLock.this.state.onConnected();
                        break;
                    }
                    case Expired: {
                        ReadWriteLock.this.state.onSessionExpired();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Ouch!");
                    }
                }
            }
        };
    }

    public boolean acquire(LockState lockType, long timeout) {
        return this.doAcquire(lockType, timeout);
    }

    public boolean acquire(LockState lockType) {
        return this.doAcquire(lockType, null);
    }

    public LockState release() {
        return this.release(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockState release(Long timeout) {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.lockState != LockState.None) {
                boolean released;
                SynchronizedState expectedState = this.state.isEscalated() ? this.READ_HELD : this.INIT;
                HashSet<State> waitStates = new HashSet<State>(){
                    {
                        this.add(ReadWriteLock.this.FINALIZED);
                        this.add(ReadWriteLock.this.INIT);
                    }
                };
                if (this.lockState == LockState.Write) {
                    waitStates.add(this.READ_HELD);
                }
                this.L.info("Releasing lock {}", (Object)this.lockState);
                this.state.onRelease();
                this.waitStates((Set<State>)waitStates, timeout);
                boolean bl = released = this.state == expectedState;
                if (!released) {
                    this.L.info("Lock not released, canceling...");
                    this.state.onCancel();
                    this.waitStates((Set<State>)waitStates, timeout);
                    boolean bl2 = released = this.state == expectedState;
                }
                if (released) {
                    this.L.info("Lock released.");
                } else {
                    this.L.info("Lock NOT released.");
                }
            } else {
                this.L.info("Lock not held, nothing to do.");
            }
            return this.lockState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockState getState() {
        Object object = this.stateGuard;
        synchronized (object) {
            return this.lockState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAcquire(LockState lockType, Long timeout) {
        Object object = this.stateGuard;
        synchronized (object) {
            if (lockType == LockState.None) {
                throw new IllegalArgumentException(lockType.toString());
            }
            if (lockType == LockState.Read) {
                if (this.lockState == LockState.Read) {
                    throw new IllegalStateException("Lock already acquired: " + (Object)((Object)lockType));
                }
                if (this.lockState == LockState.Write) {
                    throw new IllegalStateException("Higher lock already acquired.");
                }
            }
            if (lockType == LockState.Write && this.lockState == LockState.Write) {
                throw new IllegalStateException("Lock already acquired: " + (Object)((Object)lockType));
            }
            boolean acquired = false;
            this.L.debug("Lock acquiring: " + acquired);
            this.enterState(this.state, "doAcquire", new Object[0]);
            this.state.onBeginAcquire(lockType);
            final SynchronizedState expectedState = lockType == LockState.Read ? this.READ_HELD : this.WRITE_HELD;
            this.waitStates((Set<State>)new HashSet<State>(){
                {
                    this.add(expectedState);
                    this.add(ReadWriteLock.this.FINALIZED);
                    this.add(ReadWriteLock.this.INIT);
                }
            }, timeout);
            boolean bl = acquired = this.state == expectedState;
            if (!acquired) {
                this.state.onCancel();
                this.waitStates((Set<State>)new HashSet<State>(){
                    {
                        this.add(ReadWriteLock.this.FINALIZED);
                        this.add(ReadWriteLock.this.INIT);
                    }
                }, timeout);
            }
            this.L.debug("Lock acquired: " + acquired);
            return acquired;
        }
    }

    private void waitStates(Set<State> states, Long timeout) {
        long start = System.currentTimeMillis();
        try {
            while (!states.contains(this.state)) {
                if (timeout != null) {
                    this.L.debug("Waiting for {} {}ms...", states, (Object)timeout);
                    this.stateGuard.wait(timeout);
                } else {
                    this.L.debug("Waiting for {}...", states);
                    this.stateGuard.wait();
                }
                if (states.contains(this.state)) break;
                if (timeout != null) {
                    long now = System.currentTimeMillis();
                    if (now - start < timeout) {
                        this.L.trace("Sleeping again.");
                        continue;
                    }
                    break;
                }
                this.L.trace("Sleeping again.");
            }
        }
        catch (InterruptedException e) {
            this.L.debug("Interrupted.", (Throwable)e);
        }
    }

    private void setLockState(LockState lockState) {
        this.L.debug(String.format("Lock state %s=>%s", new Object[]{this.lockState, lockState}));
        this.lockState = lockState;
        if (this.l != null) {
            this.l.stateChanged(lockState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveState(SynchronizedState newState, String when, Object ... args) {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != newState) {
                this.L.info(String.format("State transition: %s=>%s on %s", this.state, newState, when));
                this.state.onLeave();
                String ephemeralReadNode = this.state.getEphemeralReadNode();
                String ephemeralWriteNode = this.state.getEphemeralWriteNode();
                String waitNode = this.state.getWaitNode();
                this.state = newState;
                newState.onEnter(this.state.getImpl().sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
                this.stateGuard.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterState(SynchronizedState state, String when, Object ... args) {
        Object object = this.stateGuard;
        synchronized (object) {
            this.L.info(String.format("Enter state %s on %s", state, when));
            this.state.onLeave();
            String ephemeralReadNode = this.state.getEphemeralReadNode();
            String ephemeralWriteNode = this.state.getEphemeralWriteNode();
            String waitNode = this.state.getWaitNode();
            state.onEnter(state.getImpl().sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
            this.stateGuard.notifyAll();
        }
    }

    private static String getLastSegment(String path) {
        String[] children = ZkPath.split(path);
        return children[children.length - 1];
    }

    private static String getNextLowestChild(List<String> children, String me) {
        Long myKey;
        TreeMap<Long, String> childrenMap = new TreeMap<Long, String>();
        if (me.startsWith(READ_PREFIX)) {
            myKey = Long.parseLong(me.substring(READ_PREFIX.length()));
        } else if (me.startsWith(WRITE_PREFIX)) {
            myKey = Long.parseLong(me.substring(WRITE_PREFIX.length()));
        } else {
            throw new RuntimeException("Unexpected child: " + me);
        }
        for (String child : children) {
            if (child.startsWith(READ_PREFIX)) {
                childrenMap.put(Long.parseLong(child.substring(READ_PREFIX.length())), child);
                continue;
            }
            if (child.startsWith(WRITE_PREFIX)) {
                childrenMap.put(Long.parseLong(child.substring(WRITE_PREFIX.length())), child);
                continue;
            }
            throw new RuntimeException("Unexpected child: " + child);
        }
        SortedMap lessThanMe = childrenMap.headMap(myKey);
        if (lessThanMe.isEmpty()) {
            return null;
        }
        return (String)lessThanMe.get(lessThanMe.lastKey());
    }

    private static String getNextLowestWriteChild(List<String> children, String me) {
        Long myKey;
        TreeMap<Long, String> childrenMap = new TreeMap<Long, String>();
        if (me.startsWith(READ_PREFIX)) {
            myKey = Long.parseLong(me.substring(READ_PREFIX.length()));
        } else if (me.startsWith(WRITE_PREFIX)) {
            myKey = Long.parseLong(me.substring(WRITE_PREFIX.length()));
        } else {
            throw new RuntimeException("Unexpected child: " + me);
        }
        for (String child : children) {
            if (child.startsWith(READ_PREFIX)) continue;
            if (child.startsWith(WRITE_PREFIX)) {
                childrenMap.put(Long.parseLong(child.substring(WRITE_PREFIX.length())), child);
                continue;
            }
            throw new RuntimeException("Unexpected child: " + child);
        }
        SortedMap lessThanMe = childrenMap.headMap(myKey);
        if (lessThanMe.isEmpty()) {
            return null;
        }
        return (String)lessThanMe.get(lessThanMe.lastKey());
    }

    private class BaseState
    implements State {
        final String name;
        final ReadWriteLock rwLockl;
        SessionState sessionState;
        Object context;
        String ephemeralWriteNode;
        String ephemeralReadNode;
        String waitNode;
        boolean resend;

        public BaseState(String name) {
            this.rwLockl = ReadWriteLock.this;
            this.sessionState = SessionState.Disconnected;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getEphemeralReadNode() {
            return this.ephemeralReadNode;
        }

        @Override
        public String getEphemeralWriteNode() {
            return this.ephemeralWriteNode;
        }

        @Override
        public String getWaitNode() {
            return this.waitNode;
        }

        @Override
        public boolean isEscalated() {
            return this.ephemeralReadNode != null && this.ephemeralWriteNode != null;
        }

        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            this.sessionState = sessionState;
            this.ephemeralReadNode = ephemeralReadNode;
            this.ephemeralWriteNode = ephemeralWriteNode;
            this.waitNode = waitNode;
            this.context = new Object();
        }

        @Override
        public void onLeave() {
            this.context = null;
        }

        @Override
        public void onRequestDone(ZkResult r, Object context) {
            if (this.context != context) {
                ReadWriteLock.this.L.debug("Retarded result, ignore: " + r);
            } else {
                this.processResult(r);
            }
        }

        @Override
        public void onRequestFailed(Exception e, Object context) {
            if (this.context != context) {
                ReadWriteLock.this.L.debug("Request failed.", (Throwable)e);
                ReadWriteLock.this.L.debug("Request retarded, ignore.");
            } else {
                ReadWriteLock.this.L.error("Request failed.", (Throwable)e);
                if (e instanceof ZkNetworkException) {
                    if (this.sessionState == SessionState.Connected) {
                        this.sendRequest();
                    } else if (this.sessionState == SessionState.Expired) {
                        ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZED, "onRequestFailed", new Object[0]);
                    } else {
                        this.resend = true;
                    }
                } else if (this.name.equals(ReadWriteLock.this.FINALIZING.getName())) {
                    ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZED, "onRequestFailed", new Object[0]);
                } else if (!this.name.equals(ReadWriteLock.this.FINALIZED.getName())) {
                    ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRequestFailed", new Object[0]);
                }
            }
        }

        @Override
        public void onEvent(ZkEventListener l, ZkEvent e) {
            l.notifyEvent(e);
        }

        @Override
        public void onConnected() {
            ReadWriteLock.this.L.debug("Connection state: connected");
            this.sessionState = SessionState.Connected;
            if (this.resend) {
                this.resend = true;
                this.sendRequest();
            }
        }

        @Override
        public void onDisconnected() {
            ReadWriteLock.this.L.debug("Connection state: disconnected");
            this.sessionState = SessionState.Disconnected;
        }

        @Override
        public void onSessionExpired() {
            this.sessionState = SessionState.Expired;
            if (!this.name.equals(ReadWriteLock.this.FINALIZING.getName()) && !this.name.equals(ReadWriteLock.this.FINALIZED.getName())) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onSessionExpired", new Object[0]);
            }
        }

        @Override
        public void onBeginAcquire(LockState lockType) {
        }

        @Override
        public void onRelease() {
            if (!this.name.equals(ReadWriteLock.this.FINALIZING.getName()) && !this.name.equals(ReadWriteLock.this.FINALIZED.getName())) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onRelease", new Object[0]);
            }
        }

        @Override
        public void onCancel() {
            if (!this.name.equals(ReadWriteLock.this.FINALIZING.getName()) && !this.name.equals(ReadWriteLock.this.FINALIZED.getName())) {
                ReadWriteLock.this.moveState(ReadWriteLock.this.FINALIZING, "onCancel", new Object[0]);
            }
        }

        public String toString() {
            return this.name;
        }

        protected void sendRequest() {
        }

        protected void processResult(ZkResult r) {
        }

        protected void processEvent(ZkEvent e) {
        }

        protected void submitRequest(ZkRequest re) {
            try {
                this.submitRequest(re, null);
            }
            catch (Exception ex) {
                this.onRequestFailed(ex, this.context);
            }
        }

        protected void submitRequest(ZkRequest re, final ZkEventListener listener) {
            final Object reContext = this.context;
            ZkEventListener reListener = new ZkEventListener(){
                final Object context;
                {
                    this.context = BaseState.this.context;
                }

                @Override
                public void notifyEvent(ZkEvent event) {
                    if (event instanceof ZkRequestEvent) {
                        ZkRequestEvent re = (ZkRequestEvent)event;
                        if (!re.hasError()) {
                            ZkResult r = re.getResult();
                            BaseState.this.onRequestDone(r, reContext);
                        } else {
                            BaseState.this.onRequestFailed(re.getException(), reContext);
                        }
                    } else {
                        Object currentContext = BaseState.this.context;
                        if (currentContext != null && currentContext.equals(this.context)) {
                            BaseState.this.onEvent(listener, event);
                        } else {
                            ReadWriteLock.this.L.debug("Retarded event, ignore: " + event);
                        }
                    }
                }
            };
            this.rwLockl.zk.executeAsync(re, reListener);
        }
    }

    private class SynchronizedState
    implements State {
        final Object guard;
        BaseState s;

        public SynchronizedState(BaseState s) {
            this.guard = ReadWriteLock.this.stateGuard;
            this.s = s;
        }

        public BaseState getImpl() {
            return this.s;
        }

        @Override
        public String getName() {
            return this.s.getName();
        }

        @Override
        public String getEphemeralReadNode() {
            return this.s.getEphemeralReadNode();
        }

        @Override
        public String getEphemeralWriteNode() {
            return this.s.getEphemeralWriteNode();
        }

        @Override
        public String getWaitNode() {
            return this.s.getWaitNode();
        }

        @Override
        public boolean isEscalated() {
            return this.s.isEscalated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEnter(SessionState sessionState, String ephemeralReadNode, String ephemeralWriteNode, String waitNode, Object ... args) {
            Object object = this.guard;
            synchronized (object) {
                this.s.onEnter(sessionState, ephemeralReadNode, ephemeralWriteNode, waitNode, args);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeave() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onLeave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestDone(ZkResult r, Object context) {
            Object object = this.guard;
            synchronized (object) {
                this.s.onRequestDone(r, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestFailed(Exception e, Object context) {
            Object object = this.guard;
            synchronized (object) {
                this.s.onRequestFailed(e, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(ZkEventListener l, ZkEvent e) {
            Object object = this.guard;
            synchronized (object) {
                this.s.onEvent(l, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onConnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnected() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onDisconnected();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionExpired() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onSessionExpired();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBeginAcquire(LockState lockType) {
            Object object = this.guard;
            synchronized (object) {
                this.s.onBeginAcquire(lockType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRelease() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onRelease();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCancel() {
            Object object = this.guard;
            synchronized (object) {
                this.s.onCancel();
            }
        }

        public String toString() {
            return this.s.toString();
        }
    }

    private static interface State {
        public String getName();

        public String getEphemeralReadNode();

        public String getEphemeralWriteNode();

        public String getWaitNode();

        public void onEnter(SessionState var1, String var2, String var3, String var4, Object ... var5);

        public void onLeave();

        public void onRequestDone(ZkResult var1, Object var2);

        public void onRequestFailed(Exception var1, Object var2);

        public void onEvent(ZkEventListener var1, ZkEvent var2);

        public void onConnected();

        public void onDisconnected();

        public void onSessionExpired();

        public void onBeginAcquire(LockState var1);

        public void onRelease();

        public void onCancel();

        public boolean isEscalated();
    }
}

