/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.lock;

import com.ez.json.tools.binding.JsonGenerator;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTemplate {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JsonTemplate.class);
    public static final String NODE_CHARSET = "utf8";
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("hh:mm:ss");

    public static String getEphemaralPayload(final String sessionId, final Map<String, String> debugInfo) {
        String json = null;
        Instant instant = Instant.now();
        final ZonedDateTime zDateTime = instant.atZone(ZoneOffset.UTC);
        HashMap<String, Object> data = new HashMap<String, Object>(){
            {
                this.put("formatVersion", "1.0");
                this.put("sessionId", sessionId);
                this.put("created", new HashMap<String, Object>(){
                    {
                        this.put("date", DATE_FORMAT.format(zDateTime));
                        this.put("time", TIME_FORMAT.format(zDateTime));
                    }
                });
            }
        };
        if (debugInfo != null) {
            data.put("ext", new HashMap<String, Object>(){
                {
                    this.put("debug_info", new HashMap<String, Object>(){
                        {
                            this.putAll(debugInfo);
                        }
                    });
                }
            });
        }
        try {
            json = JsonGenerator.toJsonString((Object)data);
        }
        catch (Exception ex) {
            L.error("", (Throwable)ex);
        }
        return json;
    }
}

