/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client.cache;

import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkMonitor;
import com.ez.keeper.client.ZkNoSuchNodeException;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.cache.CacheChildrenEntry;
import com.ez.keeper.client.cache.CacheDataEntry;
import com.ez.keeper.client.cache.CacheEvent;
import com.ez.keeper.client.cache.CacheException;
import com.ez.keeper.client.cache.CacheListener;
import com.ez.keeper.client.cache.ChildrenAvailableEvent;
import com.ez.keeper.client.cache.NodeAvailableEvent;
import com.ez.keeper.client.cache.NodeDeletedEvent;
import com.ez.keeper.client.request.ZkGetChildrenRequest;
import com.ez.keeper.client.request.ZkGetDataRequest;
import com.ez.keeper.client.request.ZkRequest;
import com.ez.keeper.client.request.ZkResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCache {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(LocalCache.class);
    private final ZkSession session;
    private final String cacheName;
    private final String nodePath;
    private final Map<String, CacheEntry> entries;
    private final Set<CacheListener> listeners;
    private ZkMonitor m;
    private State state = State.Created;

    public static LocalCache create(ZkSession session, String nodePath, String cacheName) {
        return new LocalCache(session, nodePath, cacheName);
    }

    private LocalCache(ZkSession session, String nodePath, String cacheName) {
        this.session = session;
        this.cacheName = cacheName;
        this.nodePath = nodePath;
        this.entries = new HashMap<String, CacheEntry>();
        this.listeners = new HashSet<CacheListener>();
        this.ensureInitialized();
        L.info("Cache created.");
    }

    public synchronized void registerListener(CacheListener l) {
        if (this.state == State.Destroyed) {
            throw new IllegalStateException("Cached destroyed.");
        }
        this.listeners.add(l);
    }

    public synchronized void unregisterListener(CacheListener l) {
        if (this.state == State.Destroyed) {
            throw new IllegalStateException("Cached destroyed.");
        }
        this.listeners.remove(l);
    }

    public synchronized CacheDataEntry getData(String nodePath) {
        return this.getData(nodePath, 0);
    }

    public synchronized CacheDataEntry getData(String nodePath, int flags) {
        if (this.state == State.Destroyed) {
            throw new IllegalStateException("Cached destroyed.");
        }
        this.ensureInitialized();
        if (this.state != State.Initialized) {
            throw new CacheException(1, "Initialization pending.");
        }
        CacheEntry ce = this.entries.get(nodePath);
        if ((flags & 1) > 0) {
            this.fetch(nodePath, true, false);
            ce = this.entries.get(nodePath);
        }
        if (ce != null) {
            return ce.data;
        }
        return null;
    }

    public synchronized CacheChildrenEntry getChildren(String nodePath) {
        return this.getChildren(nodePath, 0);
    }

    public synchronized CacheChildrenEntry getChildren(String nodePath, int flags) {
        if (this.state == State.Destroyed) {
            throw new IllegalStateException("Cached destroyed.");
        }
        this.ensureInitialized();
        if (this.state != State.Initialized) {
            throw new CacheException(1, "Initialization pending.");
        }
        CacheEntry ce = this.entries.get(nodePath);
        if ((flags & 1) > 0) {
            this.fetch(nodePath, false, true);
            ce = this.entries.get(nodePath);
        }
        if (ce != null) {
            return ce.children;
        }
        return null;
    }

    public synchronized void destroy() {
        if (this.state != State.Destroyed) {
            try {
                this.entries.clear();
                if (this.m != null) {
                    try {
                        this.m.stop();
                    }
                    catch (Exception ex) {
                        L.error("Can't stop monitor.", (Throwable)ex);
                    }
                }
            }
            finally {
                this.state = State.Destroyed;
                L.info("Cache destroyed.");
            }
        }
    }

    private synchronized void ensureInitialized() {
        if (this.state == State.Created) {
            this.state = State.Initializing;
            try {
                this.fetchData();
                this.m = this.session.watch(this.nodePath, (ZkEventListener)new ZkEventListenerAdapter(){

                    @Override
                    public void notifyNodeDeleted(ZkNodeEvent e) {
                        LocalCache.this.onNodeDeleted(e.getPath());
                    }

                    @Override
                    public void notifyNodeDataAvailable(ZkNodeEvent e) {
                        Stat s = e.getStat();
                        byte[] data = (byte[])e.getData();
                        LocalCache.this.onNodeDataAvailable(e.getPath(), data, s.getVersion(), s.getMzxid());
                    }

                    @Override
                    public void notifyChildrenAvailable(ZkNodeEvent e) {
                        Stat s = e.getStat();
                        List children = (List)e.getData();
                        LocalCache.this.onChildrenAvailable(e.getPath(), children, s.getCversion(), s.getCzxid());
                    }
                }, this.cacheName);
                this.state = State.Initialized;
            }
            catch (Exception ex) {
                L.error("Can't initialize the cache.", (Throwable)ex);
                if (this.m != null) {
                    try {
                        this.m.stop();
                    }
                    catch (Exception ex2) {
                        L.error("Can't stop monitor.", (Throwable)ex2);
                    }
                }
                this.entries.clear();
                this.state = State.Created;
            }
        }
    }

    private void fetch(String node, boolean fetchData, boolean fetchChildren) {
        ZkResult r = null;
        if (fetchData) {
            try {
                r = this.session.execute(new ZkGetDataRequest(node));
                this.handleNodeDataAvailable(node, (byte[])r.getData(), r.getStat().getVersion(), r.getStat().getMzxid());
            }
            catch (ZkNoSuchNodeException ex) {
                L.debug("Node not found: " + node);
                this.handleNodeDeleted(node);
            }
        }
        if (fetchChildren) {
            try {
                r = this.session.execute(new ZkGetChildrenRequest(node));
                List children = (List)r.getData();
                this.handleChildrenAvailable(node, children, r.getStat().getCversion(), r.getStat().getCzxid());
            }
            catch (ZkNoSuchNodeException ex) {
                L.debug("Node not found: " + node);
                this.handleNodeDeleted(node);
            }
        }
    }

    private void fetchData() {
        Stack<String> stack = new Stack<String>();
        LinkedList<CacheEvent> events = new LinkedList<CacheEvent>();
        ArrayList<ZkRequest> reql = new ArrayList<ZkRequest>();
        stack.push(this.nodePath);
        while (!stack.isEmpty() || reql.size() > 0) {
            if (reql.size() > 0) {
                List<ZkResult> rel = this.session.executeList(reql);
                for (int i = 0; i < reql.size(); ++i) {
                    List children;
                    CacheEvent e;
                    String node;
                    ZkRequest req = reql.get(i);
                    ZkResult res = rel.get(i);
                    Throwable ex = res.getThrowable();
                    if (ex != null && !(ex instanceof ZkNoSuchNodeException)) {
                        throw new RuntimeException("Can't fetch data.", ex);
                    }
                    if (ex != null) continue;
                    if (req instanceof ZkGetDataRequest) {
                        node = ((ZkGetDataRequest)req).getPath();
                        e = this.handleNodeDataAvailable(node, (byte[])res.getData(), res.getStat().getVersion(), res.getStat().getMzxid());
                        if (e == null) continue;
                        events.add(e);
                        continue;
                    }
                    node = ((ZkGetChildrenRequest)req).getPath();
                    e = this.handleChildrenAvailable(node, children = (List)res.getData(), res.getStat().getCversion(), res.getStat().getCzxid());
                    if (e != null) {
                        events.add(e);
                    }
                    ListIterator li = children.listIterator(children.size());
                    while (li.hasPrevious()) {
                        stack.push(ZkPath.join(node, (String)li.previous()));
                    }
                }
                reql.clear();
            }
            if (stack.empty()) continue;
            while (!stack.empty()) {
                String node = (String)stack.pop();
                reql.add(new ZkGetDataRequest(node));
                reql.add(new ZkGetChildrenRequest(node));
            }
        }
        for (CacheEvent e : events) {
            for (CacheListener l : this.listeners) {
                try {
                    l.onCacheChanged(e);
                }
                catch (Exception ex) {
                    L.error("Listener failed: " + l, (Throwable)ex);
                }
            }
        }
    }

    private synchronized void onNodeDeleted(String nodePath) {
        if (this.state == State.Destroyed) {
            return;
        }
        CacheEvent e = this.handleNodeDeleted(nodePath);
        if (e != null) {
            for (CacheListener l : this.listeners) {
                try {
                    l.onCacheChanged(e);
                }
                catch (Exception ex) {
                    L.error("Listener failed: {}", (Object)l, (Object)ex);
                }
            }
        }
    }

    private synchronized void onNodeDataAvailable(String nodePath, byte[] data, int version, long txid) {
        if (this.state == State.Destroyed) {
            return;
        }
        CacheEvent e = this.handleNodeDataAvailable(nodePath, data, version, txid);
        if (e == null) {
            return;
        }
        for (CacheListener l : this.listeners) {
            try {
                l.onCacheChanged(e);
            }
            catch (Exception ex) {
                L.error("Listener failed: {}", (Object)l, (Object)ex);
            }
        }
    }

    private synchronized void onChildrenAvailable(String nodePath, List<String> children, int version, long txid) {
        if (this.state == State.Destroyed) {
            return;
        }
        CacheEvent e = this.handleChildrenAvailable(nodePath, children, version, txid);
        if (e == null) {
            return;
        }
        for (CacheListener l : this.listeners) {
            try {
                l.onCacheChanged(e);
            }
            catch (Exception ex) {
                L.error("Listener failed: {}", (Object)l, (Object)ex);
            }
        }
    }

    private CacheEvent handleNodeDeleted(String nodePath) {
        if (this.entries.remove(nodePath) != null) {
            return new NodeDeletedEvent(nodePath);
        }
        return null;
    }

    private CacheEvent handleNodeDataAvailable(String nodePath, byte[] data, int version, long txid) {
        CacheEntry e = this.entries.get(nodePath);
        CacheDataEntry de = null;
        CacheDataEntry nde = new CacheDataEntry(nodePath, data, version, txid);
        NodeAvailableEvent event = null;
        if (e != null) {
            if (e.data == null || version > e.data.getVersion()) {
                de = e.data;
                e.data = nde;
                event = new NodeAvailableEvent(nodePath, de, nde);
            }
        } else {
            e = new CacheEntry();
            e.data = nde;
            event = new NodeAvailableEvent(nodePath, de, nde);
            this.entries.put(nodePath, e);
        }
        return event;
    }

    private CacheEvent handleChildrenAvailable(String nodePath, List<String> children, int version, long txid) {
        CacheEntry e = this.entries.get(nodePath);
        CacheChildrenEntry de = null;
        CacheChildrenEntry nde = new CacheChildrenEntry(nodePath, children, version, txid);
        CacheEvent event = null;
        if (e != null) {
            if (e.children == null || version > e.children.getVersion()) {
                de = e.children;
                e.children = nde;
                new ChildrenAvailableEvent(nodePath, de, nde);
            }
        } else {
            e = new CacheEntry();
            e.children = nde;
            new ChildrenAvailableEvent(nodePath, de, nde);
            this.entries.put(nodePath, e);
        }
        return event;
    }

    private static class CacheEntry {
        CacheDataEntry data;
        CacheChildrenEntry children;

        private CacheEntry() {
        }
    }

    private static enum State {
        Created,
        Initialized,
        Initializing,
        Destroyed;

    }

    public static class Flags {
        public static final int NONE = 0;
        public static final int REFRESH_CONTENT = 1;
    }
}

