/*
 * Decompiled with CFR 0.152.
 */
package com.ez.keeper.client;

import com.ez.keeper.client.ZkEvent;
import com.ez.keeper.client.ZkEventListener;
import com.ez.keeper.client.ZkEventListenerAdapter;
import com.ez.keeper.client.ZkEventType;
import com.ez.keeper.client.ZkMonitor;
import com.ez.keeper.client.ZkNodeEvent;
import com.ez.keeper.client.ZkPath;
import com.ez.keeper.client.ZkRequestMonitor;
import com.ez.keeper.client.ZkSession;
import com.ez.keeper.client.request.ZkGetChildrenRequest;
import com.ez.keeper.client.request.ZkGetDataRequest;
import com.ez.keeper.client.request.ZkNodeExistsRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTreeMonitor
implements ZkMonitor {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ZkTreeMonitor.class);
    private final Object stateGuard = new Object();
    private final IStateHandler CREATED = new StateHandler(State.CREATED){

        @Override
        public void onStart() {
            ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.SENDING_EXISTS, "onStart");
        }
    };
    private final IStateHandler SENDING_EXISTS = new StateHandler(State.SENDING_EXISTS){

        @Override
        public void onEnterState() {
            ZkTreeMonitor.this.startWaitForRoot();
            ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.WAIT_EXISTS_REQUEST, "onEnterState");
        }
    };
    private final IStateHandler WAIT_EXISTS_REQUEST = new StateHandler(State.WAIT_EXISTS_REQUEST){

        @Override
        public void onRootNodeAvailable(boolean exists) {
            if (exists) {
                ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.WAIT_CHANGE, "notifyNodeStatAvailable");
            } else {
                ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.WAIT_CREATE, "notifyNodeStatAvailable");
            }
        }
    };
    private final IStateHandler WAIT_CHANGE = new StateHandler(State.WAIT_CHANGE){

        @Override
        public void onEnterState() {
            this.m.onRootNodeCreated();
        }

        @Override
        public void onRootNodeDeleted() {
            this.m.onRootNodeDeleted();
            ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.WAIT_CREATE, "onNodeDeleted");
        }

        @Override
        public void onNodeDeleted(String path) {
            this.m.onNodeDeleted(path);
        }

        @Override
        public void onNodeCreated(String path) {
            this.m.onNodeCreated(path);
        }

        @Override
        public void onChildrenChanged(String path, List<String> children) {
            this.m.onChildrenChanged(path, children);
        }
    };
    private final IStateHandler WAIT_CREATE = new StateHandler(State.WAIT_CREATE){

        @Override
        public void onRootNodeCreated() {
            ZkTreeMonitor.this.moveState(ZkTreeMonitor.this.WAIT_CHANGE, "onRootNodeCreated");
        }
    };
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private GuardedStateHandler stateHandler = new GuardedStateHandler(this.CREATED);
    private ZkSession session;
    private String watcherName;
    private ZkEventListener clientListener;
    private String rootPath;
    private Node rootNode;
    private ZkEventListener dataListener = new NodeEventListener(this);
    private ZkEventListener childrenListener = new ChildrenEventListener(this.dataListener);
    private ZkRequestMonitor rootExistsMonitor;
    private Integer maxLevel;

    public ZkTreeMonitor(ZkSession session, String nodePath, ZkEventListener eventListener, String watcherName) {
        this(session, nodePath, eventListener, watcherName, null);
    }

    public ZkTreeMonitor(ZkSession session, String nodePath, ZkEventListener eventListener, String watcherName, Integer maxLevel) {
        if (session == null) {
            throw new IllegalArgumentException("session");
        }
        if (nodePath == null) {
            throw new IllegalArgumentException("nodePath");
        }
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener");
        }
        if (watcherName == null) {
            throw new IllegalArgumentException("watcherName");
        }
        this.session = session;
        this.watcherName = watcherName;
        this.clientListener = eventListener;
        this.rootPath = nodePath;
        this.maxLevel = maxLevel;
        this.rootExistsMonitor = new ZkRequestMonitor(this.session, new ZkNodeExistsRequest(this.rootPath), new RootNodeEventListener(this), this.rootPath);
    }

    @Override
    public void start() {
        this.rootNode = this.createRootNode();
        this.nodes.put(this.rootNode.path, this.rootNode);
        this.stateHandler.onStart();
    }

    @Override
    public void stop() {
        for (Node n : this.nodes.values()) {
            try {
                this.stopNode(n);
            }
            catch (Exception ex) {
                L.error("Can't stop node: " + n, (Throwable)ex);
            }
        }
        try {
            this.stopWaitForRoot();
        }
        catch (Exception ex) {
            L.error("Unexpected error.", (Throwable)ex);
        }
    }

    void onChildrenChanged(String parentPath, List<String> children) {
        HashSet<String> initialNodes = new HashSet<String>();
        Node parentNode = this.nodes.get(parentPath);
        initialNodes.addAll(parentNode.children);
        for (String child : children) {
            String fullPath = ZkPath.join(parentPath, child);
            if (parentNode.children.contains(child)) continue;
            L.debug(String.format("Node %s: new child: %s", parentPath, child));
            Node childNode = this.createNode(parentNode, fullPath);
            parentNode.children.add(child);
            this.nodes.put(fullPath, childNode);
            this.startNode(childNode);
        }
        initialNodes.removeAll(children);
        for (String child : initialNodes) {
            String fullPath = ZkPath.join(parentPath, child);
            L.debug(String.format("Node %s: child removed: %s", parentPath, child));
            Node node = this.nodes.remove(fullPath);
            if (node == null) {
                L.debug("Node not found: " + fullPath);
                continue;
            }
            this.destroyNode(node);
        }
    }

    void onNodeDeleted(String node) {
        L.debug(String.format("Node %s: deleted", node));
    }

    void onNodeCreated(String node) {
        L.debug(String.format("Node %s: create", node));
    }

    void onRootNodeCreated() {
        this.startNode(this.rootNode);
    }

    void onRootNodeDeleted() {
        this.stopNode(this.rootNode);
    }

    private Node createRootNode() {
        ZkRequestMonitor dataMonitor = new ZkRequestMonitor(this.session, new ZkGetDataRequest(this.rootPath), this.dataListener, this.rootPath);
        ZkRequestMonitor childrenMonitor = new ZkRequestMonitor(this.session, new ZkGetChildrenRequest(this.rootPath), this.childrenListener, this.rootPath);
        return new Node(0, this.rootPath, dataMonitor, childrenMonitor);
    }

    private void startWaitForRoot() {
        this.rootExistsMonitor.start();
    }

    private void stopWaitForRoot() {
        this.rootExistsMonitor.stop();
    }

    private void startNode(Node node) {
        node.dataMonitor.start();
        if (node.childrenMonitor != null) {
            node.childrenMonitor.start();
        }
    }

    private void destroyNode(Node node) {
        this.stopNode(node);
    }

    private void stopNode(Node node) {
        try {
            node.dataMonitor.stop();
        }
        catch (Exception ex) {
            L.error("Can't stop data monitor for " + node.path);
        }
        if (node.childrenMonitor != null) {
            try {
                node.childrenMonitor.stop();
            }
            catch (Exception ex) {
                L.error("Can't stop children monitor for " + node.path);
            }
        }
    }

    private Node createNode(Node parent, String path) {
        ZkRequestMonitor childrenMonitor = null;
        ZkRequestMonitor dataMonitor = new ZkRequestMonitor(this.session, new ZkGetDataRequest(path), this.dataListener, path);
        if (this.maxLevel == null || parent.level < this.maxLevel) {
            childrenMonitor = new ZkRequestMonitor(this.session, new ZkGetChildrenRequest(path), this.childrenListener, path);
        }
        return new Node(parent.level + 1, path, dataMonitor, childrenMonitor);
    }

    private void dispatchEvent(ZkEvent e) {
        try {
            this.clientListener.notifyEvent(e);
        }
        catch (Exception ex) {
            L.error("Uncaught error during listener call.", (Throwable)ex);
        }
    }

    protected String fmsg(String msg) {
        return String.format("%s: %s", this.watcherName, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveState(IStateHandler newState, String onEvent) {
        L.debug(this.fmsg("state transition {}->{} on {}"), new Object[]{this.stateHandler.getState(), newState.getState().name(), onEvent});
        Object object = this.stateGuard;
        synchronized (object) {
            this.stateHandler.onLeaveState();
            this.stateHandler.setStateHandler(newState);
            this.stateHandler.onEnterState();
        }
    }

    private static class EventInterceptor
    implements ZkEventListener {
        ZkEventListener target;

        EventInterceptor(ZkEventListener target) {
            this.target = target;
        }

        @Override
        public void notifyEvent(ZkEvent event) {
            this.target.notifyEvent(event);
        }
    }

    private static class ChildrenEventListener
    extends EventInterceptor {
        ChildrenEventListener(ZkEventListener target) {
            super(target);
        }

        @Override
        public void notifyEvent(ZkEvent event) {
            ZkEventType t = event.getType();
            if (t != ZkEventType.NodeChildrenChanged && t != ZkEventType.NodeChildrenAvailable) {
                L.trace("Children listener: event discarded: " + event);
            } else {
                this.target.notifyEvent(event);
            }
        }
    }

    private class NodeEventListener
    extends ZkEventListenerAdapter {
        ZkTreeMonitor m;

        NodeEventListener(ZkTreeMonitor m) {
            this.m = m;
        }

        @Override
        public void notifyChildrenAvailable(ZkNodeEvent e) {
            this.m.stateHandler.onChildrenChanged(e.getPath(), (List)e.getData());
        }

        @Override
        public void notifyNodeDataAvailable(ZkNodeEvent e) {
            this.m.stateHandler.onDataChanged(e.getPath());
        }

        @Override
        public void notifyNodeDeleted(ZkNodeEvent e) {
            this.m.stateHandler.onNodeDeleted(e.getPath());
        }

        @Override
        public void notifyNodeCreated(ZkNodeEvent e) {
            this.m.stateHandler.onNodeCreated(e.getPath());
        }

        @Override
        public void notifyEvent(ZkEvent e) {
            super.notifyEvent(e);
            this.m.dispatchEvent(e);
        }
    }

    private class RootNodeEventListener
    extends ZkEventListenerAdapter {
        ZkTreeMonitor m;

        RootNodeEventListener(ZkTreeMonitor m) {
            this.m = m;
        }

        @Override
        public void notifyNodeStatAvailable(ZkNodeEvent e) {
            this.m.stateHandler.onRootNodeAvailable(e.getStat() != null);
        }

        @Override
        public void notifyNodeCreated(ZkNodeEvent e) {
            this.m.stateHandler.onRootNodeCreated();
        }
    }

    private class Node {
        String path;
        List<String> children = new LinkedList<String>();
        ZkMonitor dataMonitor;
        ZkMonitor childrenMonitor;
        int level;

        public Node(int level, String path, ZkMonitor dataMonitor, ZkMonitor childrenMonitor) {
            this.level = level;
            this.path = path;
            this.dataMonitor = dataMonitor;
            this.childrenMonitor = childrenMonitor;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("[");
            b.append("path: ");
            b.append(this.path);
            b.append("]");
            return b.toString();
        }
    }

    private class StateHandler
    implements IStateHandler {
        ZkTreeMonitor m;
        State state;

        public StateHandler(State state) {
            this.m = ZkTreeMonitor.this;
            this.state = state;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public void onLeaveState() {
        }

        @Override
        public void onEnterState() {
        }

        @Override
        public void onStart() {
            this.logInvalidEvent("onStart");
        }

        @Override
        public void onRootNodeAvailable(boolean exists) {
            this.logInvalidEvent("onRootNodeAvailable");
        }

        @Override
        public void onRootNodeDeleted() {
            this.logInvalidEvent("onRootDeleted");
        }

        @Override
        public void onRootNodeCreated() {
            this.logInvalidEvent("onRootCreated");
        }

        @Override
        public void onNodeDeleted(String path) {
            this.logInvalidEvent("onNodeDeleted");
        }

        @Override
        public void onChildrenChanged(String path, List<String> children) {
            this.logInvalidEvent("onChildrenChanged");
        }

        @Override
        public void onNodeCreated(String path) {
            this.logInvalidEvent("onNodeCreated");
        }

        @Override
        public void onDataChanged(String path) {
            this.logInvalidEvent("onDataChanged");
        }

        protected void logInvalidEvent(String event) {
            L.debug(ZkTreeMonitor.this.fmsg("State {}: unhandled / ignored event {}"), (Object)this.state, (Object)event);
        }
    }

    private class GuardedStateHandler
    implements IStateHandler {
        IStateHandler sh;
        Object stateGuard;

        public GuardedStateHandler(IStateHandler sh) {
            this.stateGuard = ZkTreeMonitor.this.stateGuard;
            this.sh = sh;
        }

        public void setStateHandler(IStateHandler sh) {
            this.sh = sh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public State getState() {
            Object object = this.stateGuard;
            synchronized (object) {
                return this.sh.getState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveState() {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onLeaveState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEnterState() {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onEnterState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStart() {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRootNodeAvailable(boolean exists) {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onRootNodeAvailable(exists);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRootNodeDeleted() {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onRootNodeDeleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRootNodeCreated() {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onRootNodeCreated();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodeDeleted(String path) {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onNodeDeleted(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChildrenChanged(String path, List<String> children) {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onChildrenChanged(path, children);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNodeCreated(String path) {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onNodeCreated(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataChanged(String path) {
            Object object = this.stateGuard;
            synchronized (object) {
                this.sh.onDataChanged(path);
            }
        }
    }

    private static interface IStateHandler {
        public State getState();

        public void onLeaveState();

        public void onEnterState();

        public void onStart();

        public void onRootNodeAvailable(boolean var1);

        public void onRootNodeDeleted();

        public void onRootNodeCreated();

        public void onNodeDeleted(String var1);

        public void onChildrenChanged(String var1, List<String> var2);

        public void onNodeCreated(String var1);

        public void onDataChanged(String var1);
    }

    public static enum State {
        CREATED("CREATED"),
        SENDING_EXISTS("SENDING_EXISTS"),
        WAIT_EXISTS_REQUEST("WAIT_EXISTS_REQUEST"),
        WAIT_CREATE("WAIT_CREATE"),
        WAIT_CHANGE("WAIT_CHANGE"),
        FINISHED("FINISHED");

        private String name;

        public String getStateName() {
            return this.name;
        }

        private State(String name) {
            this.name = name;
        }
    }
}

